<?php
session_start();
require_once '../config/config.php';
require_once '../config/koneksi.php';

// Debug untuk melihat parameter yang diterima
// echo "<pre>";
// print_r($_GET);
// echo "</pre>";

// Cek parameter id dengan penanganan error yang lebih baik
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "<script>
            alert('ID Surat tidak ditemukan! Silakan pilih surat tugas terlebih dahulu.');
            window.location.href = '../sppd_muka/sppd_muka.php';
          </script>";
    exit;
}

$id_surat = mysqli_real_escape_string($conn, $_GET['id']);

// Cek keberadaan surat di database
$check_query = "SELECT COUNT(*) as count FROM surat_tugas WHERE id_surat = ?";
$check_stmt = mysqli_prepare($conn, $check_query);
mysqli_stmt_bind_param($check_stmt, "s", $id_surat);
mysqli_stmt_execute($check_stmt);
$check_result = mysqli_stmt_get_result($check_stmt);
$row_count = mysqli_fetch_assoc($check_result)['count'];

if ($row_count == 0) {
    echo "<script>
            alert('Surat Tugas dengan ID tersebut tidak ditemukan dalam database!');
            window.location.href = '../sppd_muka/sppd_muka.php';
          </script>";
    exit;
}

// Query untuk mengambil data
$query = "SELECT 
            st.*,
            GROUP_CONCAT(DISTINCT CONCAT_WS('|', 
                p.nama_pegawai,
                COALESCE(dst.tujuan_pegawai, '')
            ) ORDER BY 
                CASE 
                    WHEN p.jabatan LIKE '%Kepala%' THEN 1
                    WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                    WHEN p.jabatan LIKE '%Kabid%' THEN 3
                    WHEN p.jabatan LIKE '%Kasubbag%' THEN 4
                    WHEN p.jabatan LIKE '%Kasi%' THEN 5
                    ELSE 6
                END ASC
                SEPARATOR ';;') as pegawai_data
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "s", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result) {
    echo "<script>
            alert('Terjadi kesalahan dalam mengambil data: " . mysqli_error($conn) . "');
            window.location.href = '../sppd_muka/sppd_muka.php';
          </script>";
    exit;
}

$data = mysqli_fetch_assoc($result);

if (!$data) {
    echo "<script>
            alert('Data surat tidak ditemukan!');
            window.location.href = '../sppd_muka/sppd_muka.php';
          </script>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pilihan Cetak SPPD Belakang</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <?php include '../includes/header.php' ?>
    <style>
        /* Main Background */
        body {
            background: linear-gradient(135deg, #f6f9ff 0%, #f8f9fa 100%);
            min-height: 100vh;
        }

        /* Header Card Styling */
        .card {
            border: none;
            border-radius: 20px;
            box-shadow: 0 8px 32px rgba(31, 38, 135, 0.1);
            backdrop-filter: blur(10px);
            margin-bottom: 30px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border-radius: 20px 20px 0 0 !important;
            padding: 25px;
            border: none;
        }

        .card-header h5 {
            color: white;
            font-weight: 600;
            font-size: 1.25rem;
            margin: 0;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .card-header h5 i {
            font-size: 1.5rem;
        }

        /* Info Section Styling */
        .info-section {
            background: rgba(255, 255, 255, 0.9);
            padding: 25px;
            border-radius: 15px;
            margin-bottom: 30px;
        }

        .info-section strong {
            color: #1e293b;
        }

        /* Option Cards */
        .option-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 20px;
            padding: 30px;
            height: 100%;
            transition: all 0.3s ease;
        }

        .option-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 35px rgba(31, 38, 135, 0.15);
        }

        /* Icons Styling */
        .icon-wrapper {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, rgba(14, 165, 233, 0.2) 0%, rgba(45, 212, 191, 0.2) 100%);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
        }

        .icon-wrapper i {
            font-size: 2.5rem;
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        /* Content Styling */
        .card-title {
            color: #1e293b;
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 15px;
        }

        .feature-list {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }

        .feature-list li {
            padding: 8px 0;
            color: #64748b;
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .feature-list li i {
            color: #2dd4bf;
            font-size: 0.875rem;
        }

        /* Button Styling */
        .btn-download {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 12px;
            font-weight: 500;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            transition: all 0.3s ease;
        }

        .btn-download:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(14, 165, 233, 0.2);
        }

        .btn-kembali {
            background: rgba(203, 213, 225, 0.3);
            color: #64748b;
            border: none;
            padding: 12px 24px;
            border-radius: 12px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s ease;
        }

        .btn-kembali:hover {
            background: rgba(203, 213, 225, 0.5);
            color: #1e293b;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
  
    
    <div class="container mt-4">
        <!-- Info Card -->
        <div class="card">
            <div class="card-header">
                <h5><i class="bi bi-info-circle"></i> Informasi SPPD</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong><i class="bi bi-file-text"></i> Nomor SPPD:</strong> <?= htmlspecialchars($data['no_sppd']) ?></p>
                        <p><strong><i class="bi bi-calendar"></i> Tanggal Surat:</strong> <?= date('d-m-Y', strtotime($data['tanggal_surat'])) ?></p>
                        <p><strong><i class="bi bi-geo-alt"></i> Tujuan:</strong> <?php 
                            if ($data['jenis_surat'] === 'Dalam Daerah Dalam Provinsi') {
                                $tujuan_list = [];
                                if (!empty($data['pegawai_data'])) {
                                    $pegawai_array = explode(';;', $data['pegawai_data']);
                                    foreach ($pegawai_array as $index => $pegawai) {
                                        $pegawai_info = explode('|', $pegawai);
                                        $tujuan_pegawai = isset($pegawai_info[1]) ? $pegawai_info[1] : '';
                                        if (!empty($tujuan_pegawai)) {
                                            $tujuan_list[] = ($index + 1) . ". " . htmlspecialchars($tujuan_pegawai);
                                        }
                                    }
                                }
                                if (!empty($tujuan_list)) {
                                    echo "<br>" . implode("<br>", $tujuan_list);
                                } else {
                                    echo '<span class="text-secondary">-</span>';
                                }
                            } else {
                                if (!empty($data['tempat_kegiatan'])) {
                                    echo htmlspecialchars($data['tempat_kegiatan']);
                                } else if (!empty($data['tujuan'])) {
                                    echo htmlspecialchars($data['tujuan']);
                                } else {
                                    echo '<span class="text-secondary">-</span>';
                                }
                            }
                        ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong><i class="bi bi-people"></i> Pegawai:</strong></p>
                        <?php 
                        if (!empty($data['pegawai_data'])) {
                            $pegawai_array = explode(';;', $data['pegawai_data']);
                            foreach ($pegawai_array as $index => $pegawai) {
                                $pegawai_info = explode('|', $pegawai);
                                $nama_pegawai = $pegawai_info[0];
                                echo "<div class='ms-4'>" . ($index + 1) . ". " . htmlspecialchars($nama_pegawai) . "</div>";
                            }
                        } else {
                            echo "<div class='ms-4'><span class='text-secondary'>-</span></div>";
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>

        <h2 class="mb-4 text-center">Pilih Jenis Cetak SPPD Belakang <br> <small class="text-muted" style="font-size: 0.5em; font-style: italic;">Maaf untuk tembah sppd tidak 100% akurat dikarenakan perbedaan format dan margin sppd yang anda gunakan</small></h2>
        
        <div class="row">
            <!-- SPPD Belakang Lengkap -->
            <div class="col-md-4 mb-4">
                <div class="option-card">
                    <div class="icon-wrapper">
                        <i class="bi bi-file-earmark-text"></i>
                    </div>
                    <h5 class="card-title text-center">SPPD Belakang Lengkap</h5>
                    <ul class="feature-list">
                        <li><i class="bi bi-check-circle"></i> Tanggal berangkat & kembali</li>
                        <li><i class="bi bi-check-circle"></i> Tujuan perjalanan</li>
                        <li><i class="bi bi-check-circle"></i> Detail pegawai</li>
                        <li><i class="bi bi-check-circle"></i> Informasi lengkap lainnya</li>
                    </ul>
                    <a href="download_excel.php?id=<?= $id_surat ?>&tipe=lengkap" class="btn btn-download">
                        <i class="bi bi-download"></i> Download Format Excel
                    </a>
                </div>
            </div>

            <!-- SPPD Belakang Kosong -->
            <div class="col-md-4 mb-4">
                <div class="option-card">
                    <div class="icon-wrapper">
                        <i class="bi bi-file-earmark"></i>
                    </div>
                    <h5 class="card-title text-center">SPPD Belakang Kosong</h5>
                    <ul class="feature-list">
                        <li><i class="bi bi-check-circle"></i> Format standar SPPD</li>
                        <li><i class="bi bi-check-circle"></i> Tanpa data terisi</li>
                        <li><i class="bi bi-check-circle"></i> Siap untuk pengisian manual</li>
                        <li><i class="bi bi-check-circle"></i> Format sesuai ketentuan</li>
                    </ul>
                    <a href="download_excel.php?id=<?= $id_surat ?>&tipe=kosong" class="btn btn-download">
                        <i class="bi bi-download"></i> Download Format Excel
                    </a>
                </div>
            </div>

            <!-- Form Tembak SPPD -->
            <div class="col-md-4 mb-4">
                <div class="option-card">
                    <div class="icon-wrapper">
                        <i class="bi bi-pencil-square"></i>
                    </div>
                    <h5 class="card-title text-center">Form Tembak SPPD</h5>
                    <ul class="feature-list">
                        <li><i class="bi bi-check-circle"></i> Isi tanggal manual</li>
                        <li><i class="bi bi-check-circle"></i> Tentukan tujuan baru</li>
                        <li><i class="bi bi-check-circle"></i> Sesuaikan informasi</li>
                        <li><i class="bi bi-check-circle"></i> Untuk keperluan khusus</li>
                    </ul>
                    <a href="download_excel.php?id=<?= $id_surat ?>&tipe=form" class="btn btn-download">
                        <i class="bi bi-download"></i> Download Format Excel
                    </a>
                </div>
            </div>
        </div>

        <!-- Tombol Kembali -->
        <div class="text-center mt-4 mb-5">
            <a href="../sppd_muka/sppd_muka.php" class="btn btn-kembali">
                <i class="bi bi-arrow-left"></i> Kembali
            </a>
        </div>
    </div>

    <?php include '../includes/footer.php' ?>
</body>
</html> 