<?php
session_start();
require_once '../config/config.php';

// Ambil ID surat tugas dari parameter URL
$id_surat = isset($_GET['id']) ? $_GET['id'] : die('ID Surat tidak ditemukan');

// Query untuk mengambil data surat tugas dan pegawai
$query = "SELECT 
            st.*,
            p.nama_pegawai,
            p.nip,
            p.jabatan,
            p.golongan,
            dst.tujuan_pegawai
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE st.id_surat = ?
          ORDER BY 
            CASE 
                WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
                WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
                WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
                WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
                WHEN p.jabatan LIKE '%Sopir Kepala Dinas%' OR p.jabatan LIKE '%sopir%' THEN 6
                WHEN p.jabatan LIKE '%Pengawas%' THEN 7
                
                ELSE 8
            END,
            CASE 
                WHEN p.golongan LIKE 'IV/%' THEN 1
                WHEN p.golongan LIKE 'III/%' THEN 2
                WHEN p.golongan LIKE 'II/%' THEN 3
                WHEN p.golongan LIKE 'I/%' THEN 4
                ELSE 5
            END,
            CASE 
                WHEN p.golongan LIKE '%/d' OR p.golongan LIKE '%/D' THEN 1
                WHEN p.golongan LIKE '%/c' OR p.golongan LIKE '%/C' THEN 2
                WHEN p.golongan LIKE '%/b' OR p.golongan LIKE '%/B' THEN 3
                WHEN p.golongan LIKE '%/a' OR p.golongan LIKE '%/A' THEN 4
                ELSE 5
            END,
            p.nama_pegawai ASC";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Data tidak ditemukan");
}

// Simpan semua data pegawai dalam array
$pegawai_list = [];
while($row = mysqli_fetch_assoc($result)) {
    $pegawai_list[] = $row;
}

// Data pertama untuk informasi surat
$data = $pegawai_list[0];

// Mengambil lama tugas langsung dari database
$lama_tugas = $data['lama_perjalanan'];

function tanggal_indonesia($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

function terbilang($angka) {
    $bilangan = array(
        '',
        'satu',
        'dua',
        'tiga',
        'empat',
        'lima',
        'enam',
        'tujuh',
        'delapan',
        'sembilan',
        'sepuluh',
        'sebelas'
    );

    if ($angka < 12) {
        return $bilangan[$angka];
    } elseif ($angka < 20) {
        return $bilangan[$angka - 10] . ' belas';
    } elseif ($angka < 100) {
        return $bilangan[floor($angka / 10)] . ' puluh ' . $bilangan[$angka % 10];
    }
    return strval($angka);
}

// Fungsi untuk menentukan pangkat berdasarkan golongan
function get_pangkat($golongan) {
    $pangkat = array(
        'IV/c' => 'Pembina Utama Muda',
        'IV/b' => 'Pembina Tingkat I',
        'IV/a' => 'Pembina',
        'III/d' => 'Penata Tingkat I',
        'III/c' => 'Penata',
        'III/b' => 'Penata Muda Tingkat I',
        'III/a' => 'Penata Muda',
        // Tambahkan pangkat lainnya sesuai kebutuhan
    );
    
    return isset($pangkat[$golongan]) ? $pangkat[$golongan] : '';
}

// Loop untuk setiap pegawai
foreach($pegawai_list as $index => $pegawai):
?>
<!DOCTYPE html>
<html lang="en">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SPPD</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }
        
        html {
            display: flex;
            justify-content: center;
            width: 210mm;
        }
        
        body {
            font-family: Times New Roman, serif;
            line-height: 1.5;
            font-size: 12pt;
            margin: 20mm 20mm 20mm 20mm;
            padding: 0;
            width: 100%;
        }
        
        .kop-surat {
            text-align: center;
            margin: 0 0 10px 0;
            border-bottom: 2px solid black;
            padding: 0 0 10px 0;
            position: relative;
            width: 100%;
        }
        
        .logo {
            position: absolute;
            left: 0;
            top: 2mm;
            width: 70px;
            height: auto;
        }
        
        .kop-header {
            font-size: 14pt;
            font-weight: bold;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        .kop-header1 {
            font-size: 18pt;
            font-weight: bold;
            margin: 0 0 3px 0;
            line-height: 1.2;
        }
        
        .kop-detail {
            font-size: 10pt;
            font-style: italic;
            line-height: 1.2;
            margin: 0 0 2px 0;
        }
        
        .nomor-surat {
            text-align: right;
            margin: 15px 0;
            padding-right: 0;
        }
        
        .nomor-container {
            display: inline-block;
            text-align: left;
        }
        
        .judul {
            text-align: center;
            font-weight: bold;
            margin: 15px 0;
            text-transform: uppercase;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 10px auto;
        }
        
        table, th, td {
            border: 1px solid black;
        }
        
        td {
            padding: 8mm;
            vertical-align: top;
        }
        
        td:first-child {
            width: 35px;
            text-align: center;
            padding: 2mm;
        }
        
        td:nth-child(2) {
            width: 180px;
            padding: 2mm;
        }
        
        td[colspan="2"] {
            padding: 2mm;
        }
        
        .ttd {
            margin-top: 22.5mm;
            text-align: right;
            padding-right: 40px;
        }
        
        .ttd-content {
            display: inline-block;
            text-align: left;
            width: 250px;
        }
        
        .ttd p {
            margin: 0;
            line-height: 1.5;
        }
        
        .ttd .jabatan {
            margin-top: 80px;
        }
        
        .multi-line {
            padding: 12px 10px;
        }
        
        .multi-line br {
            margin-bottom: 8px;
            display: block;
            content: "";
        }
        
        .long-content {
            min-height: 40px;
            line-height: 1.5;
            white-space: pre-line;
            padding: 12px 10px;
            text-align: justify;
        }
        
        .list-content {
            margin: 0;
            padding-left: 20px;
            text-align: left;
        }
        
        .sub-items {
            padding-left: 15px;
            text-align: left;
        }
        
        .sub-item {
            margin-bottom: 8px;
            text-align: left;
        }
        
        .pengikut td:not(:first-child) {
            text-align: left;
        }
        
        @media print {
            @page {
                size: 215.9mm 330mm;
                margin: 2mm 8mm 8mm 8mm;
            }
            
            html {
                width: 215.9mm;
            }
            
            body {
                margin: 0;
                width: 100%;
            }
            
            .page-break {
                page-break-before: always;
            }
        }
    </style>
</head>
<body>
    <div class="kop-surat">
        <img src="../assets/img/logo.png" class="logo">
        <div class="kop-header">PEMERINTAH KABUPATEN BALANGAN</div>
        <div class="kop-header1">DINAS PENDIDIKAN DAN KEBUDAYAAN</div>
        <div class="kop-detail"><i>Jln. Jenderal A. Yani Km 2,5 Kelurahan Batu Piring Kecamatan Paringin Selatan 71619</i></div>
        <div class="kop-detail"><i>Kabupaten Balangan Telp: 0526-2028193 Fax: 0526-2028192</i></div>
    </div>

    <div class="nomor-surat">
        <div class="nomor-container">
            Nomor : <?= isset($pegawai['no_sppd']) ? $pegawai['no_sppd'] : '-' ?>
        </div>
    </div>

    <div class="judul">
        SURAT PERINTAH PERJALANAN DINAS<br>
        ( S P P D )
    </div>

    <table>
        <tr>
            <td>1.</td>
            <td>Pengguna Anggaran/Kuasa Pengguna Anggaran</td>
            <td colspan="2">Kepala Dinas Pendidikan dan Kebudayaan Kab. Balangan</td>
        </tr>
        <tr>
            <td>2.</td>
            <td>Nama/NIP Pegawai yang diperintahkan</td>
            <td colspan="2"><?= $pegawai['nama_pegawai'] ?> / <?= $pegawai['nip'] ?></td>
        </tr>
        <tr class="multi-line">
            <td>3.</td>
            <td>
                
                    a. Pangkat dan Golongan<br>
                    b. Jabatan / Instansi<br>
                    c. Tingkat Biaya Perjalanan Dinas
              
            </td>
            <td colspan="2">
            
                    a. <?= isset($pegawai['golongan']) ? $pegawai['golongan'] : '-' ?><br>
                    b. <?= isset($pegawai['jabatan']) ? $pegawai['jabatan'] : '-' ?><br>
                    c. -
               
            </td>
        </tr>
        <tr>
            <td>4.</td>
            <td>Maksud Perjalanan Dinas</td>
            <td colspan="2" class="long-content"><?= isset($pegawai['maksud']) ? nl2br(htmlspecialchars($pegawai['maksud'])) : '-' ?></td>
        </tr>
        <tr>
            <td>5.</td>
            <td>Alat angkut yang dipergunakan</td>
            <td colspan="2"><?php 
                if (strpos(strtolower($pegawai['jabatan']), 'kepala dinas') !== false || 
                    strpos(strtolower($pegawai['jabatan']), 'kabid') !== false || 
                    strpos(strtolower($pegawai['jabatan']), 'kepala bidang') !== false ||
                    strpos(strtolower($pegawai['jabatan']), 'kabag') !== false ||
                    strpos(strtolower($pegawai['jabatan']), 'kepala bagian') !== false ||
                    strpos(strtolower($pegawai['jabatan']), 'sopir') !== false) {
                    echo "Kendaraan Dinas";
                } else {
                    echo "Kendaraan Umum";
                }
            ?></td>
        </tr>
        <tr>
            <td>6.</td>
            <td>a. Tempat berangkat<br>
                b. Tempat tujuan</td>
            <td colspan="2">a. Dinas Pendidikan & Kebudayaan Kabupaten Balangan<br>
                b. <?php 
                    if ($pegawai['jenis_surat'] === 'Dalam Daerah Dalam Provinsi') {
                        echo !empty($pegawai['tujuan_pegawai']) ? htmlspecialchars($pegawai['tujuan_pegawai']) : '-';
                    } else {
                        if (!empty($pegawai['tempat_kegiatan'])) {
                            echo htmlspecialchars($pegawai['tempat_kegiatan']);
                        } else if (!empty($pegawai['tujuan'])) {
                            echo htmlspecialchars($pegawai['tujuan']);
                        } else {
                            echo '-';
                        }
                    }
                ?></td>
        </tr>
        <tr>
            <td>7.</td>
            <td>a. Lamanya Perjalanan Dinas<br>
                b. Tanggal berangkat<br>
                c. Tanggal harus kembali/tiba di tempat</td>
            <td colspan="2">a. <?= $lama_tugas ?> (<?= $lama_tugas > 1 ? ucfirst(terbilang($lama_tugas)) : 'Satu' ?>) Hari<br>
                b. <?= isset($pegawai['tanggal_berangkat']) ? tanggal_indonesia($pegawai['tanggal_berangkat']) : '-' ?><br>
                c. <?= isset($pegawai['tanggal_kembali']) ? tanggal_indonesia($pegawai['tanggal_kembali']) : '-' ?></td>
        </tr>
        <tr class="pengikut">
            <td>8.</td>
            <td>Pengikut</td>
            <td style="width: 25%;">Tanggal Lahir</td>
            <td>Keterangan</td>
        </tr>
        <tr class="pengikut">
            <td></td>
            <td>1.<br>2.</td>
            <td></td>
            <td></td>
        </tr>
        <tr>
            <td>9.</td>
            <td>Pembebanan Anggaran<br>
                a. Instansi<br>
                b. Kode Rekening</td>
            <td colspan="2">
                <br>a. Dinas Pendidikan dan Kebudayaan Kabupaten Balangan<br>
                b. <?= isset($pegawai['no_sub_kegiatan']) ? $pegawai['no_sub_kegiatan'] : '-' ?>
            </td>
        </tr>
        <tr>
            <td>10.</td>
            <td>Keterangan lain-lain</td>
            <td colspan="2">-</td>
        </tr>
    </table>

    <div class="ttd">
        <div class="ttd-content">
            <p>
                Ditetapkan di : Paringin<br>
                Pada Tanggal : <?= isset($pegawai['tanggal_surat']) ? tanggal_indonesia($pegawai['tanggal_surat']) : date('d-m-Y') ?>
                <br>Kepala,<br><br><br><br>
                <u>H. ABIJI, S.Pd, MAP</u><br>
                Pembina Utama Muda / IV c<br>
                NIP. 19580813 198412 1 002
            </p>
        </div>
    </div>

    <script>
        window.onload = function() {
            window.print();
            setTimeout(function() {
                window.close();
            }, 100);
        }
    </script>
</body>
</html>
<?php endforeach; ?> 