<?php
session_start();
require_once '../config/config.php';

// Ambil ID surat tugas dari parameter URL
$id_surat = isset($_GET['id']) ? $_GET['id'] : die('ID Surat tidak ditemukan');

// Query untuk mengambil data surat tugas dan pegawai
$query = "SELECT 
            st.*,
            p.nama_pegawai,
            p.nip,
            p.jabatan,
            p.golongan,
            dst.tujuan_pegawai,
            st.no_sub_kegiatan
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE st.id_surat = ?
          ORDER BY 
            CASE 
                WHEN p.jabatan LIKE '%Kepala Dinas%' THEN 1
                WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                WHEN p.jabatan LIKE '%Kepala Bidang%' OR p.jabatan LIKE '%Kabid%' THEN 3
                WHEN p.jabatan LIKE '%Kepala Sub Bagian%' OR p.jabatan LIKE '%Kasubbag%' THEN 4
                WHEN p.jabatan LIKE '%Kepala Seksi%' OR p.jabatan LIKE '%Kasi%' THEN 5
                WHEN p.jabatan LIKE '%Pengawas%' THEN 6
                WHEN p.jabatan LIKE '%Sopir%' THEN 7
                ELSE 8
            END,
            CASE 
                WHEN p.golongan LIKE 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN p.golongan LIKE 'PEMBINA TK I (IV/B)' THEN 2
                WHEN p.golongan LIKE 'PEMBINA (IV/A)' THEN 3
                WHEN p.golongan LIKE 'PENATA TK I (III/D)' THEN 4
                WHEN p.golongan LIKE 'PENATA (III/C)' THEN 5
                WHEN p.golongan LIKE 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN p.golongan LIKE 'PENATA MUDA (III/A)' THEN 7
                WHEN p.golongan LIKE 'PENGATUR TK I (II/D)' THEN 8
                WHEN p.golongan LIKE 'PENGATUR (II/C)' THEN 9
                WHEN p.golongan LIKE 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN p.golongan LIKE 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END,
            p.nama_pegawai ASC";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) == 0) {
    die("Data tidak ditemukan");
}

// Simpan semua data pegawai dalam array
$pegawai_list = [];
while($row = mysqli_fetch_assoc($result)) {
    $pegawai_list[] = $row;
}

// Data pertama untuk informasi surat
$data = $pegawai_list[0];

// Fungsi untuk format tanggal Indonesia
function tanggal_indonesia($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi untuk mengkonversi angka ke terbilang
function terbilang($angka) {
    $bilangan = array(
        '',
        'satu',
        'dua',
        'tiga',
        'empat',
        'lima',
        'enam',
        'tujuh',
        'delapan',
        'sembilan',
        'sepuluh',
        'sebelas'
    );

    if ($angka < 12) {
        return $bilangan[$angka];
    } elseif ($angka < 20) {
        return $bilangan[$angka - 10] . ' belas';
    } elseif ($angka < 100) {
        return $bilangan[floor($angka / 10)] . ' puluh ' . $bilangan[$angka % 10];
    }
    return strval($angka);
}

// Fungsi untuk menentukan pangkat berdasarkan golongan
function get_pangkat($golongan) {
    $pangkat = array(
        'IV/c' => 'Pembina Utama Muda',
        'IV/b' => 'Pembina Tingkat I',
        'IV/a' => 'Pembina',
        'III/d' => 'Penata Tingkat I',
        'III/c' => 'Penata',
        'III/b' => 'Penata Muda Tingkat I',
        'III/a' => 'Penata Muda',
        // Tambahkan pangkat lainnya sesuai kebutuhan
    );
    
    return isset($pangkat[$golongan]) ? $pangkat[$golongan] : '';
}

// Format dates
$tanggal_berangkat = date('d F Y', strtotime($data['tanggal_berangkat']));
$tanggal_kembali = date('d F Y', strtotime($data['tanggal_kembali']));
?>

<!DOCTYPE html>
<html lang="en">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SPPD</title>
    <style>
        @page {
            size: 215.9mm 330mm !important; /* Ukuran F4 */
            margin: 5mm 10mm 12.5mm 14mm; /* Mengurangi margin kanan dari 14mm ke 10mm */
        }
        
        html, body {
            margin: 0;
            padding: 0;
            width: 215.9mm;
            font-family: Times New Roman, serif;
            font-size: 12pt;
            line-height: 1.4;
            background: white;
            height: auto;
            min-height: 330mm;
        }
        
        .kop-surat {
            text-align: center;
            margin-bottom: 10px;
            position: relative;
            width: 100%;
            height: 110px;
            page-break-inside: avoid;
        }
        
        .logo {
            position: absolute;
            left: 30px;
            top: 0;
            width: 90px;
            height: 90px;
            z-index: 1;
        }
        
        .logo img {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        
        .kop-text {
            text-align: center;
            padding-top: 5px;
        }
        
        .kop-text h2 {
            margin: 0;
            font-size: 16pt;
            font-weight: bold;
            line-height: 1.3;
        }
        
        .kop-text p {
            margin: 0;
            font-size: 12pt;
            line-height: 1.2;
        }
        
        .garis {
            border-bottom: 2px solid black;
            margin: 5px 0;
        }
        
        .nomor-surat {
            text-align: right;
            margin: 5mm 0;
            font-size: 12pt;
        }
        
        .judul {
            text-align: center;
            font-weight: bold;
            margin: 5mm 0;
            text-transform: uppercase;
            line-height: 1.5;
            font-size: 13pt;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 3mm 0;
            page-break-inside: avoid;
            table-layout: fixed;
        }
        
        table, th, td {
            border: 0.8pt solid black;
        }
        
        td {
            padding: 3mm;
            vertical-align: top;
            font-size: 12pt;
            word-wrap: break-word;
        }
        
        td:first-child {
            width: 5mm;
            text-align: center;
            padding: 3mm 1.5mm;
        }
        
        td:nth-child(2) {
            width: 55mm;
            padding: 3mm;
        }
        
        td:nth-child(3) {
            padding: 3mm;
            width: auto;
        }
        
        tr:nth-child(3) td:nth-child(2),
        tr:nth-child(6) td:nth-child(2),
        tr:nth-child(7) td:nth-child(2),
        tr:nth-child(9) td:nth-child(2) {
            width: 55mm;
            min-width: 55mm;
        }
        
        .multi-line {
            padding: 3mm;
            min-height: 20mm;
        }
        
        .multi-line br {
            margin-bottom: 2mm;
        }
        
        tr:nth-child(4) td:last-child { /* Maksud Perjalanan Dinas */
            min-height: auto;
            height: auto;
            padding: 3mm;
        }
        
        .pengikut td {
            height: 12mm;
            vertical-align: middle;
            font-size: 12pt;
        }
        
        .pengikut td:first-child {
            vertical-align: middle;
        }
        
        tr:nth-child(3) td:last-child { /* Pangkat dan Golongan */
            min-height: 20mm;
        }
        
        tr:nth-child(7) td:last-child { /* Lamanya Perjalanan */
            min-height: 20mm;
        }
        
        tr:nth-child(9) td:last-child { /* Pembebanan Anggaran */
            min-height: 20mm;
        }
        
        .ttd {
            margin-top: 5mm;
            text-align: right;
            padding-right: 5mm;
            font-size: 12pt;
        }
        
        .ttd-content {
            display: inline-block;
            text-align: left;
            width: 80mm;
        }
        
        .ttd p {
            margin: 0;
            line-height: 1.3;
        }
        
        .ttd-space {
            margin-top: 15mm;
        }
        
        @media print {
            @page {
                size: 215.9mm 330mm !important;
                margin: 5mm 10mm 12.5mm 14mm; /* Mengurangi margin kanan dari 14mm ke 10mm */
            }
            
            html, body {
                width: 215.9mm !important;
                height: 330mm !important;
                transform: none !important;
            }
            
            body {
                margin: 0 auto;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            table { 
                page-break-inside: avoid;
                width: 100% !important;
            }
            tr { page-break-inside: avoid; }
            thead { display: table-header-group; }
            tfoot { display: table-footer-group; }
        }
        
        .pengikut-table {
            width: 100%;
            margin: 0 !important;
            border: none !important;
            table-layout: fixed;
        }
        
        .pengikut-table td {
            padding: 2mm;
            vertical-align: middle;
            font-size: 11pt;
            word-wrap: break-word;
        }
        
        .pengikut-table tr:first-child td {
            font-weight: normal;
            text-align: center;
            height: 8mm;
        }
        
        .pengikut-table tr:last-child td {
            height: 20mm;
        }
        
        .pengikut-table .nomor {
            text-align: center;
            line-height: 1.8;
        }
        
        .no-wrap {
            white-space: nowrap;
        }
        
        .indent-content {
            padding-left: 5mm;
        }
        
        .duration-cell {
            line-height: 1.6;
        }
        
        .duration-cell .item {
            display: flex;
        }
        
        .duration-cell .label {
            width: 25mm;
            padding-right: 2mm;
        }

        table {
            margin-bottom: 2mm;
        }

        tr:nth-child(10) td { /* Keterangan lain-lain */
            padding: 2mm 3mm;
        }

        /* Memastikan nomor tetap terbaca dengan baik */
        td:first-child {
            white-space: nowrap;
            font-size: 12pt;
        }
    </style>
</head>
<body>
    <?php 
    $items_per_page = 1; // Satu SPPD per halaman
    $total_items = count($pegawai_list);
    $total_pages = ceil($total_items / $items_per_page);
    
    for($page = 0; $page < $total_pages; $page++): 
        $start_idx = $page * $items_per_page;
        $current_pegawai = $pegawai_list[$start_idx];
        
        if($page > 0): ?>
            <div class="page-break"></div>
        <?php endif; ?>
        
        <div class="kop-surat">
            <div class="logo">
                <img src="../assets/img/logo.png" alt="Logo">
            </div>
            <div class="kop-text">
                <h2>PEMERINTAH KABUPATEN BALANGAN</h2>
                <h2>DINAS PENDIDIKAN DAN KEBUDAYAAN</h2>
                <p>Jl. A. Yani KM. 2,5 Kelurahan Batu Piring Telp./Fax 0526 - 2031150</p>
                <p>Paringin Selatan - 71614</p>
            </div>
            <div class="garis"></div>
        </div>

        <div class="nomor-surat">
            <div class="nomor-container">
                Nomor : <?= isset($current_pegawai['no_sppd']) ? $current_pegawai['no_sppd'] : '-' ?>
            </div>
        </div>

        <div class="judul">
            SURAT PERINTAH PERJALANAN DINAS<br>
            ( S P P D )
        </div>

        <table>
            <tr>
                <td>1.</td>
                <td>Pengguna Anggaran/Kuasa Pengguna Anggaran</td>
                <td colspan="2">Kepala Dinas Pendidikan dan Kebudayaan Kab. Balangan</td>
            </tr>
            <tr>
                <td>2.</td>
                <td>Nama/NIP Pegawai yang diperintahkan</td>
                <td colspan="2"><?= strtoupper($current_pegawai['nama_pegawai']) ?> / <?= $current_pegawai['nip'] ?></td>
            </tr>
            <tr class="multi-line">
                <td>3.</td>
                <td>
                    a. Pangkat dan Golongan<br>
                    b. Jabatan / Instansi<br>
                    c. Tingkat Biaya Perjalanan Dinas
                </td>
                <td colspan="2">
                    a. <?= ucwords(strtolower(get_pangkat($current_pegawai['golongan']))) . ' (' . $current_pegawai['golongan'] . ')' ?><br>
                    b. <?= $current_pegawai['jabatan'] ?><br>
                    c. -
                </td>
            </tr>
            <tr>
                <td>4.</td>
                <td>Maksud Perjalanan Dinas</td>
                <td colspan="2" class="long-content"><?= isset($current_pegawai['maksud']) ? nl2br(htmlspecialchars($current_pegawai['maksud'])) : '-' ?></td>
            </tr>
            <tr>
                <td>5.</td>
                <td>Alat angkut yang dipergunakan</td>
                <td colspan="2"><?php 
                    if (strpos(strtolower($current_pegawai['jabatan']), 'kepala dinas') !== false || 
                        strpos(strtolower($current_pegawai['jabatan']), 'kabid') !== false || 
                        strpos(strtolower($current_pegawai['jabatan']), 'kepala bidang') !== false ||
                        strpos(strtolower($current_pegawai['jabatan']), 'kabag') !== false ||
                        strpos(strtolower($current_pegawai['jabatan']), 'kepala bagian') !== false ||
                        strpos(strtolower($current_pegawai['jabatan']), 'kasubbag umum dan kepegawaian') !== false ||
                        strpos(strtolower($current_pegawai['jabatan']), 'sopir') !== false) {
                        echo "Kendaraan Dinas";
                    } else {
                        echo "Kendaraan Umum";
                    }
                ?></td>
            </tr>
            <tr>
                <td>6.</td>
                <td>a. Tempat berangkat<br>
                    b. Tempat tujuan</td>
                <td colspan="2">a. Dinas Pendidikan & Kebudayaan Kabupaten Balangan<br>
                    b. <?php 
                        if (isset($current_pegawai['jenis_surat']) && $current_pegawai['jenis_surat'] === 'Dalam Daerah Dalam Provinsi') {
                            echo !empty($current_pegawai['tujuan_pegawai']) ? htmlspecialchars($current_pegawai['tujuan_pegawai']) : '-';
                        } else {
                            if (!empty($current_pegawai['tempat_kegiatan'])) {
                                echo htmlspecialchars($current_pegawai['tempat_kegiatan']);
                            } else if (!empty($current_pegawai['tujuan'])) {
                                echo htmlspecialchars($current_pegawai['tujuan']);
                            } else {
                                echo '-';
                            }
                        }
                    ?></td>
            </tr>
            <tr>
                <td>7.</td>
                <td>
                    a. Lamanya Perjalanan Dinas<br>
                    b. Tanggal berangkat<br>
                    c. Tanggal harus kembali
                </td>
                <td colspan="2">
                    a. <?= isset($current_pegawai['lama_perjalanan']) ? $current_pegawai['lama_perjalanan'] : '1' ?> (<?= isset($current_pegawai['lama_perjalanan']) && $current_pegawai['lama_perjalanan'] > 1 ? ucfirst(terbilang($current_pegawai['lama_perjalanan'])) : 'Satu' ?>) Hari<br>
                    b. <?= isset($current_pegawai['tanggal_berangkat']) ? tanggal_indonesia($current_pegawai['tanggal_berangkat']) : '-' ?><br>
                    c. <?= isset($current_pegawai['tanggal_kembali']) ? tanggal_indonesia($current_pegawai['tanggal_kembali']) : '-' ?>
                </td>
            </tr>
            <tr>
                <td>8.</td>
                <td>Pengikut</td>
                <td colspan="2">
                    <table class="pengikut-table">
                        <tr>
                            <td style="width: 8%; border-left: none; border-top: none;">No.</td>
                            <td style="width: 42%; border-top: none;">Pengikut</td>
                            <td style="width: 25%; border-top: none;">Tanggal Lahir</td>
                            <td style="width: 25%; border-top: none; border-right: none;">Keterangan</td>
                        </tr>
                        <tr>
                            <td class="nomor" style="border-left: none; border-bottom: none;">1.<br>2.</td>
                            <td style="border-bottom: none;">&nbsp;</td>
                            <td style="border-bottom: none;">&nbsp;</td>
                            <td style="border-right: none; border-bottom: none;">&nbsp;</td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td>9.</td>
                <td>Pembebanan Anggaran<br>
                    a. Instansi<br>
                    b. Kode Rekening</td>
                <td colspan="2">
                    <br>a. Dinas Pendidikan dan Kebudayaan Kabupaten Balangan<br>
                    b. <?= isset($current_pegawai['no_sub_kegiatan']) ? $current_pegawai['no_sub_kegiatan'] : '-' ?>
                </td>
            </tr>
            <tr>
                <td>10.</td>
                <td>Keterangan lain-lain</td>
                <td colspan="2">-</td>
            </tr>
        </table>
<br>
        <div class="ttd">
            <div class="ttd-content">
                <p>
                    Ditetapkan di : Paringin<br>
                   Pada Tanggal : <?= isset($current_pegawai['tanggal_surat']) ? tanggal_indonesia($current_pegawai['tanggal_surat']) : date('m-Y') ?>

                     </p>
                <p>Kepala,</p>
                <div class="ttd-space"></div>
                <p>
                    <u>H. ABIJI, S.Pd, MAP</u><br>
                    Pembina Utama Muda / IV c<br>
                    NIP. 19580813 198412 1 002
                </p>
            </div>
        </div>
    <?php endfor; ?>

    <script>
        window.onload = function() {
            // Mengatur properti pencetakan
            const style = document.createElement('style');
            style.innerHTML = `
                @page {
                    size: 215.9mm 330mm !important;
                    margin: 5mm 10mm 12.5mm 14mm; /* Mengurangi margin kanan dari 14mm ke 10mm */
                }
                @media print {
                    html, body {
                        width: 215.9mm !important;
                        height: 330mm !important;
                        transform: none !important;
                    }
                }
            `;
            document.head.appendChild(style);

            setTimeout(function() {
                const printConfig = {
                    style: {
                        transform: 'none !important'
                    }
                };
                
                // Override browser print settings
                const mediaQueryList = window.matchMedia('print');
                mediaQueryList.addListener(function(mql) {
                    if (mql.matches) {
                        document.documentElement.style.setProperty('transform', 'none', 'important');
                        document.body.style.setProperty('transform', 'none', 'important');
                    }
                });

                window.print();
                setTimeout(function() {
                    window.close();
                }, 100);
            }, 500);
        }
    </script>
</body>
</html> 