<?php
include "../koneksi.php";

// Query untuk mengambil surat tugas yang belum memiliki SPPD
$query = "SELECT 
            st.id_surat_tugas,
            st.nomor_surat,
            st.tanggal_surat,
            st.maksud_tugas,
            st.tempat_tujuan,
            p.nama_pegawai,
            p.nip
          FROM surat_tugas st
          INNER JOIN pegawai p ON st.id_pegawai = p.id_pegawai
          LEFT JOIN sppd s ON st.id_surat_tugas = s.id_surat_tugas
          WHERE s.id_sppd IS NULL
          ORDER BY st.tanggal_surat DESC";

$result = mysqli_query($koneksi, $query);

if (!$result) {
    die("Query error: " . mysqli_error($koneksi));
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Pilih Surat Tugas</title>
    <style>
        /* Gunakan style yang sama seperti sppd_muka.php */
        body {
            font-family: Arial, sans-serif;
            margin: 20px;
            background-color: #f4f4f4;
        }
        .container {
            background-color: white;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #4CAF50;
            color: white;
        }
        tr:hover {
            background-color: #f5f5f5;
        }
        .btn {
            padding: 6px 12px;
            background-color: #4CAF50;
            color: white;
            text-decoration: none;
            border-radius: 3px;
        }
        .btn:hover {
            opacity: 0.8;
        }
        .btn-kembali {
            background-color: #666;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h2>Pilih Surat Tugas untuk Pembuatan SPPD</h2>
            <a href="sppd_muka.php" class="btn btn-kembali">Kembali</a>
        </div>
        
        <div class="table-responsive">
            <table>
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Nomor Surat Tugas</th>
                        <th>Tanggal</th>
                        <th>Nama Pegawai</th>
                        <th>NIP</th>
                        <th>Tujuan</th>
                        <th>Maksud Tugas</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if ($result && mysqli_num_rows($result) > 0) {
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)) {
                    ?>
                    <tr>
                        <td><?php echo $no++; ?></td>
                        <td><?php echo htmlspecialchars($row['nomor_surat']); ?></td>
                        <td><?php echo date('d-m-Y', strtotime($row['tanggal_surat'])); ?></td>
                        <td><?php echo htmlspecialchars($row['nama_pegawai']); ?></td>
                        <td><?php echo htmlspecialchars($row['nip']); ?></td>
                        <td><?php echo htmlspecialchars($row['tempat_tujuan']); ?></td>
                        <td><?php echo htmlspecialchars($row['maksud_tugas']); ?></td>
                        <td>
                            <a href="buat_sppd.php?id=<?php echo $row['id_surat_tugas']; ?>" 
                               class="btn">
                                Buat SPPD
                            </a>
                        </td>
                    </tr>
                    <?php 
                        }
                    } else {
                    ?>
                    <tr>
                        <td colspan="8" style="text-align: center;">Tidak ada surat tugas yang tersedia</td>
                    </tr>
                    <?php
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html> 