<?php
session_start();
require_once '../config/config.php';

// Get user's bidang if admin_sppd
$user_bidang = '';
if ($_SESSION['level'] === 'admin_sppd') {
    $user_id = $_SESSION['user_id'];
    $stmt = mysqli_prepare($conn, "SELECT bidang FROM users WHERE id = ?");
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
        mysqli_stmt_close($stmt);
    }
}

// Base query
$base_query = "SELECT 
            st.id_surat,
            st.no_sppd,
            st.tanggal_surat,
            st.tujuan,
            st.maksud,
            st.jenis_surat,
            st.tempat_kegiatan,
            st.tanggal_berangkat,
            st.tanggal_kembali,
            GROUP_CONCAT(DISTINCT CONCAT_WS('|', 
                p.nama_pegawai,
                COALESCE(dst.tujuan_pegawai, '')
            ) ORDER BY 
                CASE 
                    WHEN p.jabatan LIKE '%Kepala%' THEN 1
                    WHEN p.jabatan LIKE '%Sekretaris%' THEN 2
                    WHEN p.jabatan LIKE '%Kabid%' THEN 3
                    WHEN p.jabatan LIKE '%Kasubbag%' THEN 4
                    WHEN p.jabatan LIKE '%Kasi%' THEN 5
                    ELSE 6
                END,
                CASE 
                    WHEN p.golongan LIKE 'IV/%' THEN 1
                    WHEN p.golongan LIKE 'III/%' THEN 2
                    WHEN p.golongan LIKE 'II/%' THEN 3
                    WHEN p.golongan LIKE 'I/%' THEN 4
                    ELSE 5
                END ASC
                SEPARATOR ';;'
            ) as pegawai_data
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          LEFT JOIN users u ON st.created_by = u.id";

// Add WHERE clause for admin_sppd
if ($_SESSION['level'] === 'admin_sppd' && !empty($user_bidang)) {
    $query = $base_query . " WHERE u.bidang = ? GROUP BY st.id_surat ORDER BY st.tanggal_surat DESC";
    $stmt = mysqli_prepare($conn, $query);
    if ($stmt) {
        mysqli_stmt_bind_param($stmt, "s", $user_bidang);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
    } else {
        die("Error preparing statement: " . mysqli_error($conn));
    }
} else {
    $query = $base_query . " GROUP BY st.id_surat ORDER BY st.tanggal_surat DESC";
    $result = mysqli_query($conn, $query);
}

if (!$result) {
    die("Error in query: " . mysqli_error($conn));
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar SPPD - Sistem SPPD</title>
    <?php include '../includes/header.php' ?>
    
    <!-- Tambahkan CSS untuk sidebar -->
    <link href='https://unpkg.com/boxicons@2.0.7/css/boxicons.min.css' rel='stylesheet'>
    <style>
        /* Root variables */
        :root {
            --primary-color: #0ea5e9;
            --secondary-color: #2dd4bf;
            --success-color: #10b981;
            --background-color: rgb(245, 255, 254);
            --background-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --card-bg: #ffffff;
            --border-color: #e5e7eb;
            --shadow-color: rgba(14, 165, 233, 0.15);
            --text-primary: #1e293b;
            --text-secondary: #64748b;
        }

        /* Card styling */
        .card {
            border: none;
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.05);
            background: var(--card-bg);
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        
        .card:hover {
            box-shadow: 0 8px 12px var(--shadow-color);
        }
        
        .card-header {
            background: var(--primary-gradient);
            border-radius: 15px 15px 0 0 !important;
            padding: 20px;
            border: none;
        }
        
        .card-header h5 {
            color: white;
            font-weight: 600;
            margin: 0;
            font-size: 1.25rem;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        /* Table styling */
        .table {
            margin-bottom: 0;
            background-color: var(--card-bg);
            border-radius: 10px;
        }

        .table thead th {
            background: var(--primary-gradient);
            color: white;
            font-weight: 500;
            padding: 15px;
            border: none;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        .table tbody td {
            padding: 0.8rem 1rem;
            color: var(--text-primary);
            border-bottom: 1px solid var(--border-color);
            transition: background-color 0.2s ease;
        }

        .table-hover tbody tr:hover {
            background-color: rgba(14, 165, 233, 0.05);
        }

        /* Button styling */
        .btn {
            padding: 8px 16px;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
            text-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        .btn-soft-success {
            background: linear-gradient(135deg, #0ea5e9, #2dd4bf);
            color: white;
            border: none;
            box-shadow: 0 2px 4px rgba(14, 165, 233, 0.2);
        }

        .btn-soft-primary {
            background: var(--primary-gradient);
            color: white;
            border: none;
            box-shadow: 0 2px 4px rgba(14, 165, 233, 0.2);
        }

        .btn-soft-success:hover,
        .btn-soft-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
        }

        /* Home section styling */
        .home-section {
            background: linear-gradient(135deg, rgb(231, 255, 255) 0%, rgb(236, 255, 246) 100%);
            min-height: 100vh;
            padding: 20px;
        }

        /* Card body styling */
        .card-body {
            background: linear-gradient(135deg, #f6f9ff 0%, #f8f9fa 100%);
            padding: 20px;
            border-radius: 0 0 15px 15px;
        }

        /* Alert styling */
        .alert {
            border: none;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
            box-shadow: 0 2px 4px var(--shadow-color);
        }

        .alert-success {
            background: var(--primary-gradient);
            color: white;
        }

        .alert-danger {
            background: linear-gradient(135deg, #f87171, #ef4444);
            color: white;
        }

        .btn-close {
            filter: brightness(0) invert(1);
            opacity: 0.8;
        }

        /* Icons styling */
        .bi {
            margin-right: 0.375rem;
            font-size: 1rem;
            vertical-align: -0.125em;
        }

        /* Column widths */
        .table th:nth-child(1),
        .table td:nth-child(1) {
            width: 5%;
            text-align: center;
        }

        .table th:nth-child(2),
        .table td:nth-child(2) {
            width: 20%;
        }

        .table th:nth-child(3),
        .table td:nth-child(3) {
            width: 45%;
        }

        .table th:nth-child(4),
        .table td:nth-child(4) {
            width: 20%;
        }

        .table th:nth-child(5),
        .table td:nth-child(5) {
            width: 10%;
            text-align: center;
        }

        @media (max-width: 768px) {
            .card-header {
                padding: 15px;
            }

            .table thead th {
                padding: 0.7rem;
                font-size: 0.8rem;
            }
            
            .table tbody td {
                padding: 0.7rem;
                font-size: 0.85rem;
            }

            .btn {
                padding: 6px 12px;
            }
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php' ?>
    
    <section class="home-section">
        <div class="container mt-4">
            <div class="card mb-4">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">Daftar SPPD</h5>
                </div>
                <div class="card-body">
                    <?php if (isset($_SESSION['alert'])) : ?>
                        <div class="alert alert-<?= $_SESSION['alert']['type'] ?> alert-dismissible fade show" role="alert">
                            <?= $_SESSION['alert']['message'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                        <?php unset($_SESSION['alert']); ?>
                    <?php endif; ?>

                    <div class="table-responsive">
                        <table id="sppdTable" class="table table-hover">
                            <thead>
                                <tr>
                                    <th class="text-center" style="width: 5%">No.</th>
                                    <th style="width: 20%">No. SPPD</th>
                                    <th style="width: 45%">Maksud</th>
                                    <th style="width: 20%">Tanggal Pelaksanaan</th>
                                    <th style="width: 10%" class="text-center">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $no = 1;
                                while ($row = mysqli_fetch_assoc($result)) : 
                                ?>
                                <tr>
                                    <td class="text-center"><?= $no++ ?></td>
                                    <td><?= htmlspecialchars($row['no_sppd']) ?></td>
                                    <td><?= htmlspecialchars($row['maksud']) ?></td>
                                    <td>
                                        <?= date('d-m-Y', strtotime($row['tanggal_berangkat'])) ?> s/d 
                                        <?= date('d-m-Y', strtotime($row['tanggal_kembali'])) ?>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group">
                                            <a href="cetak_sppd_muka.php?id=<?= $row['id_surat'] ?>" 
                                               class="btn btn-soft-success btn-sm" target="_blank">
                                                <i class="bi bi-printer"></i> SPPD Muka
                                            </a>
                                            <a href="../sppd_belakang/pilih_cetak.php?id=<?= $row['id_surat'] ?>" 
                                               class="btn btn-soft-primary btn-sm">
                                                <i class="bi bi-printer"></i> SPPD Belakang
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php include '../includes/footer.php' ?>

    <script>
        $(document).ready(function() {
            $('#sppdTable').DataTable({
                "responsive": true,
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
                },
                "order": [[4, "desc"]], // Mengubah pengurutan berdasarkan kolom tanggal (index 4)
                "pageLength": 10,
                "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]]
            });
        });
    </script>
</body>
</html> 