<?php
// Nonaktifkan semua error reporting
error_reporting(0);
ini_set('display_errors', 0);

require_once '../config/database.php';

// Ambil ID surat dari parameter URL dengan validasi
$id_surat = isset($_GET['id']) ? (int)$_GET['id'] : die('ID Surat tidak ditemukan');

// Ambil data pejabat yang dipilih
$id_pejabat = isset($_GET['id_pejabat']) ? (int)$_GET['id_pejabat'] : 0;
$pejabat = null;

if ($id_pejabat > 0) {
    $query_pejabat = "SELECT * FROM pejabat_daerah WHERE id_pejabat = ?";
    $stmt = mysqli_prepare($conn, $query_pejabat);
    mysqli_stmt_bind_param($stmt, "i", $id_pejabat);
    mysqli_stmt_execute($stmt);
    $result_pejabat = mysqli_stmt_get_result($stmt);
    $pejabat = mysqli_fetch_assoc($result_pejabat);
}

// Jika tidak ada pejabat yang dipilih atau data tidak ditemukan, gunakan default
if (!$pejabat) {
    $pejabat = [
        'nama' => 'H.HABIJI. S.Pd.,M.AP',
        'nip' => '19690813 199412 1 002',
        'pangkat' => 'Pembina Utama Muda',
        'golongan' => 'IV/c',
        'jabatan' => 'Kepala Dinas Pendidikan dan Kebudayaan Kabupaten Balangan'
    ];
}

// Perbaikan query dengan nama kolom yang benar dan pengurutan
$query = "SELECT st.*, 
          GROUP_CONCAT(p.nama_pegawai ORDER BY 
            CASE
                WHEN p.jabatan = 'Bupati Balangan' THEN 0
                WHEN p.jabatan = 'Wakil Bupati Balangan' THEN 1 
                WHEN p.jabatan = 'Sekretaris Daerah' THEN 2
                WHEN p.jabatan = 'Plh.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Plh. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Asisten Pemerintahan dan Kesejahteraan Rakyat' THEN 4
                WHEN p.jabatan = 'Asisten Administrasi Umum' THEN 5
                WHEN p.jabatan = 'Asisten Perekonomian dan Pembangunan' THEN 6
                WHEN p.jabatan = 'Kepala Badan Perencanaan Pembangunan, Riset dan Inovasi Daerah' THEN 7
                WHEN p.jabatan = 'Kepala Badan Keuangan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Badan Pengelolaan Keuangan, Pendapatan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' THEN 9
                WHEN p.jabatan = 'Inspektur' THEN 10
                WHEN p.jabatan = 'inspektur' THEN 10
                WHEN p.jabatan = 'Inspektorat' THEN 10
                WHEN p.jabatan = 'Kabag' THEN 11
                WHEN p.jabatan = 'Kepala Bidang' THEN 12
                WHEN p.jabatan = 'Kasubbag' THEN 13
                WHEN p.golongan = 'PEMBINA UTAMA MUDA (IV/C)' THEN 14
                WHEN p.golongan = 'PEMBINA TK I (IV/B)' THEN 15
                WHEN p.golongan = 'PEMBINA (IV/A)' THEN 16
                WHEN p.golongan = 'PENATA TK I (III/D)' THEN 17
                WHEN p.golongan = 'PENATA (III/C)' THEN 18
                WHEN p.golongan = 'PENATA MUDA TK I (III/B)' THEN 19
                WHEN p.golongan = 'PENATA MUDA (III/A)' THEN 20
                WHEN p.golongan = 'PENGATUR TK I (II/D)' THEN 21
                WHEN p.golongan = 'PENGATUR (II/C)' THEN 22
                WHEN p.golongan = 'PENGATUR MUDA TK I (II/B)' THEN 23
                WHEN p.golongan = 'PENGATUR MUDA (II/A)' THEN 24
                ELSE 25
            END SEPARATOR '||') as nama_pegawai_list,
          GROUP_CONCAT(p.nip ORDER BY 
            CASE 
                WHEN p.jabatan = 'Bupati Balangan' THEN 0
                WHEN p.jabatan = 'Wakil Bupati Balangan' THEN 1 
                WHEN p.jabatan = 'Sekretaris Daerah' THEN 2
                WHEN p.jabatan = 'Plh.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Plh. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Asisten Pemerintahan dan Kesejahteraan Rakyat' THEN 4
                WHEN p.jabatan = 'Asisten Administrasi Umum' THEN 5
                WHEN p.jabatan = 'Asisten Perekonomian dan Pembangunan' THEN 6
                WHEN p.jabatan = 'Kepala Badan Perencanaan Pembangunan,Riset dan Inovasi Daerah' THEN 7
                WHEN p.jabatan = 'Kepala Badan Keuangan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Badan Pengelolaan Keuangan, Pendapatan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' THEN 9
                WHEN p.jabatan = 'Inspektur' THEN 10
                 WHEN p.jabatan = 'inspektur' THEN 10
                WHEN p.jabatan = 'Inspektorat' THEN 10
                WHEN p.jabatan = 'Kabag' THEN 11
                WHEN p.jabatan = 'Kepala Bidang' THEN 12
                WHEN p.jabatan = 'Kasubbag' THEN 13
                WHEN p.golongan = 'PEMBINA UTAMA MUDA (IV/C)' THEN 14
                WHEN p.golongan = 'PEMBINA TK I (IV/B)' THEN 15
                WHEN p.golongan = 'PEMBINA (IV/A)' THEN 16
                WHEN p.golongan = 'PENATA TK I (III/D)' THEN 17
                WHEN p.golongan = 'PENATA (III/C)' THEN 18
                WHEN p.golongan = 'PENATA MUDA TK I (III/B)' THEN 19
                WHEN p.golongan = 'PENATA MUDA (III/A)' THEN 20
                WHEN p.golongan = 'PENGATUR TK I (II/D)' THEN 21
                WHEN p.golongan = 'PENGATUR (II/C)' THEN 22
                WHEN p.golongan = 'PENGATUR MUDA TK I (II/B)' THEN 23
                WHEN p.golongan = 'PENGATUR MUDA (II/A)' THEN 24
                ELSE 25
            END SEPARATOR '||') as nip_list,
          GROUP_CONCAT(p.golongan ORDER BY 
            CASE 
                WHEN p.jabatan = 'Bupati Balangan' THEN 0
                WHEN p.jabatan = 'Wakil Bupati Balangan' THEN 1 
                WHEN p.jabatan = 'Sekretaris Daerah' THEN 2
                WHEN p.jabatan = 'Plh.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Plh. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Asisten Pemerintahan dan Kesejahteraan Rakyat' THEN 4
                WHEN p.jabatan = 'Asisten Administrasi Umum' THEN 5
                WHEN p.jabatan = 'Asisten Perekonomian dan Pembangunan' THEN 6
                WHEN p.jabatan = 'Kepala Badan Perencanaan Pembangunan,Riset dan Inovasi Daerah' THEN 7
                WHEN p.jabatan = 'Kepala Badan Keuangan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Badan Pengelolaan Keuangan, Pendapatan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' THEN 9
                WHEN p.jabatan = 'Inspektur' THEN 10
                WHEN p.jabatan = 'inspektur' THEN 10
                WHEN p.jabatan = 'Inspektorat' THEN 10
                WHEN p.jabatan = 'Kabag' THEN 11
                WHEN p.jabatan = 'Kepala Bidang' THEN 12
                WHEN p.jabatan = 'Kasubbag' THEN 13
                WHEN p.golongan = 'PEMBINA UTAMA MUDA (IV/C)' THEN 14
                WHEN p.golongan = 'PEMBINA TK I (IV/B)' THEN 15
                WHEN p.golongan = 'PEMBINA (IV/A)' THEN 16
                WHEN p.golongan = 'PENATA TK I (III/D)' THEN 17
                WHEN p.golongan = 'PENATA (III/C)' THEN 18
                WHEN p.golongan = 'PENATA MUDA TK I (III/B)' THEN 19
                WHEN p.golongan = 'PENATA MUDA (III/A)' THEN 20
                WHEN p.golongan = 'PENGATUR TK I (II/D)' THEN 21
                WHEN p.golongan = 'PENGATUR (II/C)' THEN 22
                WHEN p.golongan = 'PENGATUR MUDA TK I (II/B)' THEN 23
                WHEN p.golongan = 'PENGATUR MUDA (II/A)' THEN 24
                ELSE 25
            END SEPARATOR '||') as pangkat_list,
          GROUP_CONCAT(p.jabatan ORDER BY 
            CASE
                WHEN p.jabatan = 'Bupati Balangan' THEN 0
                WHEN p.jabatan = 'Wakil Bupati Balangan' THEN 1 
                WHEN p.jabatan = 'Sekretaris Daerah' THEN 2
                WHEN p.jabatan = 'Plh.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Plh. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Asisten Pemerintahan dan Kesejahteraan Rakyat' THEN 4
                WHEN p.jabatan = 'Asisten Administrasi Umum' THEN 5
                WHEN p.jabatan = 'Asisten Perekonomian dan Pembangunan' THEN 6
                WHEN p.jabatan = 'Kepala Badan Perencanaan Pembangunan,Riset dan Inovasi Daerah' THEN 7
                WHEN p.jabatan = 'Kepala Badan Keuangan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Badan Pengelolaan Keuangan, Pendapatan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' THEN 9
                WHEN p.jabatan = 'Inspektur' THEN 10
                WHEN p.jabatan = 'inspektur' THEN 10
                WHEN p.jabatan = 'Inspektorat' THEN 10
                WHEN p.jabatan = 'Kabag' THEN 11
                WHEN p.jabatan = 'Kepala Bidang' THEN 12
                WHEN p.jabatan = 'Kasubbag' THEN 13
                WHEN p.golongan = 'PEMBINA UTAMA MUDA (IV/C)' THEN 14
                WHEN p.golongan = 'PEMBINA TK I (IV/B)' THEN 15
                WHEN p.golongan = 'PEMBINA (IV/A)' THEN 16
                WHEN p.golongan = 'PENATA TK I (III/D)' THEN 17
                WHEN p.golongan = 'PENATA (III/C)' THEN 18
                WHEN p.golongan = 'PENATA MUDA TK I (III/B)' THEN 19
                WHEN p.golongan = 'PENATA MUDA (III/A)' THEN 20
                WHEN p.golongan = 'PENGATUR TK I (II/D)' THEN 21
                WHEN p.golongan = 'PENGATUR (II/C)' THEN 22
                WHEN p.golongan = 'PENGATUR MUDA TK I (II/B)' THEN 23
                WHEN p.golongan = 'PENGATUR MUDA (II/A)' THEN 24
                ELSE 25
            END SEPARATOR '||') as jabatan_list,
          GROUP_CONCAT(dst.tujuan_pegawai ORDER BY 
            CASE
                WHEN p.jabatan = 'Bupati Balangan' THEN 0
                WHEN p.jabatan = 'Wakil Bupati Balangan' THEN 1 
                WHEN p.jabatan = 'Sekretaris Daerah' THEN 2
                WHEN p.jabatan = 'Plh.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Plh. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH.Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'PLH. Sekretaris Daerah' THEN 3
                WHEN p.jabatan = 'Asisten Pemerintahan dan Kesejahteraan Rakyat' THEN 4
                WHEN p.jabatan = 'Asisten Administrasi Umum' THEN 5
                WHEN p.jabatan = 'Asisten Perekonomian dan Pembangunan' THEN 6
                WHEN p.jabatan = 'Kepala Badan Perencanaan Pembangunan,Riset dan Inovasi Daerah' THEN 7
                WHEN p.jabatan = 'Kepala Badan Keuangan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Badan Pengelolaan Keuangan, Pendapatan dan Aset Daerah' THEN 8
                WHEN p.jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' THEN 9
                WHEN p.jabatan = 'Inspektur' THEN 10
                WHEN p.jabatan = 'inspektur' THEN 10
                WHEN p.jabatan = 'Inspektorat' THEN 10
                WHEN p.jabatan = 'Kabag' THEN 11
                WHEN p.jabatan = 'Kepala Bidang' THEN 12
                WHEN p.jabatan = 'Kasubbag' THEN 13
                WHEN p.golongan = 'PEMBINA UTAMA MUDA (IV/C)' THEN 14
                WHEN p.golongan = 'PEMBINA TK I (IV/B)' THEN 15
                WHEN p.golongan = 'PEMBINA (IV/A)' THEN 16
                WHEN p.golongan = 'PENATA TK I (III/D)' THEN 17
                WHEN p.golongan = 'PENATA (III/C)' THEN 18
                WHEN p.golongan = 'PENATA MUDA TK I (III/B)' THEN 19
                WHEN p.golongan = 'PENATA MUDA (III/A)' THEN 20
                WHEN p.golongan = 'PENGATUR TK I (II/D)' THEN 21
                WHEN p.golongan = 'PENGATUR (II/C)' THEN 22
                WHEN p.golongan = 'PENGATUR MUDA TK I (II/B)' THEN 23
                WHEN p.golongan = 'PENGATUR MUDA (II/A)' THEN 24
                ELSE 25
            END SEPARATOR '||') as tujuan_pegawai_list
          FROM surat_tugas st 
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

// Menggunakan prepared statement untuk keamanan
$stmt = mysqli_prepare($conn, $query);
if (!$stmt) {
    die('Error in preparing statement: ' . mysqli_error($conn));
}

mysqli_stmt_bind_param($stmt, "i", $id_surat);
$execute = mysqli_stmt_execute($stmt);
if (!$execute) {
    die('Error executing statement: ' . mysqli_stmt_error($stmt));
}

$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) == 0) {
    die('Data surat tidak ditemukan');
}

$surat = mysqli_fetch_assoc($result);

// Menentukan apakah surat ditandatangani oleh Bupati atau Sekda berdasarkan pejabat yang dipilih
$is_bupati = false;
$is_sekda = false;
if ($pejabat && isset($pejabat['jabatan'])) {
    if (strtolower($pejabat['jabatan']) === 'bupati balangan') {
        $is_bupati = true;
    } else if (strtolower($pejabat['jabatan']) === 'sekretaris daerah') {
        $is_sekda = true;
    }
}

// Pisahkan data pegawai menjadi array
$nama_pegawai = !empty($surat['nama_pegawai_list']) ? explode('||', $surat['nama_pegawai_list']) : array();
$nip = !empty($surat['nip_list']) ? explode('||', $surat['nip_list']) : array();
$pangkat = !empty($surat['pangkat_list']) ? explode('||', $surat['pangkat_list']) : array();
$jabatan = !empty($surat['jabatan_list']) ? explode('||', $surat['jabatan_list']) : array();

// Query untuk mengambil data kepala dinas dengan prepared statement
$query_kepala = "SELECT nama_pegawai, nip, golongan as pangkat, jabatan 
                 FROM pegawai 
                 WHERE jabatan = 'Kepala Dinas Pendidikan dan Kebudayan' 
                 LIMIT 1";
$result_kepala = mysqli_query($conn, $query_kepala);
$kepala_dinas = mysqli_fetch_assoc($result_kepala);

// Jika data kepala dinas tidak ditemukan, gunakan data default
if (!$kepala_dinas) {
    $kepala_dinas = [
        'nama_pegawai' => '[Nama Kepala Dinas]',
        'nip' => '[NIP Kepala Dinas]',
        'pangkat' => '[Pangkat Kepala Dinas]'
    ];
}

// Fungsi format tanggal Indonesia
function tanggal_indo($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi format bulan dan tahun
function bulan_tahun_indo($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    return $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Bagian fungsi get_pangkat diperbaiki
function get_pangkat($golongan) {
    $pangkat = array(
        'IV/c' => 'Pembina Utama Muda',
        'IV/b' => 'Pembina Tingkat I',
        'IV/a' => 'Pembina',
        'III/d' => 'Penata Tingkat I',
        'III/c' => 'Penata',
        'III/b' => 'Penata Muda Tingkat I',
        'III/a' => 'Penata Muda',
        'II/d' => 'Pengatur Tingkat I',
        'II/c' => 'Pengatur',
        'II/b' => 'Pengatur Muda Tingkat I',
        'II/a' => 'Pengatur Muda',
        'I/d' => 'Juru Tingkat I',
        'I/c' => 'Juru',
        'I/b' => 'Juru Muda Tingkat I',
        'I/a' => 'Juru Muda'
    );
    
    return isset($pangkat[$golongan]) ? $pangkat[$golongan] : '';
}

// Tambahkan fungsi untuk mengubah teks menjadi title case
function toTitleCase($string) {
    // Pisahkan string berdasarkan spasi
    $words = explode(' ', strtolower($string));
    
    // Ubah setiap kata menjadi kapital di awal
    foreach ($words as &$word) {
        // Jika kata mengandung tanda kurung, tangani secara khusus
        if (strpos($word, '(') !== false) {
            $parts = explode('(', $word);
            $parts[0] = ucfirst($parts[0]);
            if (isset($parts[1])) {
                // Untuk bagian dalam kurung, kapitalkan setiap huruf setelah '/'
                $innerParts = explode('/', $parts[1]);
                $innerParts = array_map('strtoupper', $innerParts);
                $parts[1] = implode('/', $innerParts);
            }
            $word = implode('(', $parts);
        } else {
            $word = ucfirst($word);
        }
    }
    
    return implode(' ', $words);
}

// Debug informasi jika diperlukan
if (isset($_GET['debug'])) {
    echo '<pre>';
    print_r([
        'Query' => $query,
        'ID Surat' => $id_surat,
        'Surat Data' => $surat,
        'Nama Pegawai' => $nama_pegawai,
        'NIP' => $nip,
        'Pangkat' => $pangkat,
        'Jabatan' => $jabatan,
        'Kepala Dinas' => $pejabat
    ]);
    exit;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Cetak Surat Tugas</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <style>
        @page {
            size: F4;  /* 215.9mm x 355.6mm */
            margin: 10mm 10mm 10mm 20mm;
        }
        
        body {
            font-family: Times New Roman;
            margin: 0;
            padding: 0;
            font-size: 12pt;
            line-height: 1.3;
            width: 215.9mm;
            height: 355.6mm;
        }
        .kop-surat {
            text-align: center;
            margin-bottom: 10px;
            position: relative;
            padding-top: 0;
        }
        .logo {
            width: 65px;
            position: absolute;
            left: 10px;
            top: 0;
        }
        .instansi {
            padding-top: 0;
            text-align: center;
            font-size: 12pt;
        }
        .instansi h3 {
            margin: 0 0 2px 0;
            font-size: 14pt;
            line-height: 1.1;
        }
        .alamat {
            text-align: center;
            font-size: 10pt;
            margin: 2px 0 3px 0;
        }
        .garis {
            border-bottom: 2px solid black;
            margin-top: 0;
            clear: both;
        }
        .garis-2 {
            border-bottom: 1px solid black;
            margin-top: 1px;
            clear: both;
        }
        .judul {
            text-align: center;
            margin: 15px 0 5px 0;
        }
        .judul-surat {
            text-align: center;
            text-decoration: underline;
            margin: 0;
        }
        .nomor-surat {
            text-align: center;
            margin: 0;
        }
        .content {
            margin: 20mm 10mm;
        }
        .menugaskan {
            text-align: center;
            margin: 20px 0;
        }
        .pegawai-list {
            margin-left: 40px;
        }
        .pegawai-item {
            margin-bottom: 20px;
        }
        .field-container {
            margin-bottom: 15px;
        }
        .field-label {
            display: inline-block;
            width: 60px;
            color: black;
        }
        .colon {
            display: inline-block;
            width: 15px;
            text-align: center;
            margin: 0 5px;
        }
        .field-value {
            display: inline-block;
        }
        .sub-field {
            margin-left: 25px;
        }
        .nomor {
            float: left;
            margin-right: 5px;
        }
        .ttd {
            float: right;
            margin-right: 40px;
            text-align: left;
        }
        .nama-label, .nip-label, .pangkat-label, .jabatan-label {
            color: black;
        }
        .ttd-container {
            float: right;
            width: 300px;
            margin-top: 20px;
            margin-right: 20px;
            text-align: left;
            page-break-inside: avoid;
        }
        .tempat-tanggal {
            margin-bottom: 5px;
            line-height: 1.2;
        }
        .tempat-tanggal .colon {
            display: inline-block;
            width: 20px;
            text-align: center;
            margin: 0 5px;
        }
        .jabatan-penandatangan {
            margin-bottom: 50px;
            line-height: 1.2;
        }
        .nama-penandatangan {
            text-decoration: underline;
            font-weight: bold;
            margin-bottom: 3px;
        }
        .pangkat-nip {
            line-height: 1.2;
        }
        
        /* Tambahkan style untuk mengatur page break setiap 7 nama */
        .pegawai-group {
            page-break-after: always;
        }
        .pegawai-group:last-child {
            page-break-after: auto;
        }
        @media print {
            .ttd-container {
                page-break-inside: avoid;
                break-inside: avoid;
                -webkit-break-inside: avoid;
            }
            
            .tempat-tanggal,
            .jabatan-penandatangan,
            .nama-penandatangan,
            .pangkat-nip {
                page-break-inside: avoid;
                break-inside: avoid;
                -webkit-break-inside: avoid;
            }
        }
        @media print {
            table {
                page-break-inside: avoid;
                font-family: Times New Roman;
                font-size: 12pt;
            }
            td {
                padding: 0;
                vertical-align: top;
            }
        }
        .field-row {
            width: 100%;
            margin-bottom: 2px;
            display: flex;
            align-items: flex-start;
        }
        .field-label {
            width: 80px;
            padding-top: 0;
            display: inline-block;
            vertical-align: top;
            flex-shrink: 0;
        }
        .field-colon {
            width: 15px;
            padding-top: 0;
            display: inline-block;
            text-align: center;
            vertical-align: top;
            flex-shrink: 0;
        }
        .field-content {
            display: inline-block;
            vertical-align: top;
            flex: 1;
            text-align: justify;
            line-height: 1.2;
            margin-top: 0;
            padding-top: 0;
        }
        
        /* Khusus untuk field maksud */
        .maksud-row {
            align-items: flex-start;
            display: flex;
        }
        .maksud-row .field-label {
            padding-top: 5px;
            margin-top: -2px;
        }
        .maksud-row .field-colon {
            padding-top: 5px;
            margin-top: -2px;
        }
        .maksud-row .field-content {
            padding-top: 5px;
            margin-top: -2px;
            line-height: 1.2;
        }
        
        /* Styling untuk kop Bupati */
        .logo-garuda {
            width: 80px;
            margin: 0 auto;
            display: block;
            padding-top: 5px;
        }
        
        .instansi-bupati {
            text-align: center;
            margin-bottom: 3px;
        }
        
        .instansi-bupati h3 {
            font-size: 16pt;
            font-weight: bold;
            margin: 0;
            text-transform: uppercase;
        }
        
        /* Style khusus untuk kop dinas */
        .kop-dinas {
            min-height: 80px;
            position: relative;
            margin-bottom: 3px;
        }
        
        .kop-dinas .alamat {
            text-align: center;
            font-size: 10pt;
            margin: 2px 0 3px 0;
            font-style: italic;
        }

        /* Perbaikan untuk container Bupati */
        .kop-bupati {
            margin-bottom: 5px;
            padding-top: 0;
        }
        .nama-pegawai {
            text-transform: uppercase;
            font-weight: bold;
        }

        /* Style khusus untuk kop sekda */
        .kop-sekda {
            min-height: 80px;
            position: relative;
            margin-bottom: 3px;
        }
        
        .kop-sekda .logo {
            width: 65px;
            position: absolute;
            left: 10px;
            top: 0;
        }
        
        .kop-sekda .instansi {
            padding-top: 0;
            text-align: center;
            font-size: 12pt;
        }
        
        .kop-sekda .instansi h3 {
            margin: 0 0 2px 0;
            font-size: 14pt;
            line-height: 1.1;
        }
        
        .kop-sekda .alamat {
    text-align: center;
    font-size: 10pt;
    margin: 2px 0 3px 0;
    font-style: italic;
}
    </style>
</head>
<body>

    
    <div class="kop-surat">
        <?php if ($is_bupati): ?>
            <div class="kop-bupati">
                <img src="../assets/img/garuda.png" class="logo-garuda">
                <div class="instansi-bupati">
                    <h3>BUPATI BALANGAN</h3>
                </div>
            </div>
        <?php elseif ($is_sekda): ?>
            <div class="kop-sekda">
                <img src="../assets/img/logo.png" class="logo">
                <div class="instansi">
                    <h3>PEMERINTAH KABUPATEN BALANGAN</h3>
                    <h3>SEKRETARIAT DAERAH</h3>
                </div>
                <div class="alamat">
                    Jalan Jenderal Ahmad Yani KM.4 No.01 Paringin Kode Pos - 71462 Telp/Fax. (0526) 2029561
                </div>
            </div>
        <?php else: ?>
            <div class="kop-dinas">
                <img src="../assets/img/logo.png" class="logo">
                <div class="instansi">
                    <h3>PEMERINTAH KABUPATEN BALANGAN</h3>
                    <h3>DINAS PENDIDIKAN DAN KEBUDAYAAN</h3>
                </div>
                <div class="alamat">
                    Jl. A. Yani Km 2,5 Kel. Batu Piring Kec. Paringin Selatan Kode Pos 71611 Telp. 0526-2028192
                </div>
            </div>
        <?php endif; ?>
        <div class="garis"></div>
        <div class="garis-2"></div>
    </div>

    <div class="judul">
        <p class="judul-surat"><?= $is_bupati ? 'SURAT PERINTAH TUGAS' : ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi' ? 'SURAT TUGAS' : 'SURAT PERINTAH TUGAS') ?></p>
        <p class="nomor-surat">
            <?php
            // Check if nomor surat exists and is not just a dash
            if (!empty($surat['no_surat']) && $surat['no_surat'] !== '-') {
                echo "NOMOR : " . htmlspecialchars($surat['no_surat']);
            } else {
                echo "NOMOR : 090/____/ST-___/Disdikbud/" . date('Y');
            }
            ?>
        </p>
    </div>
    <?php if (!empty($surat['dasar_surat'])): ?>
    <div class="content">
        <div class="field-row">
            <span class="field-label">Dasar Surat</span>
            <span class="field-colon">:</span>
            <div class="field-content">
                <?= nl2br(htmlspecialchars($surat['dasar_surat'])) ?>
            </div>
        </div>
    </div>
    <?php endif; ?>
    <div class="content">
        <p class="menugaskan">MENUGASKAN :</p>

        <p>Kepada      :</p>
        <div class="pegawai-list">
            <?php 
            $tujuan_list = !empty($surat['tujuan_pegawai_list']) ? explode('||', $surat['tujuan_pegawai_list']) : array();
            $total_pegawai = count($nama_pegawai);

            // Buat grup pertama dengan maksimal 7 nama
            $first_group = array_slice($nama_pegawai, 0, 7);
            $remaining_pegawai = array_slice($nama_pegawai, 7);

            // Buat grup untuk sisa nama (6 per halaman)
            $remaining_groups = array_chunk($remaining_pegawai, 6);

            // Gabungkan grup pertama dengan grup sisanya
            $groups = array_merge([$first_group], $remaining_groups);

            foreach($groups as $group_index => $group):
            ?>
                <div class="pegawai-list" <?= ($group_index < count($groups) - 1) ? 'style="page-break-after: always;"' : '' ?>>
                <?php
                for($i = 0; $i < count($group); $i++): 
                    $index = ($group_index == 0) ? $i : (7 + (($group_index - 1) * 6) + $i);
                ?>
                    <div class="pegawai-item">
                        <div class="nomor"><?= ($index + 1) ?>.</div>
                        <div class="sub-field">
                            <span class="field-label nama-label">Nama</span>
                            <span class="colon">:</span>
                            <span class="field-value nama-pegawai"><?= $group[$i] ?></span>
                        </div>
                        
                        <div class="sub-field">
                            <span class="field-label nip-label">NIP</span>
                            <span class="colon">:</span>
                            <span class="field-value"><?= (isset($pangkat[$index]) && strtolower($pangkat[$index]) !== 'non asn') ? $nip[$index] : '-' ?></span>
                        </div>
                        
                        <div class="sub-field">
                            <span class="field-label pangkat-label">Pangkat</span>
                            <span class="colon">:</span>
                            <span class="field-value"><?= (isset($pangkat[$index]) && strtolower($pangkat[$index]) !== 'non asn') ? toTitleCase(htmlspecialchars($pangkat[$index])) : '-' ?></span>
                        </div>
                        
                        <div class="sub-field">
                            <span class="field-label jabatan-label">Jabatan</span>
                            <span class="colon">:</span>
                            <span class="field-value"><?= $jabatan[$index] ?></span>
                        </div>

                        <?php 
                        // Tampilkan tujuan per pegawai hanya jika surat dalam daerah dalam provinsi dan bukan untuk bimtek
                        if ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi' && 
                            stripos($surat['maksud'], 'bimtek') === false && 
                            stripos($surat['maksud'], 'bimbingan teknis') === false): 
                        ?>
                        <div class="sub-field">
                            <span class="field-label">Tujuan</span>
                            <span class="colon">:</span>
                            <span class="field-value"><?= htmlspecialchars($tujuan_list[$index]) ?></span>
                        </div>
                        <?php endif; ?>
                    </div>
                <?php endfor; ?>
                </div>
            <?php endforeach; ?>

            <?php if ($group_index === count($groups) - 1): ?>
            <div <?= (count($group) === 6) ? 'style="page-break-before: always;"' : '' ?>>
                <div class="field-row maksud-row">
                    <span class="field-label">Maksud</span>
                    <span class="field-colon">:</span>
                    <div class="field-content">
                        <?php 
                        $maksud = str_replace(["\r\n", "\r", "\n"], " ", $surat['maksud']); 
                        echo nl2br(htmlspecialchars($maksud)); 
                        ?>
                    </div>
                </div>

                <?php 
                // Tampilkan tujuan sekali saja jika bukan surat dalam daerah dalam provinsi
                // atau jika surat dalam daerah dalam provinsi khusus untuk bimtek
                if ($surat['jenis_surat'] != 'Dalam Daerah Dalam Provinsi' || 
                    stripos($surat['maksud'], 'bimtek') !== false || 
                    stripos($surat['maksud'], 'bimbingan teknis') !== false): 
                ?>
                <div class="field-row">
                    <span class="field-label">Tujuan</span>
                    <span class="field-colon">:</span>
                    <span class="field-content"><?= htmlspecialchars($surat['tempat_kegiatan']) ?></span>
                </div>
                <?php endif; ?>

                <div class="field-row">
                    <span class="field-label">Tanggal</span>
                    <span class="field-colon">:</span>
                    <span class="field-content">
                        <?php 
                        if($surat['tanggal_berangkat'] == $surat['tanggal_kembali']) {
                            echo tanggal_indo($surat['tanggal_berangkat']);
                        } else {
                            echo tanggal_indo($surat['tanggal_berangkat']) . ' s/d ' . tanggal_indo($surat['tanggal_kembali']);
                        }
                        ?>
                    </span>
                </div>

                <p>Demikian dikeluarkan untuk dilaksanakan dengan penuh tanggung jawab.</p>

                <div class="ttd-container">
                    <div class="tempat-tanggal">
                        <div style="margin-left: 65px;">
                            Ditetapkan di : Paringin<br>
                            pada tanggal : ___<?= bulan_tahun_indo($surat['tanggal_surat']) ?>
                        </div>
                        <?php if ($is_sekda): ?>
                            <div style="margin-left: 35px;">a.n. Bupati</div>
                        <div style="margin-left: 35px;">Pj. Sekretaris Daerah</div>
                        <?php else: ?>
                        
                        <div style="margin-left: 65px;"><?= htmlspecialchars($pejabat['jabatan']) ?></div>
                        <?php endif; ?>
                    </div>
                    <br>
                    <div class="nama-penandatangan" style="margin-top: 50px; margin-left: 65px;">
                        <?= htmlspecialchars($pejabat['nama']) ?>
                    </div>
                    
                    <div class="pangkat-nip" style="margin-left: 65px;">
                        <?= toTitleCase(htmlspecialchars($pejabat['pangkat'])) ?> / <?= htmlspecialchars($pejabat['golongan']) ?><br>
                        NIP. <?= htmlspecialchars($pejabat['nip']) ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
       window.onload = function() {
            setTimeout(function() {
                window.print();
               
            }, 500);
        }
       
    </script>
</body>
</html> 