<?php
require_once '../config/config.php';

if (!isset($_GET['id']) || empty($_GET['id'])) {
    header("Location: lihat_surat.php");
    exit();
}

$id_surat = $_GET['id'];

// Query untuk mengambil data surat tugas
$query = "SELECT st.*, 
          GROUP_CONCAT(
              DISTINCT CONCAT(p.nama_pegawai, '|', p.nip, '|', p.jabatan) 
              SEPARATOR ';;'
          ) as pegawai_info
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) == 0) {
    header("Location: lihat_surat.php");
    exit();
}

$data = mysqli_fetch_assoc($result);

// Memproses data pegawai
$pegawai_list = [];
if (!empty($data['pegawai_info'])) {
    $pegawai_array = explode(';;', $data['pegawai_info']);
    foreach ($pegawai_array as $pegawai) {
        $info = explode('|', $pegawai);
        if (count($info) == 3) {
            $pegawai_list[] = [
                'nama' => $info[0],
                'nip' => $info[1],
                'jabatan' => $info[2]
            ];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Surat Tugas - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS Libraries -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">

    <!-- Custom CSS -->
    <style>
        /* Root variables */
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --primary-color: #0ea5e9;
            --primary-hover: #0891cf;
            --secondary-color: #6B7280;
            --light-bg: #F3F4F6;
            --sidebar-width: 280px;
            --sidebar-mini-width: 70px;
            --content-padding: 2rem;
        }

        body {
            background: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }

        .header-wrapper {
            background: var(--primary-gradient) !important;
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            color: white;
        }

        .header-wrapper h2 {
            font-size: 2rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            color: white;
        }

        .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }

        .breadcrumb-item a:hover {
            color: white;
        }

        .breadcrumb-item.active {
            color: white;
        }

        .breadcrumb-item + .breadcrumb-item::before {
            color: rgba(255, 255, 255, 0.6);
        }

        .card {
            background: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
            margin-bottom: 2rem;
        }

        .card-body {
            padding: 2rem;
        }

        .table {
            margin-bottom: 0;
        }

        .table-borderless td {
            padding: 0.75rem 0;
            color: #374151;
        }

        .table-bordered {
            border-radius: 8px;
            overflow: hidden;
        }

        .table-bordered thead th {
            background: var(--primary-gradient);
            color: white;
            font-weight: 500;
            border: none;
            padding: 1rem;
        }

        .table-bordered td {
            padding: 1rem;
            border-color: #E5E7EB;
            color: #374151;
        }

        h5 {
            color: #111827;
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-secondary {
            background-color: #F3F4F6;
            border: 1px solid #E5E7EB;
            color: #374151;
        }

        .btn-secondary:hover {
            background-color: #E5E7EB;
            color: #1F2937;
            transform: translateY(-1px);
        }

        .btn i {
            margin-right: 0.5rem;
        }

        .table-responsive {
            border-radius: 8px;
            overflow: hidden;
        }

        @media (max-width: 768px) {
            .header-wrapper {
                padding: 1.5rem;
                margin-bottom: 1.5rem;
            }

            .card-body {
                padding: 1.5rem;
            }

            .btn {
                padding: 0.625rem 1.25rem;
            }

            h5 {
                font-size: 1.1rem;
                margin-bottom: 1rem;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid mt-4">
    <div class="header-wrapper mb-4">
        <h2><i class="bi bi-file-text me-2"></i>Detail Surat Tugas</h2>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="lihat_surat.php">Surat Tugas</a></li>
                <li class="breadcrumb-item active">Detail Surat</li>
            </ol>
        </nav>
    </div>

    <div class="card">
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-md-6">
                    <h5><i class="bi bi-info-circle me-2"></i>Informasi Surat</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><i class="bi bi-hash me-2"></i>Nomor Surat</td>
                            <td>: <?= htmlspecialchars($data['no_surat']) ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-hash me-2"></i>Nomor SPPD</td>
                            <td>: <?= htmlspecialchars($data['no_sppd'] ?: '-') ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-calendar me-2"></i>Tanggal Surat</td>
                            <td>: <?= date('d/m/Y', strtotime($data['tanggal_surat'])) ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-card-text me-2"></i>Maksud</td>
                            <td>: <?= htmlspecialchars($data['maksud'] ?: '-') ?></td>
                        </tr>
                        <tr>
                            <th width="200">Jenis Surat</th>
                            <td>
                                <?= htmlspecialchars($data['jenis_surat']) ?>
                                <?php if ($data['is_bimtek']): ?>
                                    <span class="badge bg-info" title="Bimtek/Pelatihan">
                                        <i class="bi bi-mortarboard"></i> Bimtek/Pelatihan
                                    </span>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h5><i class="bi bi-geo-alt me-2"></i>Detail Perjalanan</h5>
                    <table class="table table-borderless">
                        <tr>
                            <td width="150"><i class="bi bi-pin-map me-2"></i>Tujuan</td>
                            <td>: <?= htmlspecialchars($data['tujuan']) ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-calendar2-check me-2"></i>Tanggal Berangkat</td>
                            <td>: <?= date('d/m/Y', strtotime($data['tanggal_berangkat'])) ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-calendar2-x me-2"></i>Tanggal Kembali</td>
                            <td>: <?= date('d/m/Y', strtotime($data['tanggal_kembali'])) ?></td>
                        </tr>
                        <tr>
                            <td><i class="bi bi-clock me-2"></i>Lama Perjalanan</td>
                            <td>: <?= $data['lama_perjalanan'] ?> hari</td>
                        </tr>
                    </table>
                </div>
            </div>

            <h5><i class="bi bi-people me-2"></i>Pegawai yang Ditugaskan</h5>
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th width="5%">No</th>
                            <th>Nama Pegawai</th>
                            <th>NIP</th>
                            <th>Jabatan</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        foreach ($pegawai_list as $pegawai):
                        ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td><?= htmlspecialchars($pegawai['nama']) ?></td>
                            <td><?= htmlspecialchars($pegawai['nip']) ?></td>
                            <td><?= htmlspecialchars($pegawai['jabatan']) ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <div class="mt-4">
                <a href="lihat_surat.php" class="btn btn-secondary">
                    <i class="bi bi-arrow-left"></i> Kembali
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 