<?php
// Nonaktifkan semua error reporting
error_reporting(0);
ini_set('display_errors', 0);

require_once '../config/config.php';
require_once '../config/database.php';
require_once '../vendor/autoload.php';

use PhpOffice\PhpWord\PhpWord;
use PhpOffice\PhpWord\Style\Font;
use PhpOffice\PhpWord\SimpleType\Jc;
use PhpOffice\PhpWord\Shared\Converter;

// Ambil ID surat dari parameter URL dengan validasi
$id_surat = isset($_GET['id']) ? (int)$_GET['id'] : die('ID Surat tidak ditemukan');

// Ambil data pejabat yang dipilih
$id_pejabat = isset($_GET['id_pejabat']) ? (int)$_GET['id_pejabat'] : 0;
$pejabat = null;

if ($id_pejabat > 0) {
    $query_pejabat = "SELECT * FROM pejabat_daerah WHERE id_pejabat = ?";
    $stmt = mysqli_prepare($conn, $query_pejabat);
    mysqli_stmt_bind_param($stmt, "i", $id_pejabat);
    mysqli_stmt_execute($stmt);
    $result_pejabat = mysqli_stmt_get_result($stmt);
    $pejabat = mysqli_fetch_assoc($result_pejabat);
}

// Jika tidak ada pejabat yang dipilih atau data tidak ditemukan, gunakan default
if (!$pejabat) {
    $pejabat = [
        'nama' => 'H.HABIJI. S.Pd.,M.AP',
        'nip' => '19690813 199412 1 002',
        'pangkat' => 'Pembina Utama Muda',
        'golongan' => 'IV/c',
        'jabatan' => 'Kepala Dinas Pendidikan dan Kebudayaan Kabupaten Balangan'
    ];
}

// Query untuk data surat dan pegawai
$query = "SELECT st.*, 
          GROUP_CONCAT(p.nama_pegawai ORDER BY 
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END SEPARATOR '||') as nama_pegawai_list,
          GROUP_CONCAT(p.nip ORDER BY 
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END SEPARATOR '||') as nip_list,
          GROUP_CONCAT(p.golongan ORDER BY 
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END SEPARATOR '||') as pangkat_list,
          GROUP_CONCAT(p.jabatan ORDER BY 
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END SEPARATOR '||') as jabatan_list,
          GROUP_CONCAT(dst.tujuan_pegawai ORDER BY 
            CASE p.golongan
                WHEN 'PEMBINA UTAMA MUDA (IV/C)' THEN 1
                WHEN 'PEMBINA TK I (IV/B)' THEN 2
                WHEN 'PEMBINA (IV/A)' THEN 3
                WHEN 'PENATA TK I (III/D)' THEN 4
                WHEN 'PENATA (III/C)' THEN 5
                WHEN 'PENATA MUDA TK I (III/B)' THEN 6
                WHEN 'PENATA MUDA (III/A)' THEN 7
                WHEN 'PENGATUR TK I (II/D)' THEN 8
                WHEN 'PENGATUR (II/C)' THEN 9
                WHEN 'PENGATUR MUDA TK I (II/B)' THEN 10
                WHEN 'PENGATUR MUDA (II/A)' THEN 11
                ELSE 12
            END SEPARATOR '||') as tujuan_pegawai_list
          FROM surat_tugas st 
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai 
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$surat = mysqli_fetch_assoc($result);

if (!$surat) {
    die('Data surat tidak ditemukan');
}

// Fungsi format tanggal Indonesia
function tanggal_indo($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi format bulan dan tahun
function bulan_tahun_indo($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    return $bulan[(int)$split[1]] . ' ' . $split[0];
}

// Fungsi untuk mengubah teks menjadi title case
function toTitleCase($string) {
    $words = explode(' ', strtolower($string));
    foreach ($words as &$word) {
        if (strpos($word, '(') !== false) {
            $parts = explode('(', $word);
            $parts[0] = ucfirst($parts[0]);
            if (isset($parts[1])) {
                $innerParts = explode('/', $parts[1]);
                $innerParts = array_map('strtoupper', $innerParts);
                $parts[1] = implode('/', $innerParts);
            }
            $word = implode('(', $parts);
        } else {
            $word = ucfirst($word);
        }
    }
    return implode(' ', $words);
}

// Menentukan apakah surat ditandatangani oleh Bupati atau Sekda
$is_bupati = false;
$is_sekda = false;
if ($pejabat && isset($pejabat['jabatan'])) {
    if (strtolower($pejabat['jabatan']) === 'bupati balangan') {
        $is_bupati = true;
    } else if (strtolower($pejabat['jabatan']) === 'sekretaris daerah') {
        $is_sekda = true;
    }
}

// Pisahkan data pegawai menjadi array
$nama_pegawai = !empty($surat['nama_pegawai_list']) ? explode('||', $surat['nama_pegawai_list']) : array();
$nip = !empty($surat['nip_list']) ? explode('||', $surat['nip_list']) : array();
$pangkat = !empty($surat['pangkat_list']) ? explode('||', $surat['pangkat_list']) : array();
$jabatan = !empty($surat['jabatan_list']) ? explode('||', $surat['jabatan_list']) : array();
$tujuan_list = !empty($surat['tujuan_pegawai_list']) ? explode('||', $surat['tujuan_pegawai_list']) : array();

// Buat instance PHPWord
$phpWord = new PhpWord();

// Set default font
$phpWord->setDefaultFontName('Times New Roman');
$phpWord->setDefaultFontSize(12);

// Tambah style
$phpWord->addFontStyle('titleStyle', ['bold' => true, 'size' => 14]);
$phpWord->addFontStyle('headerStyle', ['bold' => true, 'size' => 14]);
$phpWord->addFontStyle('alamatStyle', ['size' => 10]);
$phpWord->addFontStyle('normalStyle', ['size' => 12]);
$phpWord->addFontStyle('boldStyle', ['bold' => true, 'size' => 12]);

// Style paragraf
$phpWord->addParagraphStyle('centerStyle', [
    'alignment' => Jc::CENTER,
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'spacing' => 120 // Line spacing
]);

$phpWord->addParagraphStyle('contentStyle', [
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'spacing' => 120 // Line spacing
]);

// Buat section baru dengan margin yang sesuai
$section = $phpWord->addSection([
    'marginLeft' => 850, // Reduced left margin further
    'marginRight' => 850, // Reduced right margin to match
    'marginTop' => 360,
    'marginBottom' => 1440
]);

// KOP SURAT
if ($is_bupati) {
    // Use kopbupati.png for Bupati header
    $section->addImage('../assets/img/kop/kopbupati.png', [
        'width' => 500,
        'height' => 90,
        'alignment' => Jc::START, // Changed to left alignment
        'wrappingStyle' => 'inline'
    ]);
} else if ($is_sekda) {
    // Use kopsekda.png for Sekda header
    $section->addImage('../assets/img/kop/kopsekda.png', [
        'width' => 500,
        'height' => 90,
        'alignment' => Jc::START, // Changed to left alignment
        'wrappingStyle' => 'inline'
    ]);
} else {
    // Use kopdinas.png for Dinas header
    $section->addImage('../assets/img/kop/kopdinas.png', [
        'width' => 500,
        'height' => 90,
        'alignment' => Jc::START, // Changed to left alignment
        'wrappingStyle' => 'inline'
    ]);
}

// Minimal spacing after kop
$section->addText('', null, [
    'spacing' => 60,  // Reduced spacing
    'spaceAfter' => 0,
    'spaceBefore' => 0
]);

// Custom styles for the document
$phpWord->addFontStyle('normalStyle', [
    'name' => 'Times New Roman',
    'size' => 12
]);

$phpWord->addFontStyle('boldStyle', [
    'name' => 'Times New Roman',
    'size' => 12,
    'bold' => true
]);

$phpWord->addFontStyle('underlineStyle', [
    'name' => 'Times New Roman',
    'size' => 12,
    'underline' => 'single'
]);

$phpWord->addFontStyle('boldUnderlineStyle', [
    'name' => 'Times New Roman',
    'size' => 12,
    'bold' => true,
    'underline' => 'single'
]);

$phpWord->addParagraphStyle('centerStyle', [
    'alignment' => Jc::CENTER,
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'spacing' => 120,
    'lineHeight' => 1.0
]);

$phpWord->addParagraphStyle('leftStyle', [
    'alignment' => Jc::START,
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'spacing' => 120,
    'lineHeight' => 1.0
]);

// Add title with proper formatting
$judul = $is_bupati ? 'SURAT PERINTAH TUGAS' : 
    ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi' ? 'SURAT TUGAS' : 'SURAT PERINTAH TUGAS');
$section->addText($judul, 'boldUnderlineStyle', [
    'alignment' => Jc::CENTER,
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'spacing' => 120,
    'lineHeight' => 1.0
]);

// Add nomor with proper formatting
$nomor_surat = !empty($surat['no_surat']) && $surat['no_surat'] !== '-' ? 
    $surat['no_surat'] : "090/____/ST-___/Disdikbud/" . date('Y');
$section->addText('NOMOR : ' . $nomor_surat, 'underlineStyle', 'centerStyle');

$section->addTextBreak(2);

// Add MENUGASKAN with proper formatting
$section->addText('MENUGASKAN :', 'boldUnderlineStyle', 'centerStyle');

$section->addTextBreak(1);

// Add Kepada with proper formatting
$section->addText('Kepada :', 'boldUnderlineStyle', 'leftStyle');

$section->addTextBreak(1);

// Data Pegawai with proper formatting
foreach ($nama_pegawai as $i => $nama) {
    // Table for each pegawai group
    $table = $section->addTable([
        'borderSize' => 0,
        'cellMargin' => 0,
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Nomor and data container
    $table->addRow(0);
    
    // Nomor cell
    $cell = $table->addCell(500, [
        'valign' => 'top',
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $cell->addText(($i + 1) . '.', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Data pegawai cell
    $cell = $table->addCell(8500, [
        'valign' => 'top',
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Inner table for pegawai details
    $innerTable = $cell->addTable([
        'borderSize' => 0,
        'cellMargin' => 0,
        'cellSpacing' => 0,
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Row style for minimal spacing
    $rowStyle = [
        'exactHeight' => 240 // Approximately 12pt
    ];

    // Nama
    $innerTable->addRow(0, $rowStyle);
    $innerTable->addCell(1500)->addText('Nama', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(300)->addText(':', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(6700)->addText(strtoupper($nama), 'boldUnderlineStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // NIP
    $innerTable->addRow(0, $rowStyle);
    $innerTable->addCell(1500)->addText('NIP', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(300)->addText(':', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(6700)->addText((isset($pangkat[$i]) && strtolower($pangkat[$i]) !== 'non asn') ? $nip[$i] : '-', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Pangkat
    $innerTable->addRow(0, $rowStyle);
    $innerTable->addCell(1500)->addText('Pangkat', 'underlineStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(300)->addText(':', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(6700)->addText((isset($pangkat[$i]) && strtolower($pangkat[$i]) !== 'non asn') ? 
        toTitleCase($pangkat[$i]) : '-', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Jabatan
    $innerTable->addRow(0, $rowStyle);
    $innerTable->addCell(1500)->addText('Jabatan', 'underlineStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(300)->addText(':', 'normalStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);
    $innerTable->addCell(6700)->addText($jabatan[$i], 'underlineStyle', [
        'spacing' => 0,
        'spaceAfter' => 0,
        'spaceBefore' => 0
    ]);

    // Tambahkan Tujuan jika jenis surat adalah Dalam Daerah Dalam Provinsi
    if ($surat['jenis_surat'] == 'Dalam Daerah Dalam Provinsi' && isset($tujuan_list[$i])) {
        $innerTable->addRow(0, $rowStyle);
        $innerTable->addCell(1500)->addText('Tujuan', 'underlineStyle', [
            'spacing' => 0,
            'spaceAfter' => 0,
            'spaceBefore' => 0
        ]);
        $innerTable->addCell(300)->addText(':', 'normalStyle', [
            'spacing' => 0,
            'spaceAfter' => 0,
            'spaceBefore' => 0
        ]);
        $innerTable->addCell(6700)->addText($tujuan_list[$i], 'normalStyle', [
            'spacing' => 0,
            'spaceAfter' => 0,
            'spaceBefore' => 0
        ]);
    }

    // Add minimal spacing between pegawai entries
    if ($i < count($nama_pegawai) - 1) {
        $section->addText('', null, [
            'spacing' => 0,
            'spaceAfter' => 60,  // Very minimal space between pegawai
            'spaceBefore' => 0
        ]);
    }
}

$section->addTextBreak(1);

// Maksud
$table = $section->addTable(['borderSize' => 0, 'cellMargin' => 0, 'spacing' => 0]);
$table->addRow();
$table->addCell(1500)->addText('Maksud', 'normalStyle');
$table->addCell(300)->addText(':', 'normalStyle');
$table->addCell(6700)->addText($surat['maksud'], 'normalStyle');

// Tujuan hanya ditampilkan jika bukan Dalam Daerah Dalam Provinsi
if ($surat['jenis_surat'] != 'Dalam Daerah Dalam Provinsi') {
    $table->addRow();
    $table->addCell(1500)->addText('Tujuan', 'normalStyle');
    $table->addCell(300)->addText(':', 'normalStyle');
    $table->addCell(6700)->addText($surat['tempat_kegiatan'], 'normalStyle');
}

// Format tanggal
$tanggal_text = $surat['tanggal_berangkat'] == $surat['tanggal_kembali'] ?
    tanggal_indo($surat['tanggal_berangkat']) :
    tanggal_indo($surat['tanggal_berangkat']) . ' s/d ' . tanggal_indo($surat['tanggal_kembali']);

$table->addRow();
$table->addCell(1500)->addText('Tanggal', 'normalStyle');
$table->addCell(300)->addText(':', 'normalStyle');
$table->addCell(6700)->addText($tanggal_text, 'normalStyle');

$section->addTextBreak(1);
$section->addText('Demikian dikeluarkan untuk dilaksanakan dengan penuh tanggung jawab.', 'normalStyle');

// Tanda tangan menggunakan paragraf
$section->addTextBreak(1);

// Style untuk bagian tanda tangan
$rightParagraphStyle = [
    'alignment' => Jc::END,
    'spacing' => 0,
    'spaceAfter' => 0,
    'spaceBefore' => 0,
    'lineHeight' => 1.0
];

// Ditetapkan di
$textrun = $section->addTextRun($rightParagraphStyle);
$textrun->addText('Ditetapkan di : ', 'normalStyle');
$textrun->addText('Paringin', 'underlineStyle');

// Pada tanggal
$textrun = $section->addTextRun($rightParagraphStyle);
$textrun->addText('pada tanggal  : ', 'normalStyle');
$textrun->addText('___' . bulan_tahun_indo($surat['tanggal_surat']), 'normalStyle');

// Jabatan
if ($is_sekda) {
    $section->addText('Plh. Sekretaris Daerah', 'underlineStyle', $rightParagraphStyle);
} else {
    $section->addText($pejabat['jabatan'], 'underlineStyle', $rightParagraphStyle);
}

// Space untuk tanda tangan
$section->addTextBreak(2);

// Nama pejabat
$section->addText($pejabat['nama'], 'boldUnderlineStyle', $rightParagraphStyle);

// Pangkat/Golongan
$section->addText(toTitleCase($pejabat['pangkat']) . ' / ' . $pejabat['golongan'], 'normalStyle', $rightParagraphStyle);

// NIP
$section->addText('NIP. ' . $pejabat['nip'], 'normalStyle', $rightParagraphStyle);

// Set header untuk download
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="Surat_Tugas_' . $surat['no_sppd'] . '.docx"');

// Tambahkan script JavaScript untuk menampilkan petunjuk sebelum download
?>
<script>
alert("Petunjuk Pengaturan Margin Word:\n\n" +
      "1. Buka dokumen di Microsoft Word\n" +
      "2. Klik menu 'Layout'\n" +
      "3. Klik 'Margins'\n" +
      "4. Atur margin sebagai berikut:\n" +
      "   - Top: 2.54 cm (1 inch)\n" +
      "   - Bottom: 2.54 cm (1 inch)\n" +
      "   - Left: 3.17 cm (1.25 inch)\n" +
      "   - Right: 3.17 cm (1.25 inch)");
</script>
<?php

// Simpan dokumen
$objWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'Word2007');
$objWriter->save('php://output');
exit; 