<?php
require_once '../config/config.php';

// Cek ID surat
if(!isset($_GET['id'])) {
    header("Location: lihat_surat.php");
    exit();
}

$id_surat = $_GET['id'];

// Query untuk mengambil data surat tugas
$query = "SELECT st.*, 
          GROUP_CONCAT(dst.id_pegawai) as selected_pegawai,
          GROUP_CONCAT(dst.tujuan_pegawai) as tujuan_pegawai_list 
          FROM surat_tugas st
          LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
          WHERE st.id_surat = ?
          GROUP BY st.id_surat";

$stmt = mysqli_prepare($conn, $query);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if (!$result || mysqli_num_rows($result) == 0) {
    header("Location: lihat_surat.php");
    exit();
}

$data = mysqli_fetch_assoc($result);
$selected_pegawai = !empty($data['selected_pegawai']) ? explode(',', $data['selected_pegawai']) : [];
$tujuan_pegawai = !empty($data['tujuan_pegawai_list']) ? explode(',', $data['tujuan_pegawai_list']) : [];

// Query untuk mengambil daftar pegawai
$query_pegawai = "SELECT id_pegawai, nama_pegawai, nip, jabatan, golongan FROM pegawai ORDER BY CAST(SUBSTRING_INDEX(golongan, '/', 1) AS UNSIGNED) DESC, SUBSTRING_INDEX(golongan, '/', -1) DESC, nama_pegawai ASC";
$result_pegawai = mysqli_query($conn, $query_pegawai);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Surat Tugas - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS Libraries -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    <style>
        :root {
            --primary-color: #0ea5e9;
            --primary-hover: #0891cf;
            --secondary-color: #64748b;
            --light-bg: #f8fafc;
            --border-color: #e2e8f0;
        }

        body {
            background: linear-gradient(135deg, #f0f9ff 0%, #e0f2fe 100%);
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            line-height: 1.5;
        }

        .page-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #2dd4bf 100%);
            padding: 1.5rem;
            border-radius: 1rem;
            margin-bottom: 2rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
        }

        .page-header h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }

        .breadcrumb-item.active {
            color: white;
        }

        .card {
            border: none;
            border-radius: 1rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            background: white;
        }

        .form-section {
            padding: 1.5rem;
            border-bottom: 1px solid var(--border-color);
        }

        .form-section:last-child {
            border-bottom: none;
        }

        .section-title {
            font-size: 1rem;
            font-weight: 600;
            color: var(--secondary-color);
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .section-title i {
            color: var(--primary-color);
        }

        .form-control, .form-select {
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            padding: 0.625rem 0.875rem;
            font-size: 0.875rem;
            transition: all 0.2s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.15);
        }

        .input-group-text {
            background-color: var(--light-bg);
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            padding: 0.625rem;
            color: var(--secondary-color);
        }

        .btn {
            padding: 0.625rem 1.25rem;
            border-radius: 0.5rem;
            font-size: 0.875rem;
            font-weight: 500;
            transition: all 0.2s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, var(--primary-color) 0%, #2dd4bf 100%);
            border: none;
        }

        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.15);
        }

        .btn-secondary {
            background-color: var(--light-bg);
            border: 1px solid var(--border-color);
            color: var(--secondary-color);
        }

        .form-check-input:checked {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
        }

        .select2-container--bootstrap-5 .select2-selection {
            border-radius: 0.5rem;
            border: 1px solid var(--border-color);
            min-height: 38px;
        }

        .form-label {
            font-size: 0.875rem;
            font-weight: 500;
            color: var(--secondary-color);
            margin-bottom: 0.375rem;
        }

        .form-text {
            font-size: 0.75rem;
            color: var(--secondary-color);
        }

        .search-results {
            position: absolute;
            z-index: 1000;
            background: white;
            width: 100%;
            border: 1px solid var(--border-color);
            border-radius: 0.5rem;
            margin-top: 0.25rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1);
            max-height: 200px;
            overflow-y: auto;
        }

        .tujuan-item {
            padding: 0.5rem 1rem;
            cursor: pointer;
            transition: background-color 0.2s;
        }

        .tujuan-item:hover {
            background-color: var(--light-bg);
            color: var(--primary-color);
        }

        @media (max-width: 768px) {
            .page-header {
                padding: 1rem;
                margin-bottom: 1rem;
            }

            .form-section {
                padding: 1rem;
            }
        }
    </style>
</head>
<body>

<div class="container-fluid mt-4">
    <div class="page-header">
        <h1>Edit Surat Tugas</h1>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="lihat_surat.php">Surat Tugas</a></li>
                <li class="breadcrumb-item active">Edit</li>
            </ol>
        </nav>
    </div>

    <div class="card">
        <div class="card-body p-0">
            <form action="proses_edit.php" method="POST">
                <input type="hidden" name="id_surat" value="<?= $id_surat ?>">
                
                <!-- Informasi Surat -->
                <div class="form-section">
                    <h6 class="section-title">
                        <i class="bi bi-file-earmark-text"></i>
                        Informasi Surat
                    </h6>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Nomor Surat</label>
                            <input type="text" class="form-control" name="no_surat" value="<?= htmlspecialchars($data['no_surat']) ?>">
                            <div class="form-text">Boleh diisi tanda strip (-) atau copy dari E-BKU</div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-check mt-4">
                                <input class="form-check-input" type="checkbox" name="is_bimtek" id="isBimtek" value="1" <?= $data['is_bimtek'] ? 'checked' : '' ?>>
                                <label class="form-check-label" for="isBimtek">
                                    Surat Tugas Khusus Bimtek/Pelatihan
                                </label>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Jenis Surat</label>
                            <select class="form-select" name="jenis_surat" required>
                                <option value="">Pilih Jenis Surat</option>
                                <option value="Dalam Daerah Dalam Provinsi">Dalam Daerah Dalam Provinsi</option>
                                <option value="Luar Daerah Dalam Provinsi">Luar Daerah Dalam Provinsi</option>
                                <option value="Luar Daerah Luar Provinsi">Luar Daerah Luar Provinsi</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Nomor SPPD</label>
                            <input type="text" class="form-control" name="no_sppd" value="<?= htmlspecialchars($data['no_sppd']) ?>">
                        </div>
                    </div>
                </div>

                <!-- Detail Pegawai -->
                <div class="form-section">
                    <h6 class="section-title">
                        <i class="bi bi-people"></i>
                        Detail Pegawai
                    </h6>
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Tanggal Surat</label>
                            <input type="date" class="form-control" name="tanggal_surat" value="<?= $data['tanggal_surat'] ?>" required>
                        </div>
                        <div class="col-md-12">
                            <label class="form-label">Pegawai</label>
                            <select class="form-select select2-multiple" name="nama_pegawai[]" multiple required>
                                <?php while ($row = mysqli_fetch_assoc($result_pegawai)): ?>
                                    <option value="<?= $row['id_pegawai'] ?>" 
                                        <?= in_array($row['id_pegawai'], $selected_pegawai) ? 'selected' : '' ?>>
                                        <?= htmlspecialchars($row['nama_pegawai']) ?> - 
                                        <?= htmlspecialchars($row['nip']) ?> 
                                        (<?= htmlspecialchars($row['jabatan']) ?>)
                                    </option>
                                <?php endwhile; ?>
                            </select>
                        </div>
                    </div>
                </div>

                <!-- Dasar dan Tujuan -->
                <div class="form-section">
                    <h6 class="section-title">
                        <i class="bi bi-journal-text"></i>
                        Dasar dan Tujuan
                    </h6>
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Dasar Surat</label>
                            <textarea class="form-control" name="dasar_surat" rows="2" placeholder="Masukkan dasar surat (opsional)"><?= isset($data['dasar_surat']) ? htmlspecialchars_decode($data['dasar_surat']) : '' ?></textarea>
                            <div class="form-text">Contoh: Surat Kepala Dinas Pendidikan Nomor: xxx/xxx/2024</div>
                        </div>

                        <div id="tujuanUmumContainer" style="display: none;">
                            <div class="col-md-6">
                                <label class="form-label">Tujuan</label>
                                <div class="input-with-search">
                                    <input type="text" class="form-control tujuan-search" name="tujuan" value="<?= !empty($data['tujuan']) ? htmlspecialchars($data['tujuan']) : '' ?>" autocomplete="off">
                                    <div class="search-results"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Tempat Kegiatan</label>
                                <input type="text" class="form-control" name="tempat_kegiatan" value="<?= !empty($data['tempat_kegiatan']) ? htmlspecialchars($data['tempat_kegiatan']) : '' ?>">
                            </div>
                        </div>

                        <div id="tujuanPerPegawaiContainer" style="display: none;">
                            <div class="col-12">
                                <label class="form-label">Tujuan Per Pegawai</label>
                                <div id="tujuanPegawaiList">
                                    <?php
                                    if (!empty($selected_pegawai)) {
                                        foreach ($selected_pegawai as $index => $id_pegawai) {
                                            // Ambil data pegawai
                                            $pegawai_query = "SELECT nama_pegawai FROM pegawai WHERE id_pegawai = ?";
                                            $stmt = mysqli_prepare($conn, $pegawai_query);
                                            mysqli_stmt_bind_param($stmt, "i", $id_pegawai);
                                            mysqli_stmt_execute($stmt);
                                            $pegawai_result = mysqli_stmt_get_result($stmt);
                                            $pegawai_data = mysqli_fetch_assoc($pegawai_result);
                                            
                                            // Ambil tujuan spesifik untuk pegawai ini
                                            $tujuan_query = "SELECT tujuan_pegawai FROM detail_surat_tugas WHERE id_surat = ? AND id_pegawai = ?";
                                            $stmt = mysqli_prepare($conn, $tujuan_query);
                                            mysqli_stmt_bind_param($stmt, "ii", $id_surat, $id_pegawai);
                                            mysqli_stmt_execute($stmt);
                                            $tujuan_result = mysqli_stmt_get_result($stmt);
                                            $tujuan_data = mysqli_fetch_assoc($tujuan_result);
                                            
                                            $tujuan_value = isset($tujuan_data['tujuan_pegawai']) && !empty($tujuan_data['tujuan_pegawai']) ? 
                                                           htmlspecialchars($tujuan_data['tujuan_pegawai']) : '';
                                            ?>
                                            <div class="input-with-search mb-3">
                                                <label class="form-label small"><?= !empty($pegawai_data['nama_pegawai']) ? htmlspecialchars($pegawai_data['nama_pegawai']) : '' ?></label>
                                                <input type="text" 
                                                       class="form-control tujuan-search" 
                                                       name="tujuan_pegawai[<?= $id_pegawai ?>]" 
                                                       value="<?= $tujuan_value ?>"
                                                       autocomplete="off"
                                                       required>
                                                <div class="search-results"></div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Detail Perjalanan -->
                <div class="form-section">
                    <h6 class="section-title">
                        <i class="bi bi-signpost-2"></i>
                        Detail Perjalanan
                    </h6>
                    <div class="row g-3">
                        <div class="col-12">
                            <label class="form-label">Maksud Perjalanan</label>
                            <textarea class="form-control" name="maksud" rows="2" required><?= htmlspecialchars($data['maksud']) ?></textarea>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Asal Berangkat</label>
                            <input type="text" class="form-control" name="asal_berangkat" value="<?= htmlspecialchars($data['asal_berangkat']) ?>" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Tanggal Berangkat</label>
                            <input type="date" class="form-control" name="tanggal_berangkat" value="<?= $data['tanggal_berangkat'] ?>" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Tanggal Kembali</label>
                            <input type="date" class="form-control" name="tanggal_kembali" value="<?= $data['tanggal_kembali'] ?>" required>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Lama Perjalanan (Hari)</label>
                            <input type="number" class="form-control" name="lama_perjalanan" value="<?= $data['lama_perjalanan'] ?>" required>
                        </div>
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="form-section bg-light">
                    <div class="d-flex justify-content-between align-items-center">
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-save me-2"></i>Simpan Perubahan
                        </button>
                        <a href="lihat_surat.php" class="btn btn-secondary">
                            <i class="bi bi-x-circle me-2"></i>Batal
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    $('.select2-multiple').select2({
        theme: 'bootstrap-5',
        width: '100%'
    });

    // Store selected pegawai and their tujuan
    const selectedPegawai = <?= json_encode($selected_pegawai) ?>;
    const tujuanPegawai = <?= json_encode($tujuan_pegawai) ?>;
    
    function updateTujuanFields() {
        const jenisSurat = $('select[name="jenis_surat"]').val();
        const isBimtek = $('#isBimtek').is(':checked');
        const tujuanUmumContainer = $('#tujuanUmumContainer');
        const tujuanPerPegawaiContainer = $('#tujuanPerPegawaiContainer');
        
        if (jenisSurat === 'Dalam Daerah Dalam Provinsi' && !isBimtek) {
            tujuanUmumContainer.hide();
            tujuanPerPegawaiContainer.show();
            $('input[name="tujuan"]').prop('required', false);
            $('input[name="tempat_kegiatan"]').prop('required', false);
            $('input[name^="tujuan_pegawai"]').prop('required', true);
        } else {
            tujuanUmumContainer.show();
            tujuanPerPegawaiContainer.hide();
            $('input[name="tujuan"]').prop('required', true);
            $('input[name="tempat_kegiatan"]').prop('required', true);
            $('input[name^="tujuan_pegawai"]').prop('required', false);
        }
    }

    function updatePegawaiTujuan() {
        const selectedOptions = $('#nama_pegawai').select2('data');
        let html = '';
        
        selectedOptions.forEach((option, index) => {
            const pegawaiId = option.id;
            const tujuanValue = tujuanPegawai[index] || '';
            const namaPegawai = option.text.split('-')[0].trim();
            
            html += `
                <div class="mb-3">
                    <div class="input-with-search">
                        <div class="input-group">
                            <span class="input-group-text">${namaPegawai}</span>
                            <input type="text" 
                                   class="form-control tujuan-search" 
                                   name="tujuan_pegawai[${pegawaiId}]" 
                                   placeholder="Masukkan tujuan untuk ${namaPegawai}"
                                   value="${tujuanValue}"
                                   autocomplete="off"
                                   required>
                        </div>
                        <div class="search-results"></div>
                    </div>
                </div>
            `;
        });
        
        $('#tujuanPegawaiList').html(html);
        initializeSearchEvents();
    }

    function initializeSearchEvents() {
        $(document).on('input', '.tujuan-search', function() {
            const input = $(this);
            const searchResults = input.closest('.input-with-search').find('.search-results');
            const query = input.val();
            const jenisSurat = $('select[name="jenis_surat"]').val();

            if (query.length >= 1) {
                $.ajax({
                    url: 'get_tujuan.php',
                    method: 'POST',
                    data: {
                        query: query,
                        jenis_surat: jenisSurat
                    },
                    success: function(data) {
                        searchResults.html(data).show();
                    }
                });
            } else {
                searchResults.hide();
            }
        });

        $(document).on('click', '.tujuan-item', function() {
            const text = $(this).text();
            const input = $(this).closest('.input-with-search').find('.tujuan-search');
            input.val(text);
            $(this).closest('.search-results').hide();
        });

        // Sembunyikan hasil pencarian saat klik di luar
        $(document).on('click', function(e) {
            if (!$(e.target).closest('.input-with-search').length) {
                $('.search-results').hide();
            }
        });
    }

    // Event listeners
    $('select[name="jenis_surat"], #isBimtek').on('change', function() {
        updateTujuanFields();
    });

    // Form validation before submit
    $('form').on('submit', function(e) {
        const jenisSurat = $('select[name="jenis_surat"]').val();
        const isBimtek = $('#isBimtek').is(':checked');
        
        if (jenisSurat === 'Dalam Daerah Dalam Provinsi' && !isBimtek) {
            if ($('#nama_pegawai').val() === null || $('#nama_pegawai').val().length === 0) {
                alert('Silakan pilih pegawai terlebih dahulu');
                e.preventDefault();
                return false;
            }
            
            const tujuanInputs = $('input[name^="tujuan_pegawai"]');
            let isValid = true;
            tujuanInputs.each(function() {
                if (!$(this).val()) {
                    isValid = false;
                    return false;
                }
            });
            
            if (!isValid) {
                alert('Silakan isi semua tujuan pegawai');
                e.preventDefault();
                return false;
            }
        }
    });

    // Initial setup
    updateTujuanFields();

    // Set initial jenis surat value
    $('select[name="jenis_surat"]').val('<?= $data['jenis_surat'] ?>').trigger('change');

    // Auto calculate lama perjalanan
    $('input[name="tanggal_berangkat"], input[name="tanggal_kembali"]').change(function() {
        var start = new Date($('input[name="tanggal_berangkat"]').val());
        var end = new Date($('input[name="tanggal_kembali"]').val());
        
        if(start && end) {
            var diff = Math.floor((end - start) / (1000 * 60 * 60 * 24)) + 1;
            if(diff >= 0) {
                $('input[name="lama_perjalanan"]').val(diff);
            }
        }
    });

    // Initialize search events for all search inputs
    initializeSearchEvents();
});
</script>

</body>
</html> 