<?php
require_once '../config/config.php';

if(isset($_POST["query"])) {
    $search = mysqli_real_escape_string($conn, $_POST["query"]);
    $jenis_surat = isset($_POST["jenis_surat"]) ? $_POST["jenis_surat"] : '';
    
    // Array untuk menyimpan semua lokasi
    $daerah = array(
        // Instansi Pemerintah Kabupaten Balangan
        "Kantor Bupati Balangan",
        "Sekretariat Daerah Kabupaten Balangan",
        "Sekretariat DPRD Kabupaten Balangan",
        "Inspektorat Kabupaten Balangan",
        "Dinas Pendidikan dan Kebudayaan Kabupaten Balangan",
        "Dinas Kesehatan Kabupaten Balangan",
        "Dinas Pekerjaan Umum dan Penataan Ruang Kabupaten Balangan",
        "Dinas Perumahan dan Kawasan Permukiman Kabupaten Balangan",
        "Dinas Sosial Kabupaten Balangan",
        "Dinas Tenaga Kerja Kabupaten Balangan",
        "Dinas Pemberdayaan Perempuan, Perlindungan Anak dan KB Kabupaten Balangan",
        "Dinas Ketahanan Pangan Kabupaten Balangan",
        "Dinas Lingkungan Hidup Kabupaten Balangan",
        "Dinas Kependudukan dan Pencatatan Sipil Kabupaten Balangan",
        "Dinas Perhubungan Kabupaten Balangan",
        "Dinas Komunikasi dan Informatika Kabupaten Balangan",
        "Dinas Koperasi, Usaha Kecil dan Menengah Kabupaten Balangan",
        "Dinas Penanaman Modal dan PTSP Kabupaten Balangan",
        "Dinas Kepemudaan, Olahraga dan Pariwisata Kabupaten Balangan",
        "Dinas Perpustakaan dan Kearsipan Kabupaten Balangan",
        "Dinas Pertanian Kabupaten Balangan",
        "Dinas Perikanan Kabupaten Balangan",
        "Dinas Perdagangan Kabupaten Balangan",
        "Satuan Polisi Pamong Praja Kabupaten Balangan",
        "Badan Perencanaan Pembangunan Daerah Kabupaten Balangan",
        "Badan Pengelolaan Keuangan dan Aset Daerah Kabupaten Balangan",
        "Badan Kepegawaian dan Pengembangan SDM Kabupaten Balangan",
        "Badan Pendapatan Daerah Kabupaten Balangan",
        "Badan Penanggulangan Bencana Daerah Kabupaten Balangan",
        "Badan Kesatuan Bangsa dan Politik Kabupaten Balangan",

        // Instansi Vertikal/Pusat di Balangan
        "Kejaksaan Negeri Balangan",
        "Pengadilan Negeri Balangan",
        "Pengadilan Agama Balangan",
        "Kantor Kementerian Agama Kabupaten Balangan",
        "Polres Balangan",
        "Kodim 1023 Balangan",
        "Kantor Pertanahan Kabupaten Balangan",
        "KPP Pratama Balangan",
        "BPJS Kesehatan Kabupaten Balangan",
        "BPJS Ketenagakerjaan Kabupaten Balangan",

        // Fasilitas Kesehatan
        "RSUD H. Yulidin Away Kabupaten Balangan",
        "Puskesmas Paringin",
        "Puskesmas Paringin Selatan",
        "Puskesmas Batumandi",
        "Puskesmas Lampihong",
        "Puskesmas Juai",
        "Puskesmas Halong",
        "Puskesmas Awayan",
        "Puskesmas Tebing Tinggi",

        // BUMD dan Instansi Lainnya
        "PDAM Balangan",
        "Bank Kalsel Cabang Paringin",
        "Bank Kalsel Kedai Syariah Paringin",
        "PD Bauntung Batuah Balangan",
        "Kantor Pos Balangan",
        "PLN ULP Balangan",
        "Ar-Raudah Hotel Syariah",
        "Ar-Raudah Resto And Waterpark",


        // Provinsi di Indonesia
        "Aceh", "Sumatera Utara", "Sumatera Barat", "Riau", "Kepulauan Riau",
        "Jambi", "Sumatera Selatan", "Kepulauan Bangka Belitung", "Bengkulu",
        "Lampung", "DKI Jakarta", "Banten", "Jawa Barat", "Jawa Tengah",
        "DI Yogyakarta", "Jawa Timur", "Bali", "Nusa Tenggara Barat",
        "Nusa Tenggara Timur",

        // Kalimantan
        // Kalimantan Barat
        "Kota Pontianak", "Kota Singkawang",
        "Kabupaten Bengkayang", "Kabupaten Kapuas Hulu", "Kabupaten Kayong Utara",
        "Kabupaten Ketapang", "Kabupaten Kubu Raya", "Kabupaten Landak",
        "Kabupaten Melawi", "Kabupaten Mempawah", "Kabupaten Sambas",
        "Kabupaten Sanggau", "Kabupaten Sekadau", "Kabupaten Sintang",

        // Kalimantan Tengah
        "Kota Palangka Raya",
        "Kabupaten Barito Selatan", "Kabupaten Barito Timur", "Kabupaten Barito Utara",
        "Kabupaten Gunung Mas", "Kabupaten Kapuas", "Kabupaten Katingan",
        "Kabupaten Kotawaringin Barat", "Kabupaten Kotawaringin Timur",
        "Kabupaten Lamandau", "Kabupaten Murung Raya", "Kabupaten Pulang Pisau",
        "Kabupaten Sukamara", "Kabupaten Seruyan",

        // Kalimantan Selatan
        "Kota Banjarmasin", "Kota Banjarbaru",
        "Kabupaten Banjar", "Kabupaten Barito Kuala",
        "Kabupaten Hulu Sungai Selatan", "Kabupaten Hulu Sungai Tengah",
        "Kabupaten Hulu Sungai Utara", "Kabupaten Kotabaru",
        "Kabupaten Tabalong", "Kabupaten Tanah Bumbu", "Kabupaten Tanah Laut",
        "Kabupaten Tapin",

        // Kalimantan Timur
        "Kota Samarinda", "Kota Balikpapan", "Kota Bontang",
        "Kabupaten Berau", "Kabupaten Kutai Barat", "Kabupaten Kutai Kartanegara",
        "Kabupaten Kutai Timur", "Kabupaten Mahakam Ulu", "Kabupaten Paser",
        "Kabupaten Penajam Paser Utara",

        // Kalimantan Utara
        "Kota Tarakan",
        "Kabupaten Bulungan", "Kabupaten Malinau", "Kabupaten Nunukan",
        "Kabupaten Tana Tidung",

        // Sulawesi
        "Sulawesi Utara", "Gorontalo", "Sulawesi Tengah", "Sulawesi Barat",
        "Sulawesi Selatan", "Sulawesi Tenggara",

        // Indonesia Timur
        "Maluku", "Maluku Utara", "Papua", "Papua Barat", "Papua Selatan",
        "Papua Tengah", "Papua Pegunungan",

        // Daftar sekolah di Kabupaten Balangan
        "Sdn Ambakiang Hulu",
        "Sdn Badalungga",
        "Sdn Badalungga Hilir",
        "Sdn Baramban",
        "Sdn Baru",
        "Sdn Bayur",
        "Sdn Belanti",
        "Sdn Maningau",
        "Sdn Merah",
        "Sdn Muara Jaya",
        "Sdn Nungka",
        "Sdn Pematang",
        "Sdn Piyait",
        "Sdn Pulantan",
        "Sdn Pulau Kambang",
        "Sdn Putat Basiun",
        "Sdn Sungai Pumpung",
        "Sdn Tundakan",
        "Sdn Tundi",
        "Sdn Uungan",
        "Sdn Wangkili",
        "Sdn Bakung",
        "Sdn Banua Hanyar",
        "Sdn Bungur",
        "Sdn Guha 1",
        "Sdn Guha 2",
        "Sdn Gunung Manau",
        "Sdn Hamparaya",
        "Sdn Karuh",
        "Sdn Kasai",
        "Sdn Lok Batu",
        "Sdn Mampari",
        "Sdn Mantimin 1",
        "Sdn Mantimin 2",
        "Sdn Munjung",
        "Sdn Pelajau",
        "Sdn Riwa",
        "Sdn Sumpung",
        "Sdn Sungai Hanyar",
        "Sdn Sungai Kusi",
        "Sdn Teluk Masjid 1",
        "Sdn Timbun Tulang",

        // Daftar SDK
        "Sdk Ambatunin",
        "Sdk Ampinang",
        "Sdk Andamai",
        "Sdk Hampang",
        "Sdk Kurihai",
        "Sdk Libaru Sungkai",
        "Sdk Mabulan",
        "Sdk Mapat",
        "Sdk Sawang",
        "Sdk Sisirin",
        "Sdk Tampaan",
        "Sdk Tanjungan Jelamu",
        "Sdk Tenggar",

        // Daftar SMPN
        "Smpn 1 Awayan",
        "Smpn 2 Awayan",
        "Smpn 3 Awayan",
        "Smpn 4 Awayan",
        "Smpn 1 Batumandi",
        "Smpn 2 Batumandi",
        "Smpn 3 Batumandi",
        "Smpn 4 Batumandi",
        "Smp Satu Atap Libaru Sungkai",
        "Smpn 1 Halong",
        "Smpn 2 Halong",
        "Smpn 3 Halong",
        "Smpn 4 Halong",
        "Smpn 5 Halong",
        "Smpn 6 Halong",
        "Smpn 1 Juai",
        "Smpn 2 Juai",
        "Smpn 1 Lampihong",
        "Smpn 2 Lampihong",
        "Smpn 1 Paringin",
        "Smpn 2 Paringin",
        "Smpn 3 Paringin",
        "Smpn 4 Paringin",
        "Smpn 5 Paringin",

        // Kecamatan di Kabupaten Balangan
        "Kecamatan Awayan, Balangan",
        "Kecamatan Batu Mandi, Balangan",
        "Kecamatan Halong, Balangan",
        "Kecamatan Juai, Balangan",
        "Kecamatan Lampihong, Balangan",
        "Kecamatan Paringin, Balangan",
        "Kecamatan Paringin Selatan, Balangan",
        "Kecamatan Tebing Tinggi, Balangan",

        // Korwil Kecamatan
        "Korwil Kecamatan Awayan, Balangan",
        "Korwil Kecamatan Batu Mandi, Balangan",
        "Korwil Kecamatan Halong, Balangan",
        "Korwil Kecamatan Juai, Balangan",
        "Korwil Kecamatan Lampihong, Balangan",
        "Korwil Kecamatan Paringin, Balangan",
        "Korwil Kecamatan Paringin Selatan, Balangan",
        "Korwil Kecamatan Tebing Tinggi, Balangan"
    );
    
    $output = '';
    $found = false;
    
    // Cari dari database dulu
    $query = "SELECT DISTINCT tujuan FROM surat_tugas 
             WHERE tujuan LIKE '%".$search."%' 
             UNION 
             SELECT DISTINCT tujuan_pegawai FROM detail_surat_tugas 
             WHERE tujuan_pegawai LIKE '%".$search."%'
             ORDER BY tujuan ASC LIMIT 5";
    
    $result = mysqli_query($conn, $query);
    
    if(mysqli_num_rows($result) > 0) {
        while($row = mysqli_fetch_array($result)) {
            if (!empty($row["tujuan"])) {
                $output .= '<div class="tujuan-item">'.$row["tujuan"].'</div>';
                $found = true;
            }
        }
    }
    
    // Kemudian cari dari array daerah
    if(strlen($search) > 0) {
        foreach($daerah as $d) {
            if(stripos($d, $search) !== false) {
                if ($jenis_surat === 'Dalam Daerah Dalam Provinsi') {
                    // Untuk dalam daerah, tampilkan lokasi di Balangan
                    if (stripos($d, 'sdn') !== false || 
                        stripos($d, 'sdk') !== false || 
                        stripos($d, 'smpn') !== false || 
                        (stripos($d, 'kecamatan') !== false && stripos($d, 'balangan') !== false) ||
                        stripos($d, 'kabupaten balangan') !== false ||
                        stripos($d, 'dinas') !== false ||
                        stripos($d, 'badan') !== false ||
                        stripos($d, 'kantor') !== false ||
                        stripos($d, 'sekretariat') !== false ||
                        stripos($d, 'inspektorat') !== false ||
                        stripos($d, 'satuan') !== false ||
                        stripos($d, 'puskesmas') !== false ||
                        stripos($d, 'rsud') !== false ||
                        stripos($d, 'pengadilan') !== false ||
                        stripos($d, 'kejaksaan') !== false ||
                        stripos($d, 'polres') !== false ||
                        stripos($d, 'kodim') !== false ||
                        stripos($d, 'kpp') !== false ||
                        stripos($d, 'bpjs') !== false ||
                        stripos($d, 'pdam') !== false ||
                        stripos($d, 'bank kalsel') !== false ||
                        stripos($d, 'pd bauntung') !== false ||
                        stripos($d, 'ar-raudah') !== false ||
                        stripos($d, 'pln') !== false) {
                        $output .= '<div class="tujuan-item">'.$d.'</div>';
                        $found = true;
                    }
                } else if ($jenis_surat === 'Luar Daerah Dalam Provinsi') {
                    // Untuk luar daerah dalam provinsi, tampilkan lokasi di Kalimantan Selatan kecuali Balangan
                    if ((stripos($d, 'kabupaten') !== false || stripos($d, 'kota') !== false) && 
                        stripos($d, 'balangan') === false && 
                        (stripos($d, 'banjarmasin') !== false || 
                         stripos($d, 'banjarbaru') !== false ||
                         stripos($d, 'banjar') !== false ||
                         stripos($d, 'barito kuala') !== false ||
                         stripos($d, 'hulu sungai') !== false ||
                         stripos($d, 'kotabaru') !== false ||
                         stripos($d, 'tabalong') !== false ||
                         stripos($d, 'tanah bumbu') !== false ||
                         stripos($d, 'tanah laut') !== false ||
                         stripos($d, 'tapin') !== false)) {
                        $output .= '<div class="tujuan-item">'.$d.'</div>';
                        $found = true;
                    }
                } else if ($jenis_surat === 'Luar Daerah Luar Provinsi') {
                    // Untuk luar provinsi, tampilkan semua lokasi kecuali yang di Kalimantan Selatan
                    if (stripos($d, 'kalimantan selatan') === false && 
                        stripos($d, 'balangan') === false &&
                        stripos($d, 'banjarmasin') === false && 
                        stripos($d, 'banjarbaru') === false &&
                        stripos($d, 'banjar') === false &&
                        stripos($d, 'barito kuala') === false &&
                        stripos($d, 'hulu sungai') === false &&
                        stripos($d, 'kotabaru') === false &&
                        stripos($d, 'tabalong') === false &&
                        stripos($d, 'tanah bumbu') === false &&
                        stripos($d, 'tanah laut') === false &&
                        stripos($d, 'tapin') === false) {
                        $output .= '<div class="tujuan-item">'.$d.'</div>';
                        $found = true;
                    }
                }
            }
        }
    }
    
    // Jika tidak ada hasil
    if(!$found) {
        $output .= '<div>Tidak ada hasil yang ditemukan</div>';
    }
    
    echo $output;
}
?> 