<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
require_once '../config/config.php';

// Fungsi untuk mencatat log
function writeLog($message) {
    $logFile = __DIR__ . '/delete_log.txt';
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($logFile, "[$timestamp] $message\n", FILE_APPEND);
}

if(isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $redirect = isset($_GET['redirect']) ? $_GET['redirect'] : '';
    writeLog("=== Memulai proses penghapusan untuk ID: $id ===");
    
    try {
        mysqli_begin_transaction($conn);

        // Array tabel-tabel yang akan dihapus
        $tables = [
            'detail_rekap_sppd',
            'rincian_biaya_riil_perorangan',
            'rincian_biaya_riil',
            'rincian_biaya_perorangan',
            'rincian_biaya',
            'rincian_bimtek_riil_perorangan',  // Tabel bimtek jika ada
            'rincian_bimtek_riil',             // Tabel bimtek jika ada
            'rincian_bimtek_perorangan',       // Tabel bimtek jika ada
            'rincian_bimtek',                  // Tabel bimtek jika ada
            'laporan',
            'file_uploads',                    // File-file yang mungkin terkait
            'detail_surat_tugas'
        ];

        // Hapus dari semua tabel terkait
        foreach ($tables as $table) {
            // Cek apakah tabel ada
            $table_exists = mysqli_query($conn, "SHOW TABLES LIKE '$table'");
            if (mysqli_num_rows($table_exists) > 0) {
                $query = "DELETE FROM $table WHERE id_surat = ?";
                $stmt = mysqli_prepare($conn, $query);
                if (!$stmt) {
                    throw new Exception("Error preparing $table: " . mysqli_error($conn));
                }
                mysqli_stmt_bind_param($stmt, "i", $id);
                $result = mysqli_stmt_execute($stmt);
                writeLog("Delete $table: " . ($result ? "Success" : "Failed"));
                mysqli_stmt_close($stmt);
            } else {
                writeLog("Table $table does not exist - skipping");
            }
        }

        // Hapus rekap SPPD jika tidak ada surat tugas lain yang terkait
        $query = "DELETE FROM rekap_sppd WHERE NOT EXISTS (
            SELECT 1 FROM detail_rekap_sppd WHERE rekap_sppd.id_rekap = detail_rekap_sppd.id_rekap
        )";
        $result = mysqli_query($conn, $query);
        writeLog("Clean up rekap_sppd: " . ($result ? "Success" : "Failed"));

        // Terakhir hapus surat tugas
        $query = "DELETE FROM surat_tugas WHERE id_surat = ?";
        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            throw new Exception("Error preparing surat_tugas: " . mysqli_error($conn));
        }
        mysqli_stmt_bind_param($stmt, "i", $id);
        $result = mysqli_stmt_execute($stmt);
        writeLog("Delete surat_tugas: " . ($result ? "Success" : "Failed"));
        mysqli_stmt_close($stmt);

        mysqli_commit($conn);
        
        if ($redirect === 'create') {
            $_SESSION['alert'] = [
                'type' => 'success',
                'message' => 'Data surat tugas dan semua data terkait berhasil dihapus! Silahkan buat surat tugas yang baru.'
            ];
            header("Location: ../surat_tugas.php");
        } else {
            $_SESSION['alert'] = [
                'type' => 'success',
                'message' => 'Data surat tugas dan semua data terkait berhasil dihapus!'
            ];
            header("Location: lihat_surat.php");
        }
        writeLog("=== Proses penghapusan berhasil ===");
        exit();

    } catch (Exception $e) {
        mysqli_rollback($conn);
        writeLog("ERROR: " . $e->getMessage());
        writeLog("SQL State: " . mysqli_sqlstate($conn));
        writeLog("Error Code: " . mysqli_errno($conn));
        
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Gagal menghapus data: ' . $e->getMessage()
        ];
        header("Location: lihat_surat.php");
        exit();
    } finally {
        if (isset($stmt)) {
            mysqli_stmt_close($stmt);
        }
        mysqli_close($conn);
    }
} else {
    header("Location: lihat_surat.php");
    exit();
} 