<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Ambil ID surat dari parameter URL
$id_surat = isset($_GET['id']) ? (int)$_GET['id'] : die('ID Surat tidak ditemukan');

// Ambil data surat
$query_surat = "SELECT * FROM surat_tugas WHERE id_surat = ?";
$stmt = mysqli_prepare($conn, $query_surat);
mysqli_stmt_bind_param($stmt, "i", $id_surat);
mysqli_stmt_execute($stmt);
$result_surat = mysqli_stmt_get_result($stmt);
$surat = mysqli_fetch_assoc($result_surat);

if (!$surat) {
    die('Surat tidak ditemukan');
}

// Ambil data pejabat daerah yang aktif
$query_pejabat = "SELECT id_pejabat, nama, nip, jabatan, pangkat, golongan 
                  FROM pejabat_daerah 
                  WHERE status = 'aktif'
                  AND (
                      LOWER(jabatan) LIKE '%bupati%'
                      OR LOWER(jabatan) LIKE '%sekretaris%'
                      OR LOWER(jabatan) LIKE '%kepala dinas%'
                  )
                  ORDER BY 
                    CASE 
                        WHEN LOWER(jabatan) LIKE '%bupati%' THEN 1
                        WHEN LOWER(jabatan) LIKE '%sekretaris%' THEN 2
                        WHEN LOWER(jabatan) LIKE '%kepala dinas%' THEN 3
                        ELSE 4
                    END,
                    nama ASC";
$result_pejabat = mysqli_query($conn, $query_pejabat);
?>

<!DOCTYPE html>
<html lang="id">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfirmasi Cetak Surat Tugas</title>
    <?php include '../includes/header.php'; ?>
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 280px;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all 0.3s ease;
            padding: 2rem;
        }

        body.sidebar-collapsed .container-fluid {
            margin-left: 25px;
            width: calc(100% - 25px);
        }

        @media (max-width: 768px) {
            .container-fluid {
                margin-left: 0;
                width: 100%;
                padding: 1rem;
            }
        }

        .content-header {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 25px;
            box-shadow: 0 4px 6px rgba(14, 165, 233, 0.2);
        }
        .card {
            border: none;
            margin-bottom: 25px;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .card:hover {
            box-shadow: 0 0.5rem 2rem 0 rgba(14, 165, 233, 0.2);
        }
        .card-header {
            background: white;
            border-bottom: 1px solid rgba(0,0,0,0.1);
            padding: 1.25rem;
        }
        .card-title {
            color: #0ea5e9;
            font-weight: 600;
            margin: 0;
        }
        .preview-data {
            background: #f8f9fc;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 25px;
            border: 1px solid #e3e6f0;
        }
        .breadcrumb {
            background: transparent;
            padding: 0;
            margin: 0;
        }
        .breadcrumb-item, .breadcrumb-item a {
            color: rgba(255,255,255,0.9);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s ease;
        }
        .breadcrumb-item a:hover {
            color: white;
        }
        .breadcrumb-item.active {
            color: white;
        }
        .form-select {
            padding: 0.75rem;
            border-radius: 7px;
            border: 1px solid #d1d3e2;
            transition: border-color 0.3s ease;
        }
        .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
        }
        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 7px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border: none;
        }
        .btn-primary:hover {
            background: linear-gradient(135deg, #0b8cc7 0%, #26b8a5 100%);
            transform: translateY(-1px);
        }
        .btn-secondary {
            background: #64748b;
            border: none;
        }
        .btn-secondary:hover {
            background: #4b5563;
            transform: translateY(-1px);
        }
        .detail-item {
            background: white;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 15px;
            border: 1px solid #e3e6f0;
        }
        .detail-item strong {
            color: #0ea5e9;
            font-weight: 600;
        }
        .preview-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 0.15rem 1.75rem 0 rgba(14, 165, 233, 0.1);
        }
        .preview-box h6 {
            color: #0ea5e9;
            font-weight: 600;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #0ea5e9;
        }
        .btn-lihat-surat {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            padding: 0.75rem 1.5rem;
            border-radius: 7px;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn-lihat-surat:hover {
            background: linear-gradient(135deg, #0d9668 0%, #047857 100%);
            color: white;
            transform: translateY(-1px);
        }
        .btn-success {
            background: linear-gradient(135deg, #22c55e 0%, #16a34a 100%);
            border: none;
            color: white;
        }
        .btn-success:hover {
            background: linear-gradient(135deg, #16a34a 0%, #15803d 100%);
            transform: translateY(-1px);
        }
        .step-container {
            padding: 10px;
        }
        .step {
            display: flex;
            align-items: start;
            gap: 15px;
        }
        .step-number {
            width: 30px;
            height: 30px;
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            flex-shrink: 0;
        }
        .step-content {
            flex-grow: 1;
        }
        .step-content h6 {
            color: #0f172a;
            margin: 0;
        }
        .step-content p {
            margin: 0;
            color: #64748b;
        }
        .modal-content {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        .modal-header {
            border-top-left-radius: 15px;
            border-top-right-radius: 15px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .modal-footer {
            border-top: 1px solid #e2e8f0;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>

    <div class="container-fluid">
        <div class="content-header">
            <h2>Konfirmasi Cetak Surat Tugas</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="lihat_surat.php">Surat Tugas</a></li>
                    <li class="breadcrumb-item active" aria-current="page">Konfirmasi Cetak</li>
                </ol>
            </nav>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="card-title">Detail Surat Tugas</h5>
            </div>
            <div class="card-body">
                <div class="row mb-4">
                    <div class="col-md-4">
                        <div class="detail-item">
                            <strong>Jenis Surat</strong>
                            <p class="mb-0 mt-2"><?= htmlspecialchars($surat['jenis_surat']) ?></p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-item">
                            <strong>Nomor SPPD</strong>
                            <p class="mb-0 mt-2"><?= htmlspecialchars($surat['no_sppd']) ?></p>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="detail-item">
                            <strong>Tanggal Surat</strong>
                            <p class="mb-0 mt-2"><?= date('d/m/Y', strtotime($surat['tanggal_surat'])) ?></p>
                        </div>
                    </div>
                </div>

                <form action="cetak_surat.php" method="GET" target="_blank">
                    <input type="hidden" name="id" value="<?= $id_surat ?>">
                    
                    <div class="mb-4">
                        <label class="form-label fw-bold mb-3">Pilih Pejabat Penandatangan</label>
                        <select class="form-select" name="id_pejabat" required>
                            <option value="">-- Pilih Pejabat --</option>
                            <?php while($pejabat = mysqli_fetch_assoc($result_pejabat)): ?>
                            <option value="<?= $pejabat['id_pejabat'] ?>">
                                <?= htmlspecialchars($pejabat['nama']) ?> - 
                                <?= htmlspecialchars($pejabat['jabatan']) ?> 
                                (<?= htmlspecialchars($pejabat['golongan']) ?>)
                            </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="preview-box" id="previewPejabat">
                        <h6 class="mb-3">Preview Data Pejabat</h6>
                        <div id="dataPejabat">
                            <div class="text-muted">Silahkan pilih pejabat terlebih dahulu</div>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-3 mt-4">
                        <a href="lihat_surat.php" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Kembali
                        </a>
                        <a href="lihat_surat.php" class="btn-lihat-surat">
                            <i class="bi bi-eye"></i> Lihat Surat Tugas
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="bi bi-printer"></i> Cetak Surat
                        </button>
                        <button type="submit" class="btn btn-success" formaction="download_word.php" id="downloadWordBtn">
                            <i class="bi bi-file-earmark-word"></i> Download Word
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Modal Petunjuk -->
    <div class="modal fade" id="instructionsModal" tabindex="-1" aria-labelledby="instructionsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-gradient-primary text-white" style="background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);">
                    <h5 class="modal-title" id="instructionsModalLabel">
                        <i class="bi bi-info-circle me-2"></i>
                        Petunjuk Pengaturan Dokumen
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="step-container">
                        <div class="step mb-3">
                            <div class="step-number">1</div>
                            <div class="step-content">
                                <h6 class="mb-1">Buka dokumen di Microsoft Word</h6>
                            </div>
                        </div>
                        <div class="step mb-3">
                            <div class="step-number">2</div>
                            <div class="step-content">
                                <h6 class="mb-1">Notifikasi Pertama</h6>
                                <p class="text-muted small">Jika muncul 'Word found unreadable content in', klik 'Yes'</p>
                            </div>
                        </div>
                        <div class="step mb-3">
                            <div class="step-number">3</div>
                            <div class="step-content">
                                <h6 class="mb-1">Notifikasi Kedua</h6>
                                <p class="text-muted small">Jika muncul notifikasi yang sama, klik 'Yes' lagi</p>
                            </div>
                        </div>
                        <div class="step mb-3">
                            <div class="step-number">4</div>
                            <div class="step-content">
                                <h6 class="mb-1">Pengaturan Layout</h6>
                                <p class="text-muted small">Klik menu 'Layout' → 'Size' → Pilih 'Legal'</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                    <button type="button" class="btn btn-primary" id="confirmDownload">Lanjutkan Download</button>
                </div>
            </div>
        </div>
    </div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const body = document.body;
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        function updateSidebarState() {
            if (localStorage.getItem('sidebarCollapsed') === 'true') {
                body.classList.add('sidebar-collapsed');
            } else {
                body.classList.remove('sidebar-collapsed');
            }
        }
        
        // Initial state
        updateSidebarState();
        
        // Toggle event
        sidebarToggle?.addEventListener('click', function() {
            body.classList.toggle('sidebar-collapsed');
            localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
        });

        // Preview data pejabat
        document.querySelector('select[name="id_pejabat"]').addEventListener('change', function() {
            const id_pejabat = this.value;
            if(id_pejabat) {
                fetch(`get_pejabat.php?id=${id_pejabat}`)
                    .then(response => response.json())
                    .then(data => {
                        document.getElementById('dataPejabat').innerHTML = `
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="detail-item">
                                        <strong>Nama</strong>
                                        <p class="mb-2 mt-2">${data.nama}</p>
                                        <strong>NIP</strong>
                                        <p class="mb-0 mt-2">${data.nip}</p>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="detail-item">
                                        <strong>Jabatan</strong>
                                        <p class="mb-2 mt-2">${data.jabatan}</p>
                                        <strong>Pangkat/Golongan</strong>
                                        <p class="mb-0 mt-2">${data.pangkat} / ${data.golongan}</p>
                                    </div>
                                </div>
                            </div>
                        `;
                    })
                    .catch(error => console.error('Error:', error));
            } else {
                document.getElementById('dataPejabat').innerHTML = '<div class="text-muted">Silahkan pilih pejabat terlebih dahulu</div>';
            }
        });
    });

    // Script untuk modal download
    document.getElementById('downloadWordBtn').addEventListener('click', function(e) {
        e.preventDefault();
        var myModal = new bootstrap.Modal(document.getElementById('instructionsModal'));
        myModal.show();
    });

    document.getElementById('confirmDownload').addEventListener('click', function() {
        document.querySelector('form').action = 'download_word.php';
        document.querySelector('form').submit();
        bootstrap.Modal.getInstance(document.getElementById('instructionsModal')).hide();
    });
    </script>

 
</body>
</html> 