<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Daftar Surat Tugas - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap5.min.css" rel="stylesheet">
</head>
<body>
<?php
require_once $_SERVER['DOCUMENT_ROOT'] . '/sppd/config/config.php';
require_once '../vendor/autoload.php';
include_once ROOT_PATH . '/includes/sidebar.php';



try {
    // Cek koneksi sebelum query
    $conn = check_connection($conn);
    
    // Get user's bidang if admin_sppd or pimpinan
    $user_bidang = '';
    if ($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') {
        $user_id = $_SESSION['user_id'];
        $query_user = "SELECT bidang FROM users WHERE id = ?";
        $stmt = mysqli_prepare($conn, $query_user);
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
    }
    
    // Base query
    $query = "SELECT st.*, 
        GROUP_CONCAT(
            CONCAT_WS('|', 
                p.nama_pegawai, 
                p.nip, 
                p.jabatan,
                COALESCE(dst.tujuan_pegawai, '')
            )
            ORDER BY p.nama_pegawai SEPARATOR ';;'
        ) as pegawai_data
        FROM surat_tugas st 
        LEFT JOIN detail_surat_tugas dst ON st.id_surat = dst.id_surat
        LEFT JOIN pegawai p ON dst.id_pegawai = p.id_pegawai
        LEFT JOIN users u ON u.id = st.created_by";
    
    // Add WHERE clause for admin_sppd and pimpinan
    if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
        $query .= " WHERE u.bidang = ?";
        $query .= " GROUP BY st.id_surat";
        $query .= " ORDER BY st.tanggal_surat DESC, st.id_surat DESC";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $user_bidang);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
    } else {
        $query .= " GROUP BY st.id_surat";
        $query .= " ORDER BY st.tanggal_surat DESC, st.id_surat DESC";
        $result = mysqli_query($conn, $query);
    }
    
    if (!$result) {
        throw new Exception("Error executing query: " . mysqli_error($conn));
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Terjadi kesalahan: " . $e->getMessage() . "</div>";
    error_log($e->getMessage());
}
?>
<div class="container-fluid mt-3">
    <div class="header-wrapper">
        <h1>Daftar Surat Tugas</h1>
        <p>Daftar surat tugas yang telah dibuat</p>
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="surat_tugas.php">Surat Tugas</a></li>
                <li class="breadcrumb-item active">Lihat Surat</li>
            </ol>
        </nav>
        <a href="surat_tugas.php" class="btn-buat-surat">
            <i class="bi bi-plus-lg"></i>
            Buat Surat Baru
        </a>
    </div>

    <!-- Table Card -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover" id="suratTugasTable">
                    <thead>
                        <tr>
                            <th class="text-center" style="width: 50px">No.</th>
                            <th style="width: 25%">Maksud</th>
                            <th style="width: 15%">No. Surat</th>
                            <th style="width: 15%">No. SPPD</th>
                            <th style="width: 20%">Pegawai</th>
                            <th style="width: 15%">Tempat Kegiatan</th>
                            <th style="width: 120px">Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $no = 1;
                        while ($row = mysqli_fetch_assoc($result)): 
                            $pegawai_list = [];
                            $tujuan_list = [];
                            if (!empty($row['pegawai_data'])) {
                                $pegawai_array = explode(';;', $row['pegawai_data']);
                                foreach ($pegawai_array as $index => $pegawai) {
                                    $pegawai_info = explode('|', $pegawai);
                                    if (count($pegawai_info) >= 3) {
                                        $nama = $pegawai_info[0];
                                        $nip = $pegawai_info[1];
                                        $jabatan = $pegawai_info[2];
                                        $tujuan_pegawai = isset($pegawai_info[3]) ? $pegawai_info[3] : '';
                                        
                                        if (!empty($nama)) {
                                            $pegawai_list[] = "<div class='pegawai-item'>" . ($index + 1) . ". " . htmlspecialchars($nama) . "</div>";
                                            if ($row['jenis_surat'] === 'Dalam Daerah Dalam Provinsi' && !empty($tujuan_pegawai)) {
                                                $tujuan_list[] = "<div class='tujuan-item'>" . ($index + 1) . ". " . htmlspecialchars($tujuan_pegawai) . "</div>";
                                            }
                                        }
                                    }
                                }
                            }

                            // Tentukan badge berdasarkan jenis surat
                            $badge_class = '';
                            $badge_text = '';
                            switch($row['jenis_surat']) {
                                case 'Dalam Daerah Dalam Provinsi':
                                    $badge_class = 'bg-success';
                                    $badge_text = '<i class="bi bi-geo-alt"></i> Dalam Daerah';
                                    break;
                                case 'Luar Daerah Dalam Provinsi':
                                    $badge_class = 'bg-warning';
                                    $badge_text = '<i class="bi bi-geo"></i> Luar Daerah';
                                    break;
                                case 'Luar Daerah Luar Provinsi':
                                    $badge_class = 'bg-info';
                                    $badge_text = '<i class="bi bi-globe"></i> Luar Provinsi';
                                    break;
                            }
                        ?>
                        <tr>
                            <td class="text-center"><?= $no++ ?></td>
                            <td>
                                <div class="d-flex flex-column">
                                    <div class="badges mb-2">
                                        <span class="badge <?= $badge_class ?> me-1"><?= $badge_text ?></span>
                                        <?php if ($row['is_bimtek']): ?>
                                            <span class="badge bg-primary" title="Bimtek/Pelatihan">
                                                <i class="bi bi-mortarboard"></i> Bimtek
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="text-wrap"><?= nl2br(htmlspecialchars($row['maksud'])) ?></div>
                                </div>
                            </td>
                            <td><?= htmlspecialchars($row['no_surat']) ?></td>
                            <td><?= htmlspecialchars($row['no_sppd']) ?></td>
                            <td>
                                <?php 
                                if (!empty($pegawai_list)) {
                                    echo '<div class="pegawai-wrapper" data-row-id="' . $row['id_surat'] . '">';
                                    echo '<div class="pegawai-list">';
                                    foreach ($pegawai_list as $index => $pegawai) {
                                        $displayClass = $index >= 2 ? 'pegawai-hidden' : '';
                                        echo "<div class='pegawai-item $displayClass'>" . $pegawai . "</div>";
                                    }
                                    echo '</div>';
                                    if (count($pegawai_list) > 2) {
                                        echo '<button class="btn-toggle-pegawai" onclick="toggleVisibility(this, \'' . $row['id_surat'] . '\')" title="Tampilkan/Sembunyikan">';
                                        echo '<i class="bi bi-eye"></i> Lihat Semua';
                                        echo '<span class="toggle-count">(+' . (count($pegawai_list) - 2) . ' lainnya)</span>';
                                        echo '</button>';
                                    }
                                    echo '</div>';
                                } else {
                                    echo '<span class="text-secondary">-</span>';
                                }
                                ?>
                            </td>
                            <td>
                                <?php 
                                if ($row['jenis_surat'] === 'Dalam Daerah Dalam Provinsi' && !$row['is_bimtek']) {
                                    if (!empty($tujuan_list)) {
                                        echo '<div class="tempat-wrapper" data-row-id="' . $row['id_surat'] . '">';
                                        echo '<div class="tempat-list">';
                                        foreach ($tujuan_list as $index => $tujuan) {
                                            $displayClass = $index >= 2 ? 'tempat-hidden' : '';
                                            echo "<div class='tempat-item $displayClass'>" . strip_tags($tujuan) . "</div>";
                                        }
                                        echo '</div>';
                                        echo '</div>';
                                    } else {
                                        echo '<span class="text-secondary">-</span>';
                                    }
                                } else {
                                    if (!empty($row['tempat_kegiatan'])) {
                                        echo htmlspecialchars($row['tempat_kegiatan']);
                                    } else {
                                        echo '<span class="text-secondary">-</span>';
                                    }
                                }
                                ?>
                            </td>
                            <td>
                                <div class="action-buttons">
                                    <a href="detail.php?id=<?= $row['id_surat'] ?>" 
                                       class="btn-action" 
                                       title="Detail">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    
                                    <a href="konfirmasi_cetak.php?id=<?= $row['id_surat'] ?>" 
                                       class="btn-action" 
                                       title="Cetak">
                                        <i class="bi bi-printer"></i>
                                    </a>

                                    <?php if ($_SESSION['level'] !== 'pimpinan'): ?>
                                        <a href="edit.php?id=<?= $row['id_surat'] ?>" 
                                           class="btn-action"
                                           title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        
                                        <button type="button" 
                                                onclick="hapusSurat(<?= $row['id_surat'] ?>)" 
                                                class="btn-action text-danger"
                                                title="Hapus">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                        <?php if (mysqli_num_rows($result) == 0): ?>
                        <tr>
                            <td colspan="7" class="text-center py-4 text-muted">
                                <i class="bi bi-inbox fs-2 d-block mb-2"></i>
                                Tidak ada data surat tugas tersedia
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php include_once '../includes/footer.php'; ?>
<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap5.min.js"></script>
<!-- Add SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
$(document).ready(function() {
    $('#suratTugasTable').DataTable({
        "responsive": true,
        "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
        }
    });
});

function hapusSurat(id) {
    Swal.fire({
        title: 'Konfirmasi Hapus',
        text: 'Apakah Anda yakin ingin menghapus surat tugas ini, mengingat tindakan tersebut akan menghapus semua data yang berkaitan dengan surat tugas?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#0ea5e9',
        cancelButtonColor: '#dc3545',
        confirmButtonText: 'Ya, Hapus!',
        cancelButtonText: 'Batal',
        background: 'rgba(255, 255, 255, 0.9)',
        backdrop: `rgba(14, 165, 233, 0.1)`,
        customClass: {
            popup: 'custom-popup-class',
            title: 'custom-title-class',
            confirmButton: 'custom-confirm-button-class',
            cancelButton: 'custom-cancel-button-class'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            Swal.fire({
                title: 'Menghapus...',
                text: 'Mohon tunggu sebentar',
                allowOutsideClick: false,
                allowEscapeKey: false,
                showConfirmButton: false,
                willOpen: () => {
                    Swal.showLoading();
                }
            });
            window.location.href = 'hapus.php?id=' + id;
        }
    });
}

function toggleVisibility(button, rowId) {
    const pegawaiWrapper = button.closest('.pegawai-wrapper');
    const tempatWrapper = document.querySelector(`.tempat-wrapper[data-row-id="${rowId}"]`);
    const icon = button.querySelector('i');
    
    // Toggle pegawai list
    pegawaiWrapper.classList.toggle('pegawai-expanded');
    
    // Toggle tempat kegiatan list if exists
    if (tempatWrapper) {
        tempatWrapper.classList.toggle('tempat-expanded');
    }
    
    // Toggle icon
    if (pegawaiWrapper.classList.contains('pegawai-expanded')) {
        icon.classList.remove('bi-eye');
        icon.classList.add('bi-eye-slash');
    } else {
        icon.classList.remove('bi-eye-slash');
        icon.classList.add('bi-eye');
    }
}

function handleEdit(id) {
    window.location.href = 'edit.php?id=' + id;
}

document.addEventListener('DOMContentLoaded', function() {
    const body = document.body;
    const sidebarToggle = document.querySelector('.sidebar-toggle');
    
    function updateSidebarState() {
        if (localStorage.getItem('sidebarCollapsed') === 'true') {
            body.classList.add('sidebar-collapsed');
        } else {
            body.classList.remove('sidebar-collapsed');
        }
    }
    
    // Initial state
    updateSidebarState();
    
    // Toggle event
    sidebarToggle?.addEventListener('click', function() {
        body.classList.toggle('sidebar-collapsed');
        localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
    });
});
</script>

<style>
/* Background dan Container */
:root {
    --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    --bg-gradient: linear-gradient(135deg,rgb(231, 255, 255) 0%,rgb(236, 255, 246) 100%);
    --sidebar-width: 280px;
}

body {
    background: var(--bg-gradient) !important;
    min-height: 100vh;
    margin: 0;
    padding: 0;
}

.container-fluid {
    background: transparent !important;
    position: relative;
    margin-left: var(--sidebar-width);
    width: calc(100% - var(--sidebar-width));
    min-height: 100vh;
    transition: all 0.3s ease;
    padding: 2rem;
}

body.sidebar-collapsed .container-fluid {
    margin-left: 25px;
    width: calc(100% - 25px);
}

@media (max-width: 768px) {
    .container-fluid {
        margin-left: 0;
        width: 100%;
        padding: 1rem;
    }
}

/* Header Section */
.header-wrapper {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    padding: 1.2rem;
    border-radius: 12px;
    margin-bottom: 1rem;
    position: relative;
}

.header-wrapper h1 {
    font-size: 1.5rem;
    font-weight: 600;
    color: #ffffff;
    margin-bottom: 0.2rem;
}

.header-wrapper p {
    font-size: 0.9rem;
    color: rgba(255, 255, 255, 0.8);
    margin-bottom: 0.5rem;
}

.breadcrumb {
    background: rgba(255, 255, 255, 0.1);
    padding: 0.5rem 0.8rem;
    border-radius: 6px;
    margin: 0;
    font-size: 0.85rem;
}

.breadcrumb-item a {
    color: rgba(255, 255, 255, 0.8);
    text-decoration: none;
}

.breadcrumb-item.active {
    color: white;
}

/* Button Styling */
.btn-buat-surat {
    position: absolute;
    right: 1.2rem;
    top: 50%;
    transform: translateY(-50%);
    background: white;
    color: #0ea5e9;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-size: 0.9rem;
    font-weight: 500;
    text-decoration: none;
    transition: all 0.2s ease;
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
}

.btn-buat-surat:hover {
    background: rgba(255, 255, 255, 0.9);
    transform: translateY(-50%) translateX(-2px);
}

.btn-buat-surat i {
    font-size: 0.85rem;
}

/* Table Header */
.table-header {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    color: white;
    font-size: 0.9rem;
    font-weight: 500;
}

.table-header th {
    padding: 0.7rem 1rem;
    border: none;
}

/* Responsive */
@media (max-width: 768px) {
    .header-wrapper {
        padding: 1rem;
    }

    .header-wrapper h1 {
        font-size: 1.3rem;
        margin-right: 100px;
    }

    .header-wrapper p {
        font-size: 0.85rem;
        margin-right: 100px;
    }

    .btn-buat-surat {
        padding: 0.4rem 0.8rem;
        font-size: 0.85rem;
    }
}

/* Table Card */
.card {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border: none;
    border-radius: 15px;
    box-shadow: 0 8px 32px 0 rgba(14, 165, 233, 0.15);
}

/* Table Styling */
.table {
    margin: 0;
    border-collapse: separate;
    border-spacing: 0;
}

.table thead th {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    color: white;
    font-weight: 600;
    padding: 15px !important;
    font-size: 0.9rem;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    border: none;
}

.table thead th:first-child {
    border-top-left-radius: 10px;
}

.table thead th:last-child {
    border-top-right-radius: 10px;
}

.table tbody td {
    padding: 15px !important;
    vertical-align: middle;
    border-bottom: 1px solid rgba(0, 0, 0, 0.05);
    font-size: 0.9rem;
    color: #2c3e50;
}

/* Row Hover Effect */
.table-hover tbody tr:hover {
    background-color: rgba(14, 165, 233, 0.05);
    transition: all 0.3s ease;
}

/* Action Buttons */
.btn-soft-info, 
.btn-soft-warning, 
.btn-soft-danger,
.btn-primary {
    padding: 8px 16px;
    border-radius: 8px;
    font-size: 0.85rem;
    font-weight: 500;
    transition: all 0.3s ease;
}

.btn-soft-info {
    background: rgba(14, 165, 233, 0.1);
    color: #0ea5e9;
}

.btn-soft-warning {
    background: rgba(255, 193, 7, 0.1);
    color: #ffc107;
}

.btn-soft-danger {
    background: rgba(220, 53, 69, 0.1);
    color: #dc3545;
}

.btn-primary {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    border: none;
}

/* Button Hover Effects */
.btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
}

/* Eye button styling */
.btn-eye {
    width: 32px;
    height: 32px;
    border-radius: 50%;
    background: rgba(14, 165, 233, 0.1);
    color: #0ea5e9;
    border: none;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

.btn-eye:hover,
.btn-eye.active {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    color: white;
}

.btn-eye i {
    font-size: 1rem;
    transition: transform 0.3s ease;
}

.btn-eye.active i {
    transform: scale(1.1);
}

/* Action container styling */
.action-container {
    padding: 12px;
    background: rgba(255, 255, 255, 0.95);
    border-radius: 10px;
    display: flex;
    gap: 8px;
    margin: 8px 16px;
    border: 1px solid rgba(14, 165, 233, 0.1);
    box-shadow: 0 2px 8px rgba(14, 165, 233, 0.05);
}

/* Button base styling */
.action-container .btn {
    height: 36px;
    display: inline-flex;
    align-items: center;
    gap: 6px;
    padding: 0 12px;
    font-size: 0.875rem;
    font-weight: 500;
    border-radius: 6px;
    transition: all 0.3s ease;
}

.action-container .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
}

/* Pegawai List */
.pegawai-wrapper {
    position: relative;
    padding-right: 30px;
}

.pegawai-list {
    max-height: 100%;
    overflow: hidden;
    transition: max-height 0.3s ease;
}

.pegawai-item {
    padding: 4px 0;
    color: #2c3e50;
    font-weight: 500;
}

.pegawai-hidden {
    display: none;
}

.btn-toggle-pegawai {
    display: inline-flex;
    align-items: center;
    gap: 4px;
    background: none;
    border: none;
    color: #0ea5e9;
    padding: 4px 8px;
    font-size: 0.85rem;
    cursor: pointer;
    margin-top: 4px;
    border-radius: 4px;
}

.btn-toggle-pegawai:hover {
    background-color: rgba(14, 165, 233, 0.1);
}

.btn-toggle-pegawai i {
    font-size: 0.9rem;
}

.toggle-count {
    color: #6c757d;
    font-size: 0.8rem;
    margin-left: 4px;
}

.pegawai-expanded .pegawai-hidden {
    display: block;
}

.pegawai-expanded .toggle-count {
    display: none;
}

/* DataTables Customization */
.dataTables_wrapper {
    padding: 1rem;
}

.dataTables_wrapper .dataTables_length,
.dataTables_wrapper .dataTables_filter {
    margin-bottom: 1rem;
}

.dataTables_wrapper .dataTables_length select {
    min-width: 80px;
    padding: 6px 30px 6px 12px;
    border: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    background: #fff url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e") no-repeat right 0.75rem center/12px 12px;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;
}

.dataTables_wrapper .dataTables_filter input {
    min-width: 250px;
    padding: 6px 12px;
    border: 1px solid rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    background: #fff;
}

.dataTables_wrapper .dataTables_info {
    padding: 1rem 0;
    color: #6c757d;
}

.dataTables_wrapper .dataTables_paginate {
    padding: 1rem 0;
}

.dataTables_wrapper .dataTables_paginate .paginate_button {
    padding: 6px 12px;
    margin: 0 2px;
    border-radius: 6px;
    border: 1px solid transparent;
}

.dataTables_wrapper .dataTables_paginate .paginate_button:hover {
    background: rgba(14, 165, 233, 0.1);
    border-color: transparent;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.current,
.dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    border-color: transparent;
    color: white !important;
}

.dataTables_wrapper .dataTables_paginate .paginate_button.disabled,
.dataTables_wrapper .dataTables_paginate .paginate_button.disabled:hover {
    color: #6c757d !important;
    background: transparent;
    border-color: transparent;
}

/* Table Responsive Fixes */
.table-responsive {
    overflow-x: auto;
    -webkit-overflow-scrolling: touch;
    margin: 0 -1rem;
    padding: 0 1rem;
}

@media (max-width: 768px) {
    .dataTables_wrapper .dataTables_length,
    .dataTables_wrapper .dataTables_filter {
        text-align: left;
        margin-bottom: 0.5rem;
    }
    
    .dataTables_wrapper .dataTables_filter input {
        min-width: 200px;
    }
    
    .dataTables_wrapper .dataTables_info,
    .dataTables_wrapper .dataTables_paginate {
        text-align: center;
    }
}

/* Fix for entries dropdown */
.dataTables_length select {
    max-width: none !important;
    width: auto !important;
}

/* Table cell content wrapping */
.table td {
    white-space: normal;
    word-wrap: break-word;
    max-width: 0;
}

.table th {
    white-space: nowrap;
}

/* Empty State */
.text-muted {
    color: #6c757d !important;
}

.bi-inbox {
    font-size: 2.5rem;
    color: #6c757d;
}

/* Active Row State */
.main-row.active {
    background-color: rgba(14, 165, 233, 0.08);
}

/* Button Styles */
.btn-primary:hover,
.btn-soft-info:hover,
.btn-soft-warning:hover,
.btn-soft-danger:hover {
    background: linear-gradient(135deg, #0891ce 0%, #20b4a3 100%);
    color: white;
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
}

/* Soft Button States */
.btn-soft-info, 
.btn-soft-warning, 
.btn-soft-danger {
    background: rgba(14, 165, 233, 0.1);
    color: #0ea5e9;
    border: 1px solid rgba(14, 165, 233, 0.2);
}

.btn-soft-info:hover, 
.btn-soft-warning:hover, 
.btn-soft-danger:hover {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    color: white;
    border: 1px solid transparent;
}

/* Focus States */
.btn:focus,
.form-control:focus {
    box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
}

/* Tempat Kegiatan Styling */
.tempat-wrapper {
    position: relative;
}

.tempat-list {
    max-height: 100%;
    overflow: hidden;
    transition: max-height 0.3s ease;
}

.tempat-item {
    padding: 4px 0;
    color: #2c3e50;
    font-weight: 500;
}

.tempat-hidden {
    display: none;
}

/* Expanded state for tempat kegiatan */
.tempat-expanded .tempat-hidden {
    display: block;
}

/* Update table column widths */
.table th:nth-child(1),
.table td:nth-child(1) {
    width: 80px;
}

.table th:nth-child(2),
.table td:nth-child(2) {
    width: 15%;
}

.table th:nth-child(3),
.table td:nth-child(3) {
    width: 15%;
}

.table th:nth-child(4),
.table td:nth-child(4) {
    width: 15%;
}

.table th:nth-child(5),
.table td:nth-child(5) {
    width: 20%;
}

.table th:nth-child(6),
.table td:nth-child(6) {
    width: 25%;
}

.table th:nth-child(7),
.table td:nth-child(7) {
    width: 10%;
}

/* Ensure text wrapping for maksud column */
.text-wrap {
    white-space: normal;
    word-wrap: break-word;
    max-width: 100%;
    line-height: 1.5;
}

/* Table layout */
.table {
    table-layout: fixed;
    width: 100%;
}

.table td {
    vertical-align: top;
}

/* SweetAlert2 Custom Styles */
.custom-popup-class {
    border-radius: 15px;
    padding: 20px;
    box-shadow: 0 8px 32px 0 rgba(14, 165, 233, 0.2);
}

.custom-title-class {
    color: #2c3e50;
    font-size: 1.5rem;
    font-weight: 600;
    margin-bottom: 0.5rem;
}

.custom-confirm-button-class {
    background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%) !important;
    border: none !important;
    padding: 12px 24px !important;
    font-weight: 500 !important;
    border-radius: 8px !important;
    transition: all 0.3s ease !important;
}

.custom-confirm-button-class:hover {
    transform: translateY(-2px) !important;
    box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2) !important;
}

.custom-cancel-button-class {
    background: #fff !important;
    color: #dc3545 !important;
    border: 1px solid #dc3545 !important;
    padding: 12px 24px !important;
    font-weight: 500 !important;
    border-radius: 8px !important;
    transition: all 0.3s ease !important;
}

.custom-cancel-button-class:hover {
    background: rgba(220, 53, 69, 0.1) !important;
    transform: translateY(-2px) !important;
}

/* SweetAlert2 Loading Animation */
.swal2-shown .swal2-loading {
    border-color: #0ea5e9 !important;
}

.swal2-popup.swal2-toast {
    padding: 15px !important;
    background: rgba(255, 255, 255, 0.95) !important;
    backdrop-filter: blur(10px) !important;
}

/* Action Buttons Styling */
.action-buttons {
    display: flex;
    gap: 0.5rem;
    justify-content: center;
}

.btn-action {
    width: 32px;
    height: 32px;
    padding: 0;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border-radius: 8px;
    border: none;
    background: transparent;
    color: #64748b;
    transition: all 0.3s ease;
    cursor: pointer;
    position: relative;
}

.btn-action i {
    font-size: 1rem;
    transition: all 0.3s ease;
}

.btn-action:hover {
    background: rgba(14, 165, 233, 0.1);
    color: #0ea5e9;
    transform: translateY(-2px);
}

.btn-action.text-danger:hover {
    background: rgba(239, 68, 68, 0.1);
    color: #ef4444;
}

/* Remove old eye toggle styles */
.btn-eye,
.action-row,
.action-container {
    display: none;
}

/* Update table header for actions */
.table thead th:last-child {
    text-align: center;
}

/* Tooltip styling */
.btn-action::after {
    content: attr(title);
    position: absolute;
    bottom: 100%;
    left: 50%;
    transform: translateX(-50%) translateY(8px);
    background: #1e293b;
    color: white;
    padding: 0.5rem 0.75rem;
    border-radius: 6px;
    font-size: 0.75rem;
    white-space: nowrap;
    opacity: 0;
    visibility: hidden;
    transition: all 0.3s ease;
    z-index: 10;
}

.btn-action:hover::after {
    opacity: 1;
    visibility: visible;
    transform: translateX(-50%) translateY(0);
}

/* Custom hover effects for specific actions */
.btn-action[title="Detail"]:hover i { color: #0ea5e9; }
.btn-action[title="Cetak"]:hover i { color: #0ea5e9; }
.btn-action[title="Edit"]:hover i { color: #f59e0b; }
.btn-action[title="Hapus"]:hover i { color: #ef4444; }

/* DataTables Length Select Fix */
.dataTables_length {
    position: relative;
    z-index: 1;
}

.dataTables_length select {
    min-width: 80px !important;
    width: auto !important;
    height: auto !important;
    padding: 6px 30px 6px 12px !important;
    font-size: 0.875rem;
    line-height: 1.5;
    background-color: #fff !important;
    border: 1px solid rgba(0, 0, 0, 0.1) !important;
    border-radius: 8px !important;
    -webkit-appearance: none !important;
    -moz-appearance: none !important;
    appearance: none !important;
    background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' viewBox='0 0 16 16'%3e%3cpath fill='none' stroke='%23343a40' stroke-linecap='round' stroke-linejoin='round' stroke-width='2' d='M2 5l6 6 6-6'/%3e%3c/svg%3e") !important;
    background-repeat: no-repeat !important;
    background-position: right 0.75rem center !important;
    background-size: 12px !important;
    cursor: pointer;
}

.dataTables_length select:focus {
    outline: none;
    border-color: #0ea5e9 !important;
    box-shadow: 0 0 0 2px rgba(14, 165, 233, 0.25) !important;
}

.dataTables_length select option {
    padding: 8px;
    font-size: 0.875rem;
}

/* Fix for dropdown position */
.dataTables_wrapper .dataTables_length {
    float: left;
    margin-right: 20px;
    min-height: 40px;
}

/* Ensure dropdown is above table */
.dataTables_wrapper {
    position: relative;
}

.dataTables_length {
    position: relative;
    z-index: 2;
}

.table-responsive {
    position: relative;
    z-index: 1;
}

@media (max-width: 768px) {
    .dataTables_length select {
        width: 100px !important;
    }
    
    .dataTables_wrapper .dataTables_length {
        float: none;
        margin-right: 0;
        margin-bottom: 1rem;
    }
}

/* Badge Styling */
.badges {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.badge {
    display: inline-flex;
    align-items: center;
    gap: 0.25rem;
    padding: 0.35rem 0.65rem;
    font-size: 0.75rem;
    font-weight: 500;
    border-radius: 6px;
}

.badge i {
    font-size: 0.8rem;
}

.badge.bg-success {
    background: rgba(34, 197, 94, 0.1) !important;
    color: #22c55e;
}

.badge.bg-warning {
    background: rgba(245, 158, 11, 0.1) !important;
    color: #f59e0b;
}

.badge.bg-info {
    background: rgba(14, 165, 233, 0.1) !important;
    color: #0ea5e9;
}

.badge.bg-primary {
    background: rgba(99, 102, 241, 0.1) !important;
    color: #6366f1;
}

/* Text wrap for maksud column */
.text-wrap {
    font-size: 0.875rem;
    line-height: 1.5;
    color: #374151;
}
</style>

</body>
</html>