<?php
session_start();
require_once '../config/config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Validasi input
        if (empty($_POST['id_surat'])) throw new Exception("ID Surat tidak valid");
        if (empty($_POST['no_surat'])) throw new Exception("Nomor surat wajib diisi");
        if (empty($_POST['jenis_surat'])) throw new Exception("Jenis surat wajib diisi");
        if (empty($_POST['no_sppd'])) throw new Exception("Nomor SPPD wajib diisi");
        if (empty($_POST['tanggal_surat'])) throw new Exception("Tanggal surat wajib diisi");
        if (empty($_POST['nama_pegawai']) || !is_array($_POST['nama_pegawai'])) throw new Exception("Minimal satu pegawai harus dipilih");
        if (empty($_POST['asal_berangkat'])) throw new Exception("Asal berangkat wajib diisi");
        if (empty($_POST['maksud'])) throw new Exception("Maksud wajib diisi");
        if (empty($_POST['tanggal_berangkat'])) throw new Exception("Tanggal berangkat wajib diisi");
        if (empty($_POST['tanggal_kembali'])) throw new Exception("Tanggal kembali wajib diisi");
        if (empty($_POST['lama_perjalanan'])) throw new Exception("Lama perjalanan wajib diisi");

        // Validasi berdasarkan jenis surat
        if ($_POST['jenis_surat'] !== 'Dalam Daerah Dalam Provinsi' || isset($_POST['is_bimtek'])) {
            if (empty($_POST['tujuan'])) throw new Exception("Tujuan wajib diisi");
            if (empty($_POST['tempat_kegiatan'])) throw new Exception("Tempat kegiatan wajib diisi");
        } else {
            if (empty($_POST['tujuan_pegawai']) || !is_array($_POST['tujuan_pegawai'])) {
                throw new Exception("Tujuan pegawai wajib diisi");
            }
        }

        mysqli_begin_transaction($conn);

        // 1. Update tabel surat_tugas
        $query = "UPDATE surat_tugas SET 
            jenis_surat = ?,
            no_surat = ?,
            no_sppd = ?,
            tanggal_surat = ?,
            dasar_surat = ?,
            asal_berangkat = ?,
            tujuan = ?,
            tempat_kegiatan = ?,
            maksud = ?,
            tanggal_berangkat = ?,
            tanggal_kembali = ?,
            lama_perjalanan = ?,
            is_bimtek = ?
            WHERE id_surat = ?";

        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            throw new Exception("Error preparing statement: " . mysqli_error($conn));
        }

        $is_bimtek = isset($_POST['is_bimtek']) ? 1 : 0;
        mysqli_stmt_bind_param($stmt, "sssssssssssiii",
            $_POST['jenis_surat'],
            $_POST['no_surat'],
            $_POST['no_sppd'],
            $_POST['tanggal_surat'],
            $_POST['dasar_surat'],
            $_POST['asal_berangkat'],
            $_POST['tujuan'],
            $_POST['tempat_kegiatan'],
            $_POST['maksud'],
            $_POST['tanggal_berangkat'],
            $_POST['tanggal_kembali'],
            $_POST['lama_perjalanan'],
            $is_bimtek,
            $_POST['id_surat']
        );

        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error executing update: " . mysqli_stmt_error($stmt));
        }

        // 2. Hapus data pegawai lama
        $query_delete = "DELETE FROM detail_surat_tugas WHERE id_surat = ?";
        $stmt_delete = mysqli_prepare($conn, $query_delete);
        if (!$stmt_delete) {
            throw new Exception("Error preparing delete statement: " . mysqli_error($conn));
        }

        mysqli_stmt_bind_param($stmt_delete, 'i', $_POST['id_surat']);
        if (!mysqli_stmt_execute($stmt_delete)) {
            throw new Exception("Error deleting old data: " . mysqli_stmt_error($stmt_delete));
        }

        // 3. Insert data pegawai baru
        if ($_POST['jenis_surat'] === 'Dalam Daerah Dalam Provinsi' && !$is_bimtek) {
            $query_detail = "INSERT INTO detail_surat_tugas (id_surat, id_pegawai, tujuan_pegawai) VALUES (?, ?, ?)";
            $stmt_detail = mysqli_prepare($conn, $query_detail);
            if (!$stmt_detail) {
                throw new Exception("Error preparing detail statement: " . mysqli_error($conn));
            }

            foreach ($_POST['nama_pegawai'] as $id_pegawai) {
                $tujuan = isset($_POST['tujuan_pegawai'][$id_pegawai]) ? $_POST['tujuan_pegawai'][$id_pegawai] : '';
                mysqli_stmt_bind_param($stmt_detail, 'iis', $_POST['id_surat'], $id_pegawai, $tujuan);
                if (!mysqli_stmt_execute($stmt_detail)) {
                    throw new Exception("Error inserting detail: " . mysqli_stmt_error($stmt_detail));
                }
            }
        } else {
            $query_detail = "INSERT INTO detail_surat_tugas (id_surat, id_pegawai) VALUES (?, ?)";
            $stmt_detail = mysqli_prepare($conn, $query_detail);
            if (!$stmt_detail) {
                throw new Exception("Error preparing detail statement: " . mysqli_error($conn));
            }

            foreach ($_POST['nama_pegawai'] as $id_pegawai) {
                mysqli_stmt_bind_param($stmt_detail, 'ii', $_POST['id_surat'], $id_pegawai);
                if (!mysqli_stmt_execute($stmt_detail)) {
                    throw new Exception("Error inserting detail: " . mysqli_stmt_error($stmt_detail));
                }
            }
        }

        mysqli_commit($conn);

        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Surat tugas berhasil diperbarui'
        ];

        header("Location: lihat_surat.php");
        exit();

    } catch (Exception $e) {
        mysqli_rollback($conn);
        
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => 'Error: ' . $e->getMessage()
        ];
        
        header("Location: edit.php?id=" . $_POST['id_surat']);
        exit();
    }
} else {
    header("Location: lihat_surat.php");
    exit();
}
?> 