<?php
session_start();
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../login.php");
    exit();
}

$user_id = $_SESSION['user_id'];

if (isset($_POST['submit'])) {
    try {
        mysqli_begin_transaction($conn);
        
        $jenis_surat = $_POST['jenis_surat'];
        $no_surat = $_POST['no_surat'];
        $no_sppd = $_POST['no_sppd'];
        $tanggal_surat = $_POST['tanggal_surat'];
        $dasar_surat = $_POST['dasar_surat'];
        $asal_berangkat = $_POST['asal_berangkat'];
        $maksud = $_POST['maksud'];
        $tanggal_berangkat = $_POST['tanggal_berangkat'];
        $tanggal_kembali = $_POST['tanggal_kembali'];
        $lama_perjalanan = $_POST['lama_perjalanan'];
        $created_by = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
        $is_bimtek = isset($_POST['is_bimtek']) ? 1 : 0;

        // Jika Dalam Daerah Dalam Provinsi dan bukan bimtek, tujuan akan disimpan per pegawai
        if ($jenis_surat === 'Dalam Daerah Dalam Provinsi' && !$is_bimtek) {
            // Insert surat tugas tanpa tujuan umum
            $query = "INSERT INTO surat_tugas (
                jenis_surat, no_surat, no_sppd, tanggal_surat, dasar_surat,
                asal_berangkat, maksud, tanggal_berangkat, tanggal_kembali,
                lama_perjalanan, created_by, is_bimtek
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "sssssssssiis",
                $jenis_surat, $no_surat, $no_sppd, $tanggal_surat, $dasar_surat,
                $asal_berangkat, $maksud, $tanggal_berangkat, $tanggal_kembali,
                $lama_perjalanan, $created_by, $is_bimtek
            );
        } else {
            // Insert surat tugas dengan tujuan umum dan tempat kegiatan
            $tujuan = $_POST['tujuan'];
            $tempat_kegiatan = $_POST['tempat_kegiatan'];
            $query = "INSERT INTO surat_tugas (
                jenis_surat, no_surat, no_sppd, tanggal_surat, dasar_surat,
                asal_berangkat, tujuan, tempat_kegiatan, maksud, tanggal_berangkat, tanggal_kembali,
                lama_perjalanan, created_by, is_bimtek
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "sssssssssssiis",
                $jenis_surat, $no_surat, $no_sppd, $tanggal_surat, $dasar_surat,
                $asal_berangkat, $tujuan, $tempat_kegiatan, $maksud, $tanggal_berangkat, $tanggal_kembali,
                $lama_perjalanan, $created_by, $is_bimtek
            );
        }
        
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error executing statement: " . mysqli_stmt_error($stmt));
        }
        
        $id_surat = mysqli_insert_id($conn);
        
        // Insert detail surat tugas untuk setiap pegawai
        if (isset($_POST['nama_pegawai']) && is_array($_POST['nama_pegawai'])) {
            $query_detail = "INSERT INTO detail_surat_tugas (id_surat, id_pegawai, tujuan_pegawai) VALUES (?, ?, ?)";
            $stmt_detail = mysqli_prepare($conn, $query_detail);
            
            foreach ($_POST['nama_pegawai'] as $id_pegawai) {
                $tujuan_pegawai = ($jenis_surat === 'Dalam Daerah Dalam Provinsi' && isset($_POST['tujuan_pegawai'][$id_pegawai])) 
                    ? $_POST['tujuan_pegawai'][$id_pegawai] 
                    : null;
                
                mysqli_stmt_bind_param($stmt_detail, "iis", $id_surat, $id_pegawai, $tujuan_pegawai);
                if (!mysqli_stmt_execute($stmt_detail)) {
                    throw new Exception("Error saat menyimpan detail pegawai: " . mysqli_error($conn));
                }
            }
        } else {
            throw new Exception("Pilih minimal satu pegawai");
        }
        
        mysqli_commit($conn);
        
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Surat tugas berhasil disimpan'
        ];
        
        header("Location: lihat_surat.php");
        exit;
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        error_log("Error in proses_tambah.php: " . $e->getMessage());
        
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => $e->getMessage()
        ];
        
        $_SESSION['form_data'] = $_POST;
        header("Location: surat_tugas.php");
        exit;
    }
} else {
    header("Location: surat_tugas.php");
    exit();
}
?> 