<?php
require_once '../config/config.php';


// Query untuk data pegawai
$query_pegawai = "SELECT id_pegawai, nama_pegawai, nip, jabatan FROM pegawai ORDER BY nama_pegawai";
$result_pegawai = mysqli_query($conn, $query_pegawai);

// Ambil data form dari session jika ada
$form_data = isset($_SESSION['form_data']) ? $_SESSION['form_data'] : [];
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Surat Tugas - SPPD</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- CSS Libraries -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/select2-bootstrap-5-theme@1.3.0/dist/select2-bootstrap-5-theme.min.css" rel="stylesheet" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        /* Root variables */
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
        }

        body {
            background: var(--bg-gradient);
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            overflow-x: hidden;
        }

        /* Main Content Layout */
        .content-wrapper {
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            padding: var(--content-padding);
            transition: all 0.3s ease;
            background: var(--bg-gradient);
        }

        .content-wrapper.expanded {
            margin-left: var(--sidebar-mini-width);
            width: calc(100% - var(--sidebar-mini-width));
        }

        /* Sidebar adjustments */
        .sidebar-wrapper {
            width: var(--sidebar-width) !important;
            min-width: var(--sidebar-width);
            max-width: var(--sidebar-width);
            transition: all 0.3s ease;
        }

        .sidebar-wrapper.collapsed {
            width: var(--sidebar-mini-width) !important;
            min-width: var(--sidebar-mini-width);
            max-width: var(--sidebar-mini-width);
        }

        /* Page Header with new styling */
        .page-header {
            background: var(--primary-gradient);
            color: white;
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .page-header h2 {
            margin: 0;
            font-weight: 600;
            font-size: 1.5rem;
            margin-bottom: 0.5rem;
        }

        .page-header .breadcrumb {
            margin: 0;
            padding: 0;
            background: transparent;
        }

        .page-header .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }

        .page-header .breadcrumb-item.active {
            color: white;
        }

        .page-header .btn-primary {
            background: rgba(255, 255, 255, 0.1);
            border: 1px solid rgba(255, 255, 255, 0.2);
            color: white;
            transition: all 0.3s ease;
        }

        .page-header .btn-primary:hover {
            background: rgba(255, 255, 255, 0.2);
            transform: translateY(-2px);
        }

        /* Form Section */
        .form-section {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
        }

        .section-title {
            color: #2c3e50;
            font-size: 1.1rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .section-title i {
            color: #0ea5e9;
        }

        /* Form Controls */
        .form-control, .form-select {
            border: 1px solid rgba(14, 165, 233, 0.2);
            border-radius: 8px;
            padding: 0.75rem 1rem;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
        }

        /* Form Progress */
        .form-progress {
            background: white;
            border-radius: 15px 15px 0 0;
            padding: 1.5rem;
            border-bottom: 1px solid rgba(0,0,0,0.1);
        }

        .progress {
            height: 4px;
            border-radius: 2px;
            background: rgba(14, 165, 233, 0.1);
        }

        .progress-bar {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        }

        /* Step Navigation */
        .form-progress-steps {
            display: flex;
            justify-content: space-between;
            margin-top: 1rem;
        }

        .step {
            text-align: center;
        }

        .step-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0.5rem;
            transition: all 0.3s ease;
        }

        .step.active .step-icon {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            color: white;
        }

        .step-label {
            color: #64748b;
            font-size: 0.875rem;
        }

        .step.active .step-label {
            color: #0ea5e9;
            font-weight: 500;
        }

        /* Navigation Buttons */
        .form-navigation {
            display: flex;
            justify-content: space-between;
            padding: 1rem;
        }

        .btn {
            padding: 0.75rem 1.5rem;
            border-radius: 8px;
            font-weight: 500;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
        }

        .btn-primary {
            background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            border: none;
            color: white;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            :root {
                --sidebar-width: 0px;
                --content-padding: 1rem;
            }

            .content-wrapper {
                margin-left: 0;
                width: 100%;
                padding: var(--content-padding);
            }

            .content-wrapper.expanded {
                margin-left: 0;
                width: 100%;
            }

            .sidebar-wrapper {
                position: fixed;
                left: calc(-1 * var(--sidebar-width));
                z-index: 1040;
            }

            .sidebar-wrapper.show {
                left: 0;
            }
        }
    </style>
</head>
<body>
<?php include_once ROOT_PATH . '/includes/sidebar.php'; ?>

<div class="content-wrapper">
    <div class="page-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2>Buat Surat Tugas</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                        <li class="breadcrumb-item active">Surat Tugas</li>
                    </ol>
                </nav>
            </div>
            <div>
                <a href="lihat_surat.php" class="btn btn-primary">
                    <i class="bi bi-eye"></i>
                    Lihat Surat Tugas
                </a>
            </div>
        </div>
    </div>

    <!-- Form Content -->
    <div class="card">
        <div class="card-body">
            <form action="proses_tambah.php" method="POST" id="formSuratTugas" class="needs-validation" novalidate>
                <!-- Progress Steps -->
                <div class="form-progress mb-4">
                    <div class="progress" style="height: 3px;">
                        <div class="progress-bar bg-info" role="progressbar" style="width: 0%"></div>
                    </div>
                    <div class="form-progress-steps mt-3">
                        <div class="step active" data-step="1">
                            <div class="step-icon bg-info text-white rounded-circle d-flex align-items-center justify-content-center mb-2" style="width: 40px; height: 40px;">
                                <i class="bi bi-file-text"></i>
                            </div>
                            <span class="step-label small">Informasi Surat</span>
                        </div>
                        <div class="step" data-step="2">
                            <div class="step-icon bg-light rounded-circle d-flex align-items-center justify-content-center mb-2" style="width: 40px; height: 40px;">
                                <i class="bi bi-person"></i>
                            </div>
                            <span class="step-label small">Data Pegawai</span>
                        </div>
                        <div class="step" data-step="3">
                            <div class="step-icon bg-light rounded-circle d-flex align-items-center justify-content-center mb-2" style="width: 40px; height: 40px;">
                                <i class="bi bi-geo-alt"></i>
                            </div>
                            <span class="step-label small">Detail Perjalanan</span>
                        </div>
                    </div>
                </div>

                <!-- Form Steps Content -->
                <div class="form-step active px-3" data-step="1">
                    <div class="form-section bg-light rounded-4 p-3">
                        <h6 class="section-title d-flex align-items-center gap-2 mb-3">
                            <i class="bi bi-file-text text-info"></i>
                            Informasi Surat
                        </h6>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-group mb-0">
                                    <label class="form-label small fw-medium mb-1">Jenis Surat</label>
                                    <select class="form-select form-select-sm py-2" name="jenis_surat" required>
                                        <option value="">Pilih Jenis Surat</option>
                                        <option value="Dalam Daerah Dalam Provinsi">Dalam Daerah Dalam Provinsi</option>
                                        <option value="Luar Daerah Dalam Provinsi">Luar Daerah Dalam Provinsi</option>
                                        <option value="Luar Daerah Luar Provinsi">Luar Daerah Luar Provinsi</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group mb-0">
                                    <label class="form-label small fw-medium mb-1">Nomor Surat</label>
                                    <input type="text" class="form-control form-control-sm" name="no_surat" placeholder="Masukkan nomor surat">
                                    <div class="form-text small">Boleh diisi tanda strip (-) atau copy & paste dari APK E-BKU</div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="form-check mt-2">
                                    <input class="form-check-input" type="checkbox" name="is_bimtek" id="isBimtek" value="1">
                                    <label class="form-check-label small" for="isBimtek">
                                        Surat Tugas Khusus Bimtek/Pelatihan dan Sejenisnya <br> <small> Ceklis jika surat tugas diperuntukan untuk bimtek, pelatihan ataupun sejenisnya</small>
                                    <br><small>untuk pendamping tidak perlu ceklis</small>
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" name="no_sppd" 
                                           value="<?= isset($form_data['no_sppd']) ? htmlspecialchars($form_data['no_sppd']) : '' ?>"
                                           placeholder="Masukkan nomor SPPD">
                                    <label>Nomor SPPD</label>
                                    <div class="form-text">copy & paste dari APK E-BKU</div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="date" class="form-control" name="tanggal_surat" 
                                           value="<?= isset($form_data['tanggal_surat']) ? htmlspecialchars($form_data['tanggal_surat']) : '' ?>"
                                           required>
                                    <label>Tanggal Surat</label>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-floating">
                                    <textarea class="form-control" id="dasarSurat" name="dasar_surat" style="height: 100px" placeholder="Masukkan dasar surat (opsional)"><?= isset($form_data['dasar_surat']) ? htmlspecialchars($form_data['dasar_surat']) : '' ?></textarea>
                                    <label for="dasarSurat">Dasar Surat</label>
                                    <div class="form-text">Boleh dikosongkan. Contoh: Surat Kepala Dinas Pendidikan Nomor: xxx/xxx/2024 tanggal dd-mm-yyyy</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 2: Data Pegawai -->
                <div class="form-step d-none" data-step="2">
                    <div class="form-section">
                        <h5 class="section-title">
                            <i class="bi bi-people me-2"></i>
                            Data Pegawai
                        </h5>
                        <div class="row g-3">
                            <div class="col-md-12">
                                <div class="form-floating">
                                    <select class="form-select select2-multiple" name="nama_pegawai[]" multiple required>
                                        <option value="">Pilih Pegawai</option>
                                        <?php
                                        while ($row = mysqli_fetch_assoc($result_pegawai)) {
                                            $selected = isset($form_data['nama_pegawai']) && in_array($row['id_pegawai'], $form_data['nama_pegawai']) ? 'selected' : '';
                                            echo "<option value='" . $row['id_pegawai'] . "' $selected>" . 
                                                 htmlspecialchars($row['nama_pegawai']) . " - " . htmlspecialchars($row['nip']) . 
                                                 " (" . htmlspecialchars($row['jabatan']) . ")</option>";
                                        }
                                        ?>
                                    </select>
                                    <div class="form-text">Pilih satu atau lebih pegawai</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Step 3: Detail Perjalanan -->
                <div class="form-step d-none" data-step="3">
                    <div class="form-section">
                        <h5 class="section-title">
                            <i class="bi bi-geo-alt me-2"></i>
                            Detail Perjalanan
                        </h5>
                        <div class="row g-3">
                            <div class="col-md-6">
                                <div class="form-floating">
                                    <input type="text" class="form-control" name="asal_berangkat" required>
                                    <label>Asal Berangkat</label>
                                </div>
                            </div>
                            <div class="col-md-6" id="generalDestination">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="tujuan" name="tujuan" autocomplete="off">
                                    <label for="tujuan">Tujuan</label>
                                    <div id="tujuanList" class="autocomplete-suggestions"></div>
                                </div>
                            </div>
                            <div class="col-md-12" id="tempat_kegiatan_container">
                                <div class="form-floating">
                                    <input type="text" class="form-control" id="tempat_kegiatan" name="tempat_kegiatan">
                                    <label for="tempat_kegiatan">Tempat Kegiatan</label>
                                    <div class="form-text">Masukkan lokasi spesifik tempat kegiatan akan dilaksanakan</div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-floating">
                                    <textarea class="form-control" name="maksud" required style="height: 100px"></textarea>
                                    <label>Maksud Perjalanan</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="tanggal_berangkat" name="tanggal_berangkat" required>
                                    <label>Tanggal Berangkat</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating">
                                    <input type="date" class="form-control" id="tanggal_kembali" name="tanggal_kembali" required>
                                    <label>Tanggal Kembali</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-floating">
                                    <input type="number" class="form-control" id="lama_perjalanan" name="lama_perjalanan" readonly required>
                                    <label>Lama Perjalanan (Hari)</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Form Navigation -->
                <div class="form-navigation mt-3 px-3 pb-3">
                    <button type="button" class="btn btn-secondary btn-sm prev-step d-none">
                        <i class="bi bi-arrow-left"></i> Sebelumnya
                    </button>
                    <button type="button" class="btn btn-primary btn-sm next-step">
                        Selanjutnya <i class="bi bi-arrow-right"></i>
                    </button>
                    <button type="submit" name="submit" class="btn btn-success btn-sm submit-btn d-none">
                        <i class="bi bi-check-circle"></i> Simpan
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
    /* Root variables */
    :root {
        --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
    }

    body {
        background: var(--bg-gradient);
        font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
        margin: 0;
        padding: 0;
        min-height: 100vh;
        overflow-x: hidden;
    }

    /* Main Content Layout */
    .content-wrapper {
        position: relative;
        margin-left: var(--sidebar-width);
        width: calc(100% - var(--sidebar-width));
        min-height: 100vh;
        padding: var(--content-padding);
        transition: all 0.3s ease;
        background: var(--bg-gradient);
    }

    .content-wrapper.expanded {
        margin-left: var(--sidebar-mini-width);
        width: calc(100% - var(--sidebar-mini-width));
    }

    /* Sidebar adjustments */
    .sidebar-wrapper {
        width: var(--sidebar-width) !important;
        min-width: var(--sidebar-width);
        max-width: var(--sidebar-width);
        transition: all 0.3s ease;
    }

    .sidebar-wrapper.collapsed {
        width: var(--sidebar-mini-width) !important;
        min-width: var(--sidebar-mini-width);
        max-width: var(--sidebar-mini-width);
    }

    /* Page Header with new styling */
    .page-header {
        background: var(--primary-gradient);
        color: white;
        padding: 2rem;
        border-radius: 15px;
        margin-bottom: 2rem;
        box-shadow: 0 4px 15px rgba(78,115,223,0.1);
    }

    .page-header h2 {
        margin: 0;
        font-weight: 600;
        font-size: 1.5rem;
        margin-bottom: 0.5rem;
    }

    .page-header .breadcrumb {
        margin: 0;
        padding: 0;
        background: transparent;
    }

    .page-header .breadcrumb-item a {
        color: rgba(255, 255, 255, 0.8);
        text-decoration: none;
    }

    .page-header .breadcrumb-item.active {
        color: white;
    }

    .page-header .btn-primary {
        background: rgba(255, 255, 255, 0.1);
        border: 1px solid rgba(255, 255, 255, 0.2);
        color: white;
        transition: all 0.3s ease;
    }

    .page-header .btn-primary:hover {
        background: rgba(255, 255, 255, 0.2);
        transform: translateY(-2px);
    }

    /* Form Section */
    .form-section {
        background: white;
        border-radius: 15px;
        padding: 2rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.05);
    }

    .section-title {
        color: #2c3e50;
        font-size: 1.1rem;
        font-weight: 600;
        margin-bottom: 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.5rem;
    }

    .section-title i {
        color: #0ea5e9;
    }

    /* Form Controls */
    .form-control, .form-select {
        border: 1px solid rgba(14, 165, 233, 0.2);
        border-radius: 8px;
        padding: 0.75rem 1rem;
        transition: all 0.3s ease;
    }

    .form-control:focus, .form-select:focus {
        border-color: #0ea5e9;
        box-shadow: 0 0 0 0.2rem rgba(14, 165, 233, 0.25);
    }

    /* Form Progress */
    .form-progress {
        background: white;
        border-radius: 15px 15px 0 0;
        padding: 1.5rem;
        border-bottom: 1px solid rgba(0,0,0,0.1);
    }

    .progress {
        height: 4px;
        border-radius: 2px;
        background: rgba(14, 165, 233, 0.1);
    }

    .progress-bar {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
    }

    /* Step Navigation */
    .form-progress-steps {
        display: flex;
        justify-content: space-between;
        margin-top: 1rem;
    }

    .step {
        text-align: center;
    }

    .step-icon {
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: rgba(14, 165, 233, 0.1);
        color: #0ea5e9;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 0.5rem;
        transition: all 0.3s ease;
    }

    .step.active .step-icon {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        color: white;
    }

    .step-label {
        color: #64748b;
        font-size: 0.875rem;
    }

    .step.active .step-label {
        color: #0ea5e9;
        font-weight: 500;
    }

    /* Navigation Buttons */
    .form-navigation {
        display: flex;
        justify-content: space-between;
        padding: 1rem;
    }

    .btn {
        padding: 0.75rem 1.5rem;
        border-radius: 8px;
        font-weight: 500;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
    }

    .btn-primary {
        background: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
        border: none;
        color: white;
    }

    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(14, 165, 233, 0.2);
    }

    /* Responsive Design */
    @media (max-width: 768px) {
        :root {
            --sidebar-width: 0px;
            --content-padding: 1rem;
        }

        .content-wrapper {
            margin-left: 0;
            width: 100%;
            padding: var(--content-padding);
        }

        .content-wrapper.expanded {
            margin-left: 0;
            width: 100%;
        }

        .sidebar-wrapper {
            position: fixed;
            left: calc(-1 * var(--sidebar-width));
            z-index: 1040;
        }

        .sidebar-wrapper.show {
            left: 0;
        }
    }
</style>

<?php include_once ROOT_PATH . '/includes/footer.php'; ?>
<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize Select2
    $('.select2').select2({
        theme: 'bootstrap-5',
        width: '100%',
        placeholder: 'Ketik untuk mencari pegawai...',
        allowClear: true,
        language: {
            noResults: function() {
                return "Data tidak ditemukan";
            },
            searching: function() {
                return "Mencari...";
            }
        },
        escapeMarkup: function(markup) {
            return markup;
        }
    });

    // Reset Select2 saat form direset
    $('form').on('reset', function() {
        $('.select2').val('').trigger('change');
    });

    // Validasi saat submit
    $('.select2').on('change', function() {
        if ($(this).val()) {
            $(this).removeClass('is-invalid');
        } else {
            $(this).addClass('is-invalid');
        }
    });

    // Form Steps Navigation
    let currentStep = 1;
    const totalSteps = 3;
    
    function updateProgress() {
        const progress = ((currentStep - 1) / (totalSteps - 1)) * 100;
        $('.progress-bar').css('width', `${progress}%`);
        
        // Update steps
        $('.step').removeClass('active');
        $(`.step[data-step="${currentStep}"]`).addClass('active');
        
        // Show/hide form steps
        $('.form-step').addClass('d-none');
        $(`.form-step[data-step="${currentStep}"]`).removeClass('d-none');
        
        // Update navigation buttons
        $('.prev-step').toggleClass('d-none', currentStep === 1);
        $('.next-step').toggleClass('d-none', currentStep === totalSteps);
        $('.submit-btn').toggleClass('d-none', currentStep !== totalSteps);
    }

    $('.next-step').click(function() {
        if (currentStep < totalSteps) {
            currentStep++;
            updateProgress();
        }
    });

    $('.prev-step').click(function() {
        if (currentStep > 1) {
            currentStep--;
            updateProgress();
        }
    });

    // Fungsi untuk menghitung lama perjalanan
    function hitungLamaPerjalanan() {
        const tanggalBerangkat = document.querySelector('input[name="tanggal_berangkat"]').value;
        const tanggalKembali = document.querySelector('input[name="tanggal_kembali"]').value;
        const inputLamaPerjalanan = document.getElementById('lama_perjalanan');

        if (tanggalBerangkat && tanggalKembali) {
            const berangkat = new Date(tanggalBerangkat);
            const kembali = new Date(tanggalKembali);

            // Reset waktu ke 00:00:00 untuk memastikan perhitungan yang akurat
            berangkat.setHours(0, 0, 0, 0);
            kembali.setHours(0, 0, 0, 0);

            if (berangkat > kembali) {
                alert('Tanggal kembali tidak boleh lebih awal dari tanggal berangkat!');
                document.querySelector('input[name="tanggal_kembali"]').value = '';
                inputLamaPerjalanan.value = '';
                return;
            }

            // Hitung selisih hari
            const diffTime = Math.abs(kembali - berangkat);
            const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));

            // Jika di hari yang sama, hitung sebagai 1 hari
            inputLamaPerjalanan.value = diffDays + 1;
        }
    }

    // Tambahkan event listener untuk kedua input tanggal
    document.querySelector('input[name="tanggal_berangkat"]').addEventListener('change', hitungLamaPerjalanan);
    document.querySelector('input[name="tanggal_kembali"]').addEventListener('change', hitungLamaPerjalanan);

    // Autocomplete untuk field tujuan
    $('#tujuan').on('keyup focus', function() {
        var query = $(this).val();
        if(query != '') {
            $.ajax({
                url: "get_tujuan.php",
                method: "POST",
                data: {
                    query: query,
                    jenis_surat: $('select[name="jenis_surat"]').val() // Kirim jenis surat untuk filter
                },
                success: function(data) {
                    $('#tujuanList').html(data);
                    $('#tujuanList').show();
                }
            });
        } else {
            $('#tujuanList').hide();
        }
    });

    // Ketika memilih item dari daftar
    $(document).on('click', '.tujuan-item', function(e) {
        e.preventDefault();
        $('#tujuan').val($(this).text().trim());
        $('#tujuanList').hide();
    });

    // Sembunyikan daftar saat klik di luar
    $(document).on('click', function(e) {
        if (!$(e.target).closest('.form-floating').length) {
            $('#tujuanList').hide();
        }
    });

    // Navigasi dengan keyboard
    $('#tujuan').on('keydown', function(e) {
        var $listItems = $('.tujuan-item');
        var $current = $listItems.filter('.active');
        var $next;

        switch(e.keyCode) {
            case 40: // Down arrow
                e.preventDefault();
                if (!$current.length) {
                    $next = $listItems.first();
                } else {
                    $next = $current.next('.tujuan-item');
                }
                break;
            case 38: // Up arrow
                e.preventDefault();
                if (!$current.length) {
                    $next = $listItems.last();
                } else {
                    $next = $current.prev('.tujuan-item');
                }
                break;
            case 13: // Enter
                e.preventDefault();
                if ($current.length) {
                    $current.click();
                }
                return;
        }

        if ($next && $next.length) {
            $listItems.removeClass('active');
            $next.addClass('active');
            $('#tujuan').val($next.text().trim());
        }
    });

    // Initialize Select2 with multiple selection
    $('.select2-multiple').select2({
        theme: 'bootstrap-5',
        width: '100%',
        placeholder: 'Pilih Pegawai',
        allowClear: true,
        language: {
            noResults: function() {
                return "Pegawai tidak ditemukan";
            },
            searching: function() {
                return "Mencari...";
            }
        }
    });

    // Update selected employees table when selection changes
    $('.select2-multiple').on('change', function() {
        let selectedOptions = $(this).find('option:selected');
        let tableBody = $('#selectedEmployeesList');
        let selectedDiv = $('.selected-employees');
        
        if(selectedOptions.length > 0) {
            let html = '';
            selectedOptions.each(function(index) {
                let text = $(this).text().split('-');
                let nama = text[0].trim();
                let nipJabatan = text[1].trim().split('(');
                let nip = nipJabatan[0].trim();
                let jabatan = nipJabatan[1].replace(')', '').trim();
                
                html += `
                    <tr>
                        <td class="text-center">${index + 1}</td>
                        <td>${nama}</td>
                        <td>${nip}</td>
                        <td>${jabatan}</td>
                    </tr>
                `;
            });
            tableBody.html(html);
            selectedDiv.removeClass('d-none');
        } else {
            selectedDiv.addClass('d-none');
        }
    });

    $('.select2-pegawai').select2({
        theme: 'bootstrap-5',
        width: '100%',
        placeholder: 'Ketik nama pegawai...',
        allowClear: true,
        ajax: {
            url: 'get_pegawai.php',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    search: params.term
                };
            },
            processResults: function(data) {
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.nama_pegawai,
                            text: item.nama_pegawai
                        };
                    })
                };
            },
            cache: true
        }
    });

    // Fungsi untuk menampilkan notifikasi
    function showNotification(message, type = 'success') {
        const toast = $('#notificationToast');
        toast.find('.toast-body').text(message);
        toast.removeClass('success error').addClass(type);
        
        const bsToast = new bootstrap.Toast(toast);
        bsToast.show();
    }

    // Tangkap error dari session jika ada
    <?php if (isset($_SESSION['alert'])): ?>
        showNotification(
            '<?= $_SESSION['alert']['message'] ?>', 
            '<?= $_SESSION['alert']['type'] ?>'
        );
        <?php unset($_SESSION['alert']); ?>
    <?php endif; ?>

    // Validasi form sebelum submit
    $('#formSuratTugas').on('submit', function(e) {
        var selectedPegawai = $('.select2-multiple').val();
        if (!selectedPegawai || selectedPegawai.length === 0) {
            e.preventDefault();
            Swal.fire({
                title: 'Error!',
                text: 'Minimal satu pegawai harus dipilih',
                icon: 'error',
                confirmButtonText: 'Ok'
            });
        }
    });

    // Fungsi untuk membuat form tujuan per pegawai
    function createPerEmployeeDestinations() {
        const jenisSurat = $('select[name="jenis_surat"]').val();
        const isBimtek = $('#isBimtek').is(':checked');
        const selectedEmployees = $('.select2-multiple').select2('data');
        const tujuanContainer = $('#perEmployeeDestinations');
        const tempatKegiatanContainer = $('#tempat_kegiatan_container');
        const generalDestination = $('#generalDestination');
        
        // Hapus container lama jika ada
        tujuanContainer.remove();
        
        // Logika untuk tempat kegiatan dan tujuan
        if (jenisSurat === 'Dalam Daerah Dalam Provinsi') {
            if (isBimtek) {
                // Jika bimtek dicentang, tampilkan tempat kegiatan dan tujuan umum
                tempatKegiatanContainer.show();
                generalDestination.show();
                $('input[name="tempat_kegiatan"]').prop('required', true);
                $('input[name="tujuan"]').prop('required', true);
            } else {
                // Jika bukan bimtek, sembunyikan tempat kegiatan dan tujuan umum
                tempatKegiatanContainer.hide();
                generalDestination.hide();
                $('input[name="tempat_kegiatan"]').prop('required', false);
                $('input[name="tujuan"]').prop('required', false);
                
                // Tampilkan tujuan per pegawai
                if (selectedEmployees.length > 0) {
            const container = $('<div id="perEmployeeDestinations" class="mb-3"></div>');
            
            selectedEmployees.forEach(employee => {
                const employeeName = employee.text.split('-')[0].trim();
                const employeeId = employee.id;
                
                const employeeDestination = `
                    <div class="form-floating mb-2">
                        <input type="text" class="form-control tujuan-pegawai" 
                               id="tujuan_${employeeId}" 
                               name="tujuan_pegawai[${employeeId}]" 
                               placeholder="Tujuan untuk ${employeeName}"
                               required>
                        <label>Tujuan untuk ${employeeName}</label>
                        <div class="tujuan-list" id="tujuanList_${employeeId}"></div>
                    </div>
                `;
                
                container.append(employeeDestination);
            });
            
                    generalDestination.after(container);
                }
            }
        } else {
            // Untuk jenis surat lainnya, tampilkan tempat kegiatan dan tujuan umum
            tempatKegiatanContainer.show();
            generalDestination.show();
            $('input[name="tempat_kegiatan"]').prop('required', true);
            $('input[name="tujuan"]').prop('required', true);
        }
            
            // Aktifkan autocomplete untuk setiap field tujuan
            $('.tujuan-pegawai').each(function() {
                $(this).on('keyup focus', function() {
                    const query = $(this).val();
                    const employeeId = $(this).attr('id').split('_')[1];
                    const tujuanList = $(`#tujuanList_${employeeId}`);
                    
                    if(query != '') {
                        $.ajax({
                            url: "get_tujuan.php",
                            method: "POST",
                            data: {
                                query: query,
                                jenis_surat: jenisSurat
                            },
                            success: function(data) {
                                tujuanList.html(data);
                                tujuanList.show();
                            }
                        });
                    } else {
                        tujuanList.hide();
                    }
                });
            });
            
            // Event handler untuk memilih tujuan
            $(document).on('click', '.tujuan-item', function() {
                const input = $(this).closest('.form-floating').find('input');
                input.val($(this).text().trim());
                $(this).closest('.tujuan-list').hide();
            });
    }

    // Panggil fungsi saat halaman dimuat dan saat ada perubahan
    $(document).ready(function() {
        // Fungsi untuk menyimpan data form ke session storage
        function saveFormData() {
            const formData = {
                jenis_surat: $('select[name="jenis_surat"]').val(),
                no_surat: $('input[name="no_surat"]').val(),
                no_sppd: $('input[name="no_sppd"]').val(),
                tanggal_surat: $('input[name="tanggal_surat"]').val(),
                dasar_surat: $('textarea[name="dasar_surat"]').val(),
                is_bimtek: $('#isBimtek').is(':checked'),
                nama_pegawai: $('.select2-multiple').val(),
                asal_berangkat: $('input[name="asal_berangkat"]').val(),
                tujuan: $('input[name="tujuan"]').val(),
                tempat_kegiatan: $('input[name="tempat_kegiatan"]').val(),
                maksud: $('textarea[name="maksud"]').val(),
                tanggal_berangkat: $('input[name="tanggal_berangkat"]').val(),
                tanggal_kembali: $('input[name="tanggal_kembali"]').val(),
                lama_perjalanan: $('input[name="lama_perjalanan"]').val()
            };

            // Simpan tujuan per pegawai jika ada
            const tujuanPegawai = {};
            $('input[name^="tujuan_pegawai"]').each(function() {
                const id = $(this).attr('name').match(/\[(\d+)\]/)[1];
                tujuanPegawai[id] = $(this).val();
            });
            formData.tujuan_pegawai = tujuanPegawai;

            sessionStorage.setItem('suratTugasFormData', JSON.stringify(formData));
        }

        // Fungsi untuk memulihkan data form dari session storage
        function restoreFormData() {
            const savedData = sessionStorage.getItem('suratTugasFormData');
            if (savedData) {
                const formData = JSON.parse(savedData);
                
                // Pulihkan nilai-nilai form
                $('select[name="jenis_surat"]').val(formData.jenis_surat).trigger('change');
                $('input[name="no_surat"]').val(formData.no_surat);
                $('input[name="no_sppd"]').val(formData.no_sppd);
                $('input[name="tanggal_surat"]').val(formData.tanggal_surat);
                $('textarea[name="dasar_surat"]').val(formData.dasar_surat);
                $('#isBimtek').prop('checked', formData.is_bimtek);
                $('.select2-multiple').val(formData.nama_pegawai).trigger('change');
                $('input[name="asal_berangkat"]').val(formData.asal_berangkat);
                $('input[name="tujuan"]').val(formData.tujuan);
                $('input[name="tempat_kegiatan"]').val(formData.tempat_kegiatan);
                $('textarea[name="maksud"]').val(formData.maksud);
                $('input[name="tanggal_berangkat"]').val(formData.tanggal_berangkat);
                $('input[name="tanggal_kembali"]').val(formData.tanggal_kembali);
                $('input[name="lama_perjalanan"]').val(formData.lama_perjalanan);

                // Tunggu sebentar untuk memastikan tujuan per pegawai sudah dibuat
                setTimeout(() => {
                    // Pulihkan tujuan per pegawai
                    if (formData.tujuan_pegawai) {
                        Object.entries(formData.tujuan_pegawai).forEach(([id, value]) => {
                            $(`input[name="tujuan_pegawai[${id}]"]`).val(value);
                        });
                    }
                }, 300);
            }
        }

        // Hapus data form saat form berhasil disubmit
        $('#formSuratTugas').on('submit', function() {
            sessionStorage.removeItem('suratTugasFormData');
        });

        // Simpan data form saat ada perubahan
        $('#formSuratTugas').on('change', 'input, select, textarea', function() {
            saveFormData();
        });

        // Simpan data form saat mengetik
        $('#formSuratTugas').on('input', 'input, textarea', function() {
            saveFormData();
        });

        // Pulihkan data form saat halaman dimuat
        restoreFormData();

        // Kode yang sudah ada sebelumnya
        $('.select2-multiple').select2({
            theme: 'bootstrap-5',
            width: '100%'
        }).on('select2:select select2:unselect', function(e) {
            setTimeout(createPerEmployeeDestinations, 100);
            saveFormData(); // Tambahkan ini untuk menyimpan perubahan select2
        });

        $('select[name="jenis_surat"], #isBimtek').on('change', function() {
            setTimeout(createPerEmployeeDestinations, 100);
            saveFormData(); // Tambahkan ini untuk menyimpan perubahan
        });

        setTimeout(createPerEmployeeDestinations, 100);
    });

    // Tambahkan event untuk menangani unload
    window.addEventListener('beforeunload', function() {
        // Jika form sudah disubmit, hapus data
        if (document.querySelector('#formSuratTugas').classList.contains('submitted')) {
            sessionStorage.removeItem('suratTugasFormData');
        }
    });

    // Handle sidebar toggle effect on content
    const contentWrapper = document.querySelector('.content-wrapper');
    const sidebarWrapper = document.querySelector('.sidebar-wrapper');

    // Check initial state
    if (localStorage.getItem('sidebarCollapsed') === 'true') {
        contentWrapper.classList.add('expanded');
    }

    // Listen for sidebar toggle
    const sidebarToggleBtn = document.getElementById('sidebarToggleBtn');
    sidebarToggleBtn.addEventListener('click', function() {
        contentWrapper.classList.toggle('expanded');
        
        // Trigger resize event to adjust any responsive elements
        window.dispatchEvent(new Event('resize'));
    });

    // Handle responsive behavior
    function handleResponsive() {
        if (window.innerWidth <= 768) {
            contentWrapper.classList.remove('expanded');
        } else {
            if (localStorage.getItem('sidebarCollapsed') === 'true') {
                contentWrapper.classList.add('expanded');
            }
        }
    }

    // Initial check and listen for window resize
    handleResponsive();
    window.addEventListener('resize', handleResponsive);
});
</script>

<script>
document.querySelector('form').addEventListener('submit', function(e) {
    const noSurat = document.querySelector('input[name="no_surat"]');
    const noSPPD = document.querySelector('input[name="no_sppd"]');
    
    // Jika kosong, otomatis isi dengan strip
    if (!noSurat.value.trim()) {
        noSurat.value = '-';
    }
    if (!noSPPD.value.trim()) {
        noSPPD.value = '-';
    }
});
</script>

<?php
if (isset($_POST['submit'])) {
    try {
        mysqli_begin_transaction($conn);
        
        // Debug: Cek nilai yang diterima
        error_log("Dasar Surat: " . $_POST['dasar_surat']);
        
        // 1. Insert ke tabel surat_tugas
        $query = "INSERT INTO surat_tugas (
            jenis_surat,
            no_surat,
            no_sppd,
            tanggal_surat,
            dasar_surat,
            asal_berangkat,
            tujuan,
            tempat_kegiatan,
            maksud,
            tanggal_berangkat,
            tanggal_kembali,
            lama_perjalanan,
            created_by
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        
        $created_by = isset($_SESSION['user_id']) ? $_SESSION['user_id'] : null;
        
        $stmt = mysqli_prepare($conn, $query);
        if (!$stmt) {
            throw new Exception("Error in preparing statement: " . mysqli_error($conn));
        }
        
        mysqli_stmt_bind_param($stmt, "sssssssssssii",
            $_POST['jenis_surat'],
            $_POST['no_surat'],
            $_POST['no_sppd'],
            $_POST['tanggal_surat'],
            $_POST['dasar_surat'],  // Pastikan parameter ini terikat dengan benar
            $_POST['asal_berangkat'],
            $_POST['tujuan'],
            $_POST['tempat_kegiatan'],
            $_POST['maksud'],
            $_POST['tanggal_berangkat'],
            $_POST['tanggal_kembali'],
            $_POST['lama_perjalanan'],
            $created_by
        );
        
        if (!mysqli_stmt_execute($stmt)) {
            throw new Exception("Error executing statement: " . mysqli_stmt_error($stmt));
        }
        
        $id_surat = mysqli_insert_id($conn);
        
        // 2. Insert ke tabel detail_surat_tugas untuk setiap pegawai yang dipilih
        if (isset($_POST['nama_pegawai']) && is_array($_POST['nama_pegawai'])) {
            $query_detail = "INSERT INTO detail_surat_tugas (id_surat, id_pegawai) VALUES (?, ?)";
            $stmt_detail = mysqli_prepare($conn, $query_detail);
            
            foreach ($_POST['nama_pegawai'] as $id_pegawai) {
                mysqli_stmt_bind_param($stmt_detail, "ii", $id_surat, $id_pegawai);
                if (!mysqli_stmt_execute($stmt_detail)) {
                    throw new Exception("Error saat menyimpan detail pegawai: " . mysqli_error($conn));
                }
            }
        } else {
            throw new Exception("Pilih minimal satu pegawai");
        }
        
        mysqli_commit($conn);
        
        $_SESSION['alert'] = [
            'type' => 'success',
            'message' => 'Surat tugas berhasil disimpan'
        ];
        
        header("Location: lihat_surat.php");
        exit;
        
    } catch (Exception $e) {
        mysqli_rollback($conn);
        error_log("Error in surat_tugas.php: " . $e->getMessage());
        
        $_SESSION['alert'] = [
            'type' => 'danger',
            'message' => $e->getMessage()
        ];
        
        // Simpan data form ke session untuk mengisi kembali form
        $_SESSION['form_data'] = $_POST;
    }
}

// Tambahkan ini di bagian form untuk menampilkan error/success message
if (isset($_SESSION['alert'])) {
    $alertType = $_SESSION['alert']['type'];
    $alertMessage = $_SESSION['alert']['message'];
    echo "
    <div class='alert alert-{$alertType} alert-dismissible fade show' role='alert'>
        {$alertMessage}
        <button type='button' class='btn-close' data-bs-dismiss='alert' aria-label='Close'></button>
    </div>";
    unset($_SESSION['alert']);
}
?>

</body>
</html> 