<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek apakah user adalah pimpinan (tidak boleh membuat telaah)
if ($_SESSION['level'] === 'pimpinan') {
    header("Location: index.php");
    exit();
}

// Proses form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Validasi input
        $required_fields = ['kepada', 'dari', 'tanggal', 'nomor', 'hal', 'persoalan', 'pra_anggapan', 'fakta_fakta', 'analisis', 'kesimpulan', 'saran'];
        $errors = [];
        
        foreach ($required_fields as $field) {
            if (empty($_POST[$field])) {
                $errors[] = "Field " . ucfirst($field) . " harus diisi!";
            }
        }

        if (empty($errors)) {
            $kepada = $_POST['kepada'];
            $dari = $_POST['dari'];
            $tanggal = $_POST['tanggal'];
            $nomor = $_POST['nomor'];
            $lampiran = $_POST['lampiran'] ?? '-';
            $hal = $_POST['hal'];
            
            // Fungsi untuk membersihkan konten HTML
            function cleanHTML($html) {
                // Hapus whitespace berlebih
                $html = preg_replace('/\s+/', ' ', $html);
                
                // Hapus tag <p> di awal
                $html = preg_replace('/^<p>/', '', $html);
                
                // Hapus tag </p> di akhir
                $html = preg_replace('/<\/p>$/', '', $html);
                
                // Ganti multiple <p> tags dengan line break
                $html = preg_replace('/<\/p>\s*<p>/', "\n", $html);
                
                // Bersihkan spasi berlebih
                $html = trim($html);
                
                return $html;
            }
            
            // Bersihkan konten HTML sebelum disimpan
            $persoalan = cleanHTML($_POST['persoalan']);
            $pra_anggapan = cleanHTML($_POST['pra_anggapan']);
            $fakta_fakta = cleanHTML($_POST['fakta_fakta']);
            $analisis = cleanHTML($_POST['analisis']);
            $kesimpulan = cleanHTML($_POST['kesimpulan']);
            $saran = cleanHTML($_POST['saran']);
            
            $created_by = $_SESSION['user_id'];
            $status = 'draft';

            // Ubah kolom di database menjadi TEXT atau MEDIUMTEXT jika belum
            $alter_queries = [
                "ALTER TABLE telaah_staf MODIFY persoalan MEDIUMTEXT",
                "ALTER TABLE telaah_staf MODIFY pra_anggapan MEDIUMTEXT",
                "ALTER TABLE telaah_staf MODIFY fakta_fakta MEDIUMTEXT",
                "ALTER TABLE telaah_staf MODIFY analisis MEDIUMTEXT",
                "ALTER TABLE telaah_staf MODIFY kesimpulan MEDIUMTEXT",
                "ALTER TABLE telaah_staf MODIFY saran MEDIUMTEXT"
            ];

            foreach ($alter_queries as $alter_query) {
                mysqli_query($conn, $alter_query);
            }

            $query = "INSERT INTO telaah_staf (
                kepada, dari, tanggal_dibuat, nomor, lampiran, perihal, 
                persoalan, pra_anggapan, fakta_fakta, analisis, kesimpulan, 
                saran, keterangan_biaya, created_by, status
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "sssssssssssssss",
                $kepada, $dari, $tanggal, $nomor, $lampiran, $hal,
                $persoalan, $pra_anggapan, $fakta_fakta, $analisis, $kesimpulan,
                $saran, $_POST['keterangan_biaya'], $created_by, $status
            );

            if (mysqli_stmt_execute($stmt)) {
                $_SESSION['success'] = "Telaah Staf berhasil dibuat!";
                header("Location: index.php");
                exit();
            } else {
                throw new Exception("Error saat menyimpan data: " . mysqli_error($conn));
            }
        }
    } catch (Exception $e) {
        $errors[] = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buat Telaah Staf - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <!-- Summernote CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 280px;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all 0.3s ease;
            padding: 2rem;
        }

        body.sidebar-collapsed .container-fluid {
            margin-left: 25px;
            width: calc(100% - 25px);
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            text-align: center;
            text-transform: uppercase;
        }

        .card {
            background: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            margin-bottom: 2rem;
        }

        .card-body {
            padding: 2rem;
        }

        .form-label {
            font-weight: 500;
            color: #1e293b;
            margin-bottom: 0.5rem;
        }

        .form-control, .form-select {
            border: 1px solid #e2e8f0;
            border-radius: 8px;
            padding: 0.75rem;
            font-size: 0.9rem;
            transition: all 0.2s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }

        textarea.form-control {
            min-height: 100px;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 15px rgba(14, 165, 233, 0.2);
        }

        .btn-secondary {
            background: #e2e8f0;
            border: none;
            color: #475569;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .btn-secondary:hover {
            background: #cbd5e1;
            color: #1e293b;
        }

        .alert {
            border: none;
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1.5rem;
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 1rem;
            color: #1e293b;
        }

        .form-group.row {
            margin-bottom: 1rem;
            align-items: center;
        }

        .form-group.row label {
            text-align: right;
            padding-right: 1rem;
        }

        @media (max-width: 768px) {
            .container-fluid {
                margin-left: 0;
                width: 100%;
                padding: 1rem;
            }

            .form-group.row label {
                text-align: left;
                margin-bottom: 0.5rem;
            }
        }

        /* Summernote Custom Styles */
        .note-editor {
            margin-bottom: 1rem;
        }
        .note-editor.note-frame {
            border-radius: 8px;
            border-color: #e2e8f0;
        }
        .note-editor.note-frame:focus-within {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }
        .note-toolbar {
            background: #f8fafc;
            border-radius: 8px 8px 0 0;
            border-bottom-color: #e2e8f0;
        }
        .note-statusbar {
            border-radius: 0 0 8px 8px;
        }

        .help-button {
            background: var(--primary-gradient);
            color: white;
            border: none;
            border-radius: 50%;
            width: 25px;
            height: 25px;
            font-size: 14px;
            cursor: pointer;
            margin-left: 10px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
        }
        
        .modal-panduan {
            max-width: 800px;
        }
        
        .panduan-section {
            margin-bottom: 1.5rem;
        }
        
        .panduan-section h5 {
            color: #1e293b;
            margin-bottom: 0.5rem;
        }
        
        .panduan-section .example {
            background: #f8fafc;
            padding: 1rem;
            border-radius: 8px;
            border-left: 4px solid #0ea5e9;
            margin: 0.5rem 0;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="container-fluid">
        <div class="header-wrapper">
            <h1>TELAAHAN STAF</h1>
        </div>

        <?php if (!empty($errors)): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php foreach ($errors as $error): ?>
                    <li><?= $error ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="card">
                <div class="card-body">
                    <!-- Header Information -->
                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Kepada</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="kepada" required
                                   value="<?= $_POST['kepada'] ?? 'Bupati Balangan/Wakil Bupati Balangan' ?>">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Dari</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="dari" required
                                   value="<?= $_POST['dari'] ?? '' ?>">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Tanggal</label>
                        <div class="col-sm-10">
                            <input type="date" class="form-control" name="tanggal" required
                                   value="<?= $_POST['tanggal'] ?? date('Y-m-d') ?>">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Nomor</label>
                        <div class="col-sm-10">
                            <input type="text" 
                                   class="form-control" 
                                   name="nomor" 
                                   id="nomorTelaah"
                                   required
                                   autocomplete="off"
                                   value="<?= $_POST['nomor'] ?? '' ?>"
                                   placeholder="420/    /BP.Dikdas/Disdikbud/2025">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Lampiran</label>
                        <div class="col-sm-10">
                            <input type="text" class="form-control" name="lampiran"
                                   value="<?= $_POST['lampiran'] ?? '-' ?>">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="col-sm-2 col-form-label">Hal</label>
                        <div class="col-sm-10">
                            <textarea class="form-control" name="hal" required><?= $_POST['hal'] ?? '' ?></textarea>
                        </div>
                    </div>

                    <!-- Main Content -->
                    <div class="mt-4">
                        <div class="mb-4">
                            <label class="form-label section-title">I. Persoalan</label>
                            <textarea class="form-control summernote" name="persoalan" required><?= $_POST['persoalan'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">II. Pra Anggapan</label>
                            <textarea class="form-control summernote" name="pra_anggapan" required><?= $_POST['pra_anggapan'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">
                                III. Fakta-Fakta yang mempengaruhi
                                <button type="button" class="help-button" data-bs-toggle="modal" data-bs-target="#panduanModal">
                                    <i class="bi bi-question-lg"></i>
                                </button>
                            </label>
                            <textarea class="form-control summernote" name="fakta_fakta" required><?= $_POST['fakta_fakta'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">
                                IV. Analisis
                                <button type="button" class="help-button" data-bs-toggle="modal" data-bs-target="#panduanModal">
                                    <i class="bi bi-question-lg"></i>
                                </button>
                            </label>
                            <textarea class="form-control summernote" name="analisis" required><?= $_POST['analisis'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">V. Kesimpulan</label>
                            <textarea class="form-control summernote" name="kesimpulan" required><?= $_POST['kesimpulan'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">VI. Saran</label>
                            <textarea class="form-control summernote" name="saran" required><?= $_POST['saran'] ?? '' ?></textarea>
                        </div>

                        <div class="mb-4">
                            <label class="form-label section-title">Keterangan Biaya</label>
                            <textarea class="form-control" name="keterangan_biaya" rows="2" 
                                placeholder="Contoh: Biaya perjalanan dinas di atas dibebankan pada DPA masing-masing SKPD Tahun Anggaran 2025."
                            ><?= $_POST['keterangan_biaya'] ?? '' ?></textarea>
                            <small class="text-muted">Masukkan keterangan mengenai pembiayaan perjalanan dinas</small>
                        </div>
                    </div>

                    <div class="d-flex justify-content-end gap-2 mt-4">
                        <a href="index.php" class="btn btn-secondary">Batal</a>
                        <button type="submit" class="btn btn-primary">Simpan Telaah</button>
                    </div>
                </div>
            </div>
        </form>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Summernote JS -->
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        // Memastikan input nomor bisa diketik
        document.getElementById('nomorTelaah').addEventListener('input', function(e) {
            // Hapus karakter yang tidak diinginkan (jika ada)
            let value = e.target.value;
            // Biarkan user mengetik bebas
            e.target.value = value;
        });

        $(document).ready(function() {
            $('.summernote').summernote({
                placeholder: 'Tulis di sini...',
                tabsize: 2,
                height: 200,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'italic', 'clear']],
                    ['fontsize', ['fontsize']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ],
                callbacks: {
                    onPaste: function (e) {
                        // Bersihkan paste dari MS Word atau sumber lain
                        var bufferText = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                        e.preventDefault();
                        document.execCommand('insertText', false, bufferText);
                    }
                },
                styleTags: ['p', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                styleWithSpan: false
            });
        });

        // Add this at the end of your existing scripts
        document.addEventListener('DOMContentLoaded', function() {
            const body = document.body;
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            
            function updateSidebarState() {
                if (localStorage.getItem('sidebarCollapsed') === 'true') {
                    body.classList.add('sidebar-collapsed');
                } else {
                    body.classList.remove('sidebar-collapsed');
                }
            }
            
            // Initial state
            updateSidebarState();
            
            // Toggle event
            sidebarToggle?.addEventListener('click', function() {
                body.classList.toggle('sidebar-collapsed');
                localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
            });
        });
    </script>

    <!-- Add this after your form content but before closing body tag -->
    <div class="modal fade" id="panduanModal" tabindex="-1">
        <div class="modal-dialog modal-dialog-scrollable modal-panduan">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Panduan Pengisian Telaah Staf</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="panduan-section">
                        <h5>Cara Penulisan untuk Penomoran Otomatis:</h5>
                        <p>Untuk bagian <strong>Fakta-Fakta</strong> dan <strong>Analisis</strong>, gunakan cara penulisan berikut:</p>
                        <div class="example">
                            <p class="mb-2">✅ Tulis poin pertama [Enter]</p>
                            <p class="mb-2">✅ Tulis poin kedua [Enter]</p>
                            <p class="mb-0">✅ Tulis poin ketiga</p>
                        </div>
                        <p class="mt-3">Yang <strong>TIDAK BOLEH</strong> dilakukan:</p>
                        <div class="example text-danger">
                            <p class="mb-2">❌ 1. Jangan tulis nomor manual</p>
                            <p class="mb-2">❌ - Jangan gunakan tanda hubung</p>
                            <p class="mb-0">❌ • Jangan gunakan bullet point</p>
                        </div>
                    </div>

                    <div class="panduan-section">
                        <h5>Aturan Penting:</h5>
                        <ul>
                            <li>Setiap poin baru HARUS menggunakan Enter (baris baru)</li>
                            <li>JANGAN menambahkan nomor manual (1., 2., dst)</li>
                            <li>JANGAN menggunakan bullet point atau simbol lain</li>
                            <li>Satu baris untuk satu poin/kalimat lengkap</li>
                            <li>Tidak perlu memberi spasi di awal baris</li>
                        </ul>
                    </div>

                    <div class="panduan-section">
                        <h5>Contoh Penulisan Fakta-Fakta:</h5>
                        <div class="example">
                            <p>Peraturan Bupati Balangan Nomor 61 Tahun 2020 tentang Pedoman Pemberian Beasiswa.</p>
                            <p>Pendidikan sebagaimana telah diubah beberapa kali, terakhir dengan Peraturan Bupati Nomor 46 Tahun 2024.</p>
                            <p>Surat Penawaran Kerjasama program Beasiswa Seribu Sarjana.</p>
                        </div>
                    </div>

                    <div class="panduan-section">
                        <h5>Contoh Penulisan Analisis:</h5>
                        <div class="example">
                            <p>Pelaksanaan verifikasi data calon penerima beasiswa dilaksanakan oleh Perguruan Tinggi.</p>
                            <p>Setelah diverifikasi kedua belah pihak, maka dibuatkan invoice.</p>
                            <p>Perlunya penyampaian surat penawaran Kerjasama.</p>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                </div>
            </div>
        </div>
    </div>
</body>
</html> 