<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Get parameters from the form
$id_telaah = isset($_GET['id']) ? (int)$_GET['id'] : die('ID Telaah tidak ditemukan');
$tanggal_cetak = isset($_GET['tanggal_cetak']) ? $_GET['tanggal_cetak'] : date('Y-m-d');
$tempat_cetak = isset($_GET['tempat_cetak']) ? $_GET['tempat_cetak'] : 'Paringin';
$id_pejabat = isset($_GET['id_pejabat']) ? (int)$_GET['id_pejabat'] : die('ID Pejabat tidak ditemukan');

// Get telaah data
$query_telaah = "SELECT * FROM telaah_staf WHERE id = ?";
$stmt = mysqli_prepare($conn, $query_telaah);
mysqli_stmt_bind_param($stmt, "i", $id_telaah);
mysqli_stmt_execute($stmt);
$result_telaah = mysqli_stmt_get_result($stmt);
$telaah = mysqli_fetch_assoc($result_telaah);

if (!$telaah) {
    die('Telaah Staf tidak ditemukan');
}

// Get pejabat data
$query_pejabat = "SELECT nama, nip, jabatan, pangkat, golongan FROM pejabat_daerah WHERE id_pejabat = ? AND status = 'aktif'";
$stmt = mysqli_prepare($conn, $query_pejabat);
mysqli_stmt_bind_param($stmt, "i", $id_pejabat);
mysqli_stmt_execute($stmt);
$result_pejabat = mysqli_stmt_get_result($stmt);
$pejabat = mysqli_fetch_assoc($result_pejabat);

if (!$pejabat) {
    die('Data Pejabat tidak ditemukan');
}

function tanggal_indo($tanggal) {
    $bulan = array(1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni', 'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember');
    $split = explode('-', $tanggal);
    return $split[2] . ' ' . $bulan[(int)$split[1]] . ' ' . $split[0];
}

function tanggal_bulan_tahun($tanggal) {
    $bulan = array(
        1 => 'Januari', 'Februari', 'Maret', 'April', 'Mei', 'Juni',
        'Juli', 'Agustus', 'September', 'Oktober', 'November', 'Desember'
    );
    
    $split = explode('-', $tanggal);
    $bulan_indo = $bulan[(int)$split[1]];
    $tahun = $split[0];
    
    return "____ " . $bulan_indo . " " . $tahun;
}

function formatText($text, $use_numbering = false) {
    // Izinkan tag HTML yang diperlukan
    $allowed_tags = '<p><br><ol><ul><li><strong><em><u><span><div>';
    $text = strip_tags($text, $allowed_tags);
    
    // Ganti karakter HTML entities
    $text = html_entity_decode($text);
    
    if ($use_numbering) {
        // Pisahkan teks menjadi baris-baris
        $lines = preg_split('/\R/', $text);
        $formatted = '';
        
        foreach ($lines as $line) {
            $line = trim($line);
            if (!empty($line)) {
                // Hapus nomor yang mungkin ada di awal
                $line = preg_replace('/^\d+\.\s*/', '', $line);
                
                // Pastikan ada tanda titik di akhir
                if (!preg_match('/[.!?]$/', $line)) {
                    $line .= '.';
                }
                
                $formatted .= $line . "\n";
            }
        }
        return trim($formatted);
    } else {
        // Format tanpa penomoran
        $lines = preg_split('/\R/', $text);
        $formatted = '';
        
        foreach ($lines as $line) {
            $line = trim($line);
            if (!empty($line)) {
                // Pastikan ada tanda titik di akhir
                if (!preg_match('/[.!?]$/', $line)) {
                    $line .= '.';
                }
                $formatted .= $line . "\n";
            }
        }
        return trim($formatted);
    }
}

// Tambahkan fungsi untuk kapitalisasi awal kata
function ucwords_custom($str) {
    return ucwords(strtolower($str));
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
 
    <meta charset="UTF-8">
    <title>Telaah Staf - <?= htmlspecialchars($telaah['nomor']) ?></title>
    <style>
        @page {
            size: F4;  /* 215.9mm x 330mm */
            margin: 1cm 3cm 3cm 4cm; /* Mengurangi margin atas dari 2cm ke 1cm */
        }
        body {
            font-family: "Times New Roman", Times, serif;
            font-size: 12pt;
            line-height: 1.5;
            margin: 0;
            padding: 0;
        }
        .header {
            text-align: center;
            margin-bottom: 0.8cm; /* Mengurangi margin bottom header */
            margin-top: -0.5cm; /* Menambahkan margin negatif untuk menggeser ke atas */
        }
        .header img {
            width: 100%;
            height: auto;
            max-height: 3.5cm;
        }
        .title {
            text-align: center;
            font-weight: bold;
            text-decoration: underline;
            margin: 0.5cm 0; /* Mengurangi margin dari 0.7cm ke 0.5cm */
            font-size: 14pt;
        }
        .content-table {
            width: 100%;
            margin-bottom: 1cm;
            border-spacing: 0;
        }
        .content-table td {
            vertical-align: top;
            padding: 0.05cm 0;
            line-height: 1.2;
        }
        .content-table tr:last-child td {
            border-bottom: 1px solid black; /* Menambahkan garis di baris terakhir */
            padding-bottom: 0.2cm; /* Menambah sedikit ruang sebelum garis */
        }
        .content-table td:first-child {
            width: 3cm;
        }
        .content-table td:nth-child(2) {
            width: 0.5cm;
            text-align: center;
        }
        .content-table td.hal-content {
            text-align: justify;
            padding-bottom: 0.2cm; /* Menambah ruang antara teks dan garis */
        }
        .section {
            margin: 0.8cm 0;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 0.3cm;
            color: #1e293b;
        }
        .section-content {
            text-align: justify;
            padding-left: 0;
            line-height: 1.5;
            text-indent: 0;
            font-weight: normal; /* Mengembalikan ke normal */
        }
        .section-content p {
            margin: 0 0 0.3cm 0;
            text-indent: 0; /* Memastikan tidak ada text indent pada paragraf */
        }
        /* Untuk list terurut (1, 2, 3, ...) */
        .numbered-list {
            counter-reset: item; /* Reset counter */
            margin: 0;
            padding: 0;
            list-style-type: none;
        }
        .numbered-list p {
            margin: 0 0 0.3cm 0;
            line-height: 1.5;
            position: relative;
        }
        /* Tambahan untuk memastikan konten tidak tumpang tindih dengan nomor */
        .list-item span.number + span {
            display: block;
            margin-left: 1.5cm; /* Sesuaikan dengan lebar nomor */
        }
        .signature-section {
            page-break-inside: avoid;
            break-inside: avoid;
            margin-top: 1cm;
        }
        .signature {
            margin-top: 1cm;
            text-align: left;
            float: right;
            width: 50%;
            page-break-inside: avoid;
            break-inside: avoid;
        }
        .signature p {
            margin: 0;
            line-height: 1.5;
        }
        .consideration {
            clear: both;
            margin-top: 1cm;
            position: relative;
            page-break-inside: avoid;
            break-inside: avoid;
        }
        .consideration-wrapper {
            page-break-inside: avoid;
            break-inside: avoid;
        }
        .consideration-text {
            text-decoration: none;
            font-weight: normal;
        }
        .double-line {
            border-top: 1px solid black;
            margin: 0.2cm 0; /* Mengurangi margin garis */
            width: 100%;
        }
        .single-line {
            border-top: 1px solid black;
            margin: 0.2cm 0;
            width: 100%;
        }
        @media print {
            .pagebreak {
                page-break-before: always;
            }
            .section-content {
                page-break-inside: avoid;
            }
            .numbered-list {
                page-break-inside: avoid;
            }
        }
        .list-item {
            position: relative;
            padding-left: 2.5cm;
            margin: 0 0 0.3cm 0;
            text-align: justify;
            text-indent: 0;
            clear: both;
            display: block;
            font-weight: normal; /* Mengembalikan ke normal */
        }
        
        .number {
            position: absolute;
            left: 1cm;
            width: 1.5cm;
            text-align: left;
            float: left;
            clear: left;
            font-weight: normal; /* Mengembalikan ke normal */
        }
        
        /* Tambahan untuk memastikan spasi konsisten */
        .section-content {
            margin-top: 0.5cm;
        }
        
        .numbered-list p:last-child {
            margin-bottom: 0;
        }

        .list-item .content {
            font-weight: normal; /* Mengembalikan ke normal */
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="../assets/img/kop/kopdinas.png" alt="Kop Surat">
    </div>

    <div class="title">TELAAHAN STAF</div>

    <table class="content-table">
        <tr>
            <td>Kepada</td>
            <td>:</td>
            <td><?php 
                if (strpos(strtolower($pejabat['jabatan']), 'kepala bidang') !== false || 
                    strpos(strtolower($pejabat['jabatan']), 'kasubbag') !== false) {
                    echo "Kepala Dinas Pendidikan dan Kebudayaan Kabupaten Balangan";
                } else {
                    echo htmlspecialchars($telaah['kepada']);
                }
            ?></td>
        </tr>
        <tr>
            <td>Dari</td>
            <td>:</td>
            <td><?= ucwords_custom(htmlspecialchars($pejabat['jabatan'])) ?></td>
        </tr>
        <tr>
            <td>Tanggal</td>
            <td>:</td>
            <td><?= tanggal_indo($telaah['tanggal_dibuat']) ?></td>
        </tr>
        <tr>
            <td>Nomor</td>
            <td>:</td>
            <td><?= htmlspecialchars($telaah['nomor']) ?></td>
        </tr>
        <tr>
            <td>Lampiran</td>
            <td>:</td>
            <td><?= htmlspecialchars($telaah['lampiran']) ?></td>
        </tr>
        <tr>
            <td>Hal</td>
            <td>:</td>
            <td class="hal-content"><?= nl2br(htmlspecialchars($telaah['perihal'])) ?></td>
        </tr>
    </table>

    <div class="section">
        <div class="section-title">I. Persoalan</div>
        <div class="section-content"><?= nl2br(formatText($telaah['persoalan'], false)) ?></div>
    </div>

    <div class="section">
        <div class="section-title">II. Pra Anggapan</div>
        <div class="section-content"><?= nl2br(formatText($telaah['pra_anggapan'], false)) ?></div>
    </div>

    <div class="section">
        <div class="section-title">III. Fakta-Fakta yang mempengaruhi</div>
        <div class="section-content">
            <div class="numbered-list">
            <?php 
            $fakta = $telaah['fakta_fakta'];
            
            // Bersihkan format HTML dan entities
            $fakta = strip_tags($fakta);
            $fakta = html_entity_decode($fakta);
            
            // Pisahkan berdasarkan baris baru
            $lines = preg_split('/\R/', $fakta, -1, PREG_SPLIT_NO_EMPTY);
            
            // Filter dan format setiap baris
            $counter = 1;
            foreach($lines as $line) {
                $line = trim($line);
                if (!empty($line)) {
                    // Hapus semua jenis penomoran yang mungkin ada di awal
                    $line = preg_replace('/^[\d]+[\.)]\s*/', '', $line);
                    
                    // Pastikan ada tanda titik di akhir
                    if (!preg_match('/[.!?]$/', $line)) {
                        $line .= '.';
                    }
                    
                    // Tambahkan wrapper span untuk konten
                    echo "<p class='list-item'><span class='number'>{$counter}.</span><span class='content'>{$line}</span></p>";
                    $counter++;
                }
            }
            ?>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">IV. Analisis</div>
        <div class="section-content">
            <div class="numbered-list">
            <?php 
            $analisis = $telaah['analisis'];
            
            // Bersihkan format HTML dan entities
            $analisis = strip_tags($analisis);
            $analisis = html_entity_decode($analisis);
            
            // Pisahkan berdasarkan baris baru
            $lines = preg_split('/\R/', $analisis, -1, PREG_SPLIT_NO_EMPTY);
            
            // Filter dan format setiap baris
            $counter = 1;
            foreach($lines as $line) {
                $line = trim($line);
                if (!empty($line)) {
                    // Hapus semua jenis penomoran yang mungkin ada di awal
                    $line = preg_replace('/^[\d]+[\.)]\s*/', '', $line);
                    
                    // Pastikan ada tanda titik di akhir
                    if (!preg_match('/[.!?]$/', $line)) {
                        $line .= '.';
                    }
                    
                    // Tambahkan wrapper span untuk konten
                    echo "<p class='list-item'><span class='number'>{$counter}.</span><span class='content'>{$line}</span></p>";
                    $counter++;
                }
            }
            ?>
            </div>
        </div>
    </div>

    <div class="section">
        <div class="section-title">V. Kesimpulan</div>
        <div class="section-content"><?= nl2br(formatText($telaah['kesimpulan'], false)) ?></div>
    </div>

    <div class="section">
        <div class="section-title">VI. Saran</div>
        <div class="section-content"><?= nl2br(formatText($telaah['saran'], false)) ?></div>
    </div>

    <?php if (!empty($telaah['keterangan_biaya'])): ?>
    <div class="section">
        <div class="section-content" style="margin-top: 1cm; font-style: italic;"><?= nl2br(htmlspecialchars($telaah['keterangan_biaya'])) ?></div>
    </div>
    <?php endif; ?>

    <div class="section">
        <div class="section-content" style="margin-top: 1cm;">
            Demikian telaahan staf ini disampaikan untuk bahan pertimbangan, mohon arahan dan keputusan Bapak.
        </div>
    </div>

    <!-- Wrap signature and consideration sections in a container -->
    <div class="signature-section">
        <div class="signature">
            <p><?= htmlspecialchars($tempat_cetak) ?>, <?= tanggal_bulan_tahun($tanggal_cetak) ?></p>
            <p><?= ucwords_custom(htmlspecialchars($pejabat['jabatan'])) ?></p>
            <br><br><br>
            <p><u><?= htmlspecialchars($pejabat['nama']) ?></u></p>
            <p><?= ucwords(strtolower(htmlspecialchars($pejabat['pangkat']))) ?> / <?= htmlspecialchars($pejabat['golongan']) ?></p>
            <p>NIP. <?= htmlspecialchars($pejabat['nip']) ?></p>
            <br><br>
        </div>

        <div class="consideration-wrapper"></div>
            <div class="consideration">
                <div class="double-line"></div>
                <?php if (strpos(strtolower($pejabat['jabatan']), 'kepala bidang') !== false || 
                          strpos(strtolower($pejabat['jabatan']), 'kasubbag') !== false): ?>
                    <p><span class="consideration-text">Pertimbangan Sekretaris Dinas Pendidikan dan Kebudayaan</span></p>
                <?php else: ?>
                    <p><span class="consideration-text">Pertimbangan Plt. Asisten Pemerintahan dan Kesra</span></p>
                <?php endif; ?>
                <div class="double-line"></div>
                <br><br>
            </div>

            <div class="consideration">
                <div class="double-line"></div>
                <?php if (strpos(strtolower($pejabat['jabatan']), 'kepala bidang') !== false || 
                          strpos(strtolower($pejabat['jabatan']), 'kasubbag') !== false): ?>
                    <p><span class="consideration-text">Keputusan Kepala Dinas Pendidikan dan Kebudayaan</span></p>
                    
                    <?php else: ?>
                    <p><span class="consideration-text">Pertimbangan Plh. Sekretaris Daerah</span></p>
                
                <?php endif; ?>
                <div class="double-line"></div>
                <br><br>
            </div>

            <?php if (!(strpos(strtolower($pejabat['jabatan']), 'kepala bidang') !== false || 
                        strpos(strtolower($pejabat['jabatan']), 'kasubbag') !== false)): ?>
            <div class="consideration">
                <div class="double-line"></div>
                <p><span class="consideration-text">Keputusan Bupati Balangan/Wakil Bupati Balangan</span></p>
                <div class="double-line"></div>
                <br><br>
                <div class="single-line"></div>
            </div>
            <?php else: ?>
            <div style="margin-top: 1cm;">
                <div class="single-line"></div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        window.print();
    </script>
</body>
</html> 