<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek apakah ada ID yang dikirim
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id = $_GET['id'];

// Ambil data telaah staf
try {
    $query = "SELECT ts.* 
              FROM telaah_staf ts 
              WHERE ts.id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) == 0) {
        header("Location: index.php");
        exit();
    }

    $data = mysqli_fetch_assoc($result);
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Telaah Staf - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 280px;
            --sidebar-width-collapsed: 70px;
            --transition-speed: 0.3s;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            transition: padding var(--transition-speed) ease;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all var(--transition-speed) ease;
            padding: 2rem;
        }

        body.sidebar-collapsed .container-fluid {
            margin-left: var(--sidebar-width-collapsed);
            width: calc(100% - var(--sidebar-width-collapsed));
        }

        @media (max-width: 768px) {
            .container-fluid {
                margin-left: 0;
                width: 100%;
                padding: 1rem;
            }
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            text-align: center;
            text-transform: uppercase;
        }

        .card {
            background: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            margin-bottom: 2rem;
            position: relative;
            z-index: 1050;
        }

        .card-body {
            padding: 2rem;
            position: relative;
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 1rem;
            color: #1e293b;
            border-bottom: 2px solid rgba(14, 165, 233, 0.1);
            padding-bottom: 0.5rem;
        }

        .detail-item {
            margin-bottom: 1.5rem;
        }

        .detail-label {
            font-weight: 500;
            color: #64748b;
            margin-bottom: 0.5rem;
        }

        .detail-content {
            color: #1e293b;
            white-space: pre-line;
        }

        .action-buttons-wrapper {
            position: relative;
            z-index: 1060;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 1rem;
            flex-wrap: wrap;
        }

        .btn-back {
            background: #e2e8f0;
            border: none;
            color: #475569;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            position: relative;
            z-index: 1060;
        }

        .btn-back:hover {
            background: #cbd5e1;
            color: #1e293b;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-back i {
            font-size: 1.1rem;
            transition: transform 0.3s ease;
        }

        .btn-back:hover i {
            transform: translateX(-3px);
        }

        .status-badge {
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 500;
            font-size: 0.875rem;
        }

        .status-draft { background: #e2e8f0; color: #475569; }
        .status-review { background: #dbeafe; color: #2563eb; }
        .status-approved { background: #dcfce7; color: #16a34a; }
        .status-rejected { background: #fee2e2; color: #dc2626; }

        .meta-info {
            font-size: 0.875rem;
            color: #64748b;
            margin-top: 2rem;
            padding-top: 1rem;
            border-top: 1px solid #e2e8f0;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="container-fluid">
        <div class="header-wrapper">
            <h1>Detail Telaah Staf</h1>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="action-buttons-wrapper">
                    <a href="index.php" class="btn-back">
                        <i class="bi bi-arrow-left"></i>
                        <span>Kembali</span>
                    </a>
                    <?php
                    $status_class = '';
                    switch($data['status']) {
                        case 'draft':
                            $status_class = 'status-draft';
                            $status_text = 'Draft';
                            break;
                        case 'review':
                            $status_class = 'status-review';
                            $status_text = 'Review';
                            break;
                        case 'approved':
                            $status_class = 'status-approved';
                            $status_text = 'Approved';
                            break;
                        case 'rejected':
                            $status_class = 'status-rejected';
                            $status_text = 'Rejected';
                            break;
                        default:
                            $status_class = 'status-draft';
                            $status_text = 'Unknown';
                    }
                    ?>
                    <span class="status-badge <?= $status_class ?>"><?= $status_text ?></span>
                </div>

                <!-- Header Information -->
                <div class="detail-item">
                    <div class="section-title">Informasi Umum</div>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="detail-label">Nomor</div>
                            <div class="detail-content"><?= htmlspecialchars($data['nomor']) ?></div>
                        </div>
                        <div class="col-md-6">
                            <div class="detail-label">Tanggal</div>
                            <div class="detail-content"><?= date('d/m/Y', strtotime($data['tanggal_dibuat'])) ?></div>
                        </div>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-label">Hal</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['perihal'])) ?></div>
                </div>

                <!-- Main Content -->
                <div class="detail-item">
                    <div class="section-title">I. Persoalan</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['persoalan'])) ?></div>
                </div>

                <div class="detail-item">
                    <div class="section-title">II. Pra Anggapan</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['pra_anggapan'])) ?></div>
                </div>

                <div class="detail-item">
                    <div class="section-title">III. Fakta-Fakta yang mempengaruhi</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['fakta_fakta'])) ?></div>
                </div>

                <div class="detail-item">
                    <div class="section-title">IV. Analisis</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['analisis'])) ?></div>
                </div>

                <div class="detail-item">
                    <div class="section-title">V. Kesimpulan</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['kesimpulan'])) ?></div>
                </div>

                <div class="detail-item">
                    <div class="section-title">VI. Saran</div>
                    <div class="detail-content"><?= nl2br(htmlspecialchars($data['saran'])) ?></div>
                </div>

                <div class="meta-info">
                    <div>ID Pembuat: <?= htmlspecialchars($data['created_by']) ?></div>
                    <div>Tanggal dibuat: <?= date('d/m/Y H:i:s', strtotime($data['created_at'])) ?></div>
                    <div>Terakhir diupdate: <?= date('d/m/Y H:i:s', strtotime($data['updated_at'])) ?></div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const body = document.body;
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            
            function updateSidebarState() {
                if (localStorage.getItem('sidebarCollapsed') === 'true') {
                    body.classList.add('sidebar-collapsed');
                } else {
                    body.classList.remove('sidebar-collapsed');
                }
            }
            
            // Initial state
            updateSidebarState();
            
            // Toggle event
            sidebarToggle?.addEventListener('click', function() {
                body.classList.toggle('sidebar-collapsed');
                localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
            });
        });
    </script>
</body>
</html> 