<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek apakah ada ID yang dikirim
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id = $_GET['id'];

// Ambil data telaah staf
try {
    $query = "SELECT * FROM telaah_staf WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) == 0) {
        header("Location: index.php");
        exit();
    }

    $data = mysqli_fetch_assoc($result);

    // Cek level akses
    $isAdminOrPimpinan = in_array($_SESSION['level'], ['admin', 'pimpinan']);
    $isOwner = $data['created_by'] == $_SESSION['user_id'];
    $isDraft = $data['status'] === 'draft';

    // Tentukan akses edit
    $canEdit = false;
    
    // Admin dan pimpinan bisa edit semua
    if ($isAdminOrPimpinan) {
        $canEdit = true;
    }
    // Admin_sppd dan user biasa hanya bisa edit miliknya yang draft
    else if ($isOwner && $isDraft) {
        $canEdit = true;
    }

    if (!$canEdit) {
        $_SESSION['error'] = "Anda tidak memiliki akses untuk mengedit telaah staf ini.";
        header("Location: detail.php?id=" . $id);
        exit();
    }
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}

// Fungsi untuk memproses konten sebelum disimpan
function processContent($content) {
    if (empty($content)) {
        return '';
    }
    
    // Simpan konten HTML apa adanya, hanya bersihkan whitespace berlebih
    $content = trim($content);
    return $content;
}

// Proses form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $nomor = mysqli_real_escape_string($conn, $_POST['nomor']);
    $tanggal = mysqli_real_escape_string($conn, $_POST['tanggal']);
    $perihal = mysqli_real_escape_string($conn, $_POST['hal']);
    $kepada = mysqli_real_escape_string($conn, $_POST['kepada']);
    $dari = mysqli_real_escape_string($conn, $_POST['dari']);
    
    // Proses konten dari editor
    $persoalan = processContent($_POST['persoalan']);
    $pra_anggapan = processContent($_POST['pra_anggapan']);
    $fakta_fakta = processContent($_POST['fakta_fakta']);
    $analisis = processContent($_POST['analisis']);
    $kesimpulan = processContent($_POST['kesimpulan']);
    $saran = processContent($_POST['saran']);

    try {
        $query = "UPDATE telaah_staf SET 
                  nomor = ?, 
                  tanggal_dibuat = ?, 
                  perihal = ?, 
                  kepada = ?, 
                  dari = ?, 
                  persoalan = ?, 
                  pra_anggapan = ?, 
                  fakta_fakta = ?, 
                  analisis = ?, 
                  kesimpulan = ?, 
                  saran = ?, 
                  keterangan_biaya = ?,
                  updated_at = CURRENT_TIMESTAMP 
                  WHERE id = ?";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "ssssssssssssi", 
            $nomor, $tanggal, $perihal, $kepada, $dari, $persoalan, 
            $pra_anggapan, $fakta_fakta, $analisis, $kesimpulan, $saran, 
            $_POST['keterangan_biaya'], $id);
        
        if (mysqli_stmt_execute($stmt)) {
            header("Location: detail.php?id=" . $id);
            exit();
        } else {
            throw new Exception("Gagal mengupdate data");
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Telaah Staf - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <!-- Summernote CSS -->
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 200px;
            --sidebar-width-collapsed: 70px;
            --transition-speed: 0.3s;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            transition: padding var(--transition-speed) ease;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all var(--transition-speed) ease;
            padding: 2rem;
        }

        /* Sidebar collapsed state */
        body.sidebar-collapsed .container-fluid {
            margin-left: var(--sidebar-width-collapsed);
            width: calc(100% - var(--sidebar-width-collapsed));
        }

        .sidebar-wrapper {
            position: fixed;
            left: 0;
            top: 0;
            height: 100%;
            width: var(--sidebar-width);
            transition: width var(--transition-speed) ease;
        }

        .sidebar-wrapper.collapsed {
            width: var(--sidebar-width-collapsed);
        }

        /* Toggle button styles */
        .sidebar-toggle {
            position: absolute;
            right: -15px;
            top: 70px;
            width: 30px;
            height: 30px;
            background: #224abe;
            border: 2px solid #ffffff;
            border-radius: 50%;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            z-index: 1050;
            transition: transform var(--transition-speed) ease;
        }

        .sidebar-toggle:hover {
            transform: scale(1.1);
        }

        .sidebar-wrapper.collapsed .sidebar-toggle i {
            transform: rotate(180deg);
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            text-align: center;
            text-transform: uppercase;
        }

        .card {
            background: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            margin-bottom: 2rem;
            position: relative;
            z-index: 1050;
        }

        .card-body {
            padding: 2rem;
            position: relative;
        }

        .form-label {
            font-weight: 500;
            color: #64748b;
        }

        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 0.75rem;
            transition: all 0.3s ease;
        }

        .form-control:focus, .form-select:focus {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }

        textarea.form-control {
            min-height: 120px;
        }

        .btn-primary {
            background: var(--primary-gradient);
            border: none;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
        }

        .btn-back {
            background: #e2e8f0;
            border: none;
            color: #475569;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            position: relative;
            z-index: 1060;
            margin-bottom: 1rem;
        }

        .btn-back:hover {
            background: #cbd5e1;
            color: #1e293b;
            transform: translateY(-1px);
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }

        .btn-back i {
            font-size: 1.1rem;
            transition: transform 0.3s ease;
        }

        .btn-back:hover i {
            transform: translateX(-3px);
        }

        /* Penyesuaian untuk tampilan mobile */
        @media (max-width: 768px) {
            .btn-back {
                padding: 0.6rem 1.2rem;
                font-size: 0.95rem;
            }
        }

        .section-title {
            font-weight: bold;
            margin-bottom: 1rem;
            color: #1e293b;
            border-bottom: 2px solid rgba(14, 165, 233, 0.1);
            padding-bottom: 0.5rem;
        }

        /* Summernote Custom Styles */
        .note-editor {
            margin-bottom: 1rem;
        }
        .note-editor.note-frame {
            border-radius: 8px;
            border-color: #e2e8f0;
        }
        .note-editor.note-frame:focus-within {
            border-color: #0ea5e9;
            box-shadow: 0 0 0 3px rgba(14, 165, 233, 0.1);
        }
        .note-toolbar {
            background: #f8fafc;
            border-radius: 8px 8px 0 0;
            border-bottom-color: #e2e8f0;
        }
        .note-statusbar {
            border-radius: 0 0 8px 8px;
        }

        .action-buttons-wrapper {
            position: relative;
            z-index: 1060;
            margin-bottom: 1.5rem;
            display: flex;
            align-items: center;
            gap: 1rem;
            flex-wrap: wrap;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="container-fluid">
        <div class="header-wrapper">
            <h1>Edit Telaah Staf</h1>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="action-buttons-wrapper">
                    <a href="detail.php?id=<?= $id ?>" class="btn-back">
                        <i class="bi bi-arrow-left"></i>
                        <span>Kembali</span>
                    </a>
                </div>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger" role="alert">
                        <?= $error ?>
                    </div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="nomor" class="form-label">Nomor</label>
                                <input type="text" class="form-control" id="nomor" name="nomor" value="<?= htmlspecialchars($data['nomor'] ?? '', ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="tanggal" class="form-label">Tanggal</label>
                                <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?= $data['tanggal_dibuat'] ?? '' ?>" required>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <!-- Status field removed -->
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="hal" class="form-label">Hal</label>
                        <input type="text" class="form-control" id="hal" name="hal" value="<?= htmlspecialchars($data['perihal'] ?? '', ENT_QUOTES, 'UTF-8') ?>" required>
                    </div>

                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="kepada" class="form-label">Kepada</label>
                                <input type="text" class="form-control" id="kepada" name="kepada" value="<?= htmlspecialchars($data['kepada'] ?? '', ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="dari" class="form-label">Dari</label>
                                <input type="text" class="form-control" id="dari" name="dari" value="<?= htmlspecialchars($data['dari'] ?? '', ENT_QUOTES, 'UTF-8') ?>" required>
                            </div>
                        </div>
                    </div>

                    <div class="mb-4">
                        <label for="persoalan" class="form-label">I. Persoalan</label>
                        <textarea class="form-control summernote" id="persoalan" name="persoalan" required><?= $data['persoalan'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="pra_anggapan" class="form-label">II. Pra Anggapan</label>
                        <textarea class="form-control summernote" id="pra_anggapan" name="pra_anggapan" required><?= $data['pra_anggapan'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="fakta_fakta" class="form-label">III. Fakta-Fakta</label>
                        <textarea class="form-control summernote" id="fakta_fakta" name="fakta_fakta" required><?= $data['fakta_fakta'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="analisis" class="form-label">IV. Analisis</label>
                        <textarea class="form-control summernote" id="analisis" name="analisis" required><?= $data['analisis'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="kesimpulan" class="form-label">V. Kesimpulan</label>
                        <textarea class="form-control summernote" id="kesimpulan" name="kesimpulan" required><?= $data['kesimpulan'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label for="saran" class="form-label">VI. Saran</label>
                        <textarea class="form-control summernote" id="saran" name="saran" required><?= $data['saran'] ?? '' ?></textarea>
                    </div>

                    <div class="mb-4">
                        <label class="form-label">Keterangan Biaya</label>
                        <textarea class="form-control" name="keterangan_biaya" rows="2" 
                            placeholder="Contoh: Biaya perjalanan dinas di atas dibebankan pada DPA masing-masing SKPD Tahun Anggaran 2025."
                        ><?= $data['keterangan_biaya'] ?? '' ?></textarea>
                        <small class="text-muted">Masukkan keterangan mengenai pembiayaan perjalanan dinas</small>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="detail.php?id=<?= $id ?>" class="btn btn-secondary">Batal</a>
                        <button type="submit" class="btn btn-primary">Simpan Perubahan</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- Summernote JS -->
    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
    <script>
        $(document).ready(function() {
            // Handle sidebar toggle state
            const sidebarWrapper = document.querySelector('.sidebar-wrapper');
            const sidebarToggle = document.querySelector('.sidebar-toggle');
            
            function updateSidebarState() {
                const sidebarCollapsed = localStorage.getItem('sidebarCollapsed') === 'true';
                if (sidebarCollapsed) {
                    document.body.classList.add('sidebar-collapsed');
                    sidebarWrapper.classList.add('collapsed');
                } else {
                    document.body.classList.remove('sidebar-collapsed');
                    sidebarWrapper.classList.remove('collapsed');
                }
            }

            // Initial state
            updateSidebarState();

            // Toggle event
            sidebarToggle?.addEventListener('click', function() {
                document.body.classList.toggle('sidebar-collapsed');
                sidebarWrapper.classList.toggle('collapsed');
                localStorage.setItem('sidebarCollapsed', document.body.classList.contains('sidebar-collapsed'));
            });

            // Listen for storage events from other tabs/windows
            window.addEventListener('storage', function(e) {
                if (e.key === 'sidebarCollapsed') {
                    updateSidebarState();
                }
            });

            // Summernote initialization
            $('.summernote').each(function() {
                $(this).summernote({
                    placeholder: 'Tulis di sini...',
                    tabsize: 2,
                    height: 200,
                    toolbar: [
                        ['style', ['style']],
                        ['font', ['bold', 'underline', 'italic', 'clear']],
                        ['fontsize', ['fontsize']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['table', ['table']],
                        ['insert', ['link']],
                        ['view', ['fullscreen', 'codeview', 'help']]
                    ],
                    callbacks: {
                        onInit: function() {
                            // Gunakan mode paragraf untuk menjaga line breaks
                            $(this).summernote('styleWithSpan', false);
                            $(this).summernote('fontSize', 16);
                        },
                        onChange: function(contents, $editable) {
                            // Pastikan setiap line break diubah menjadi paragraf
                            if (!contents.match(/<\/p>/g)) {
                                var lines = contents.split(/\n/);
                                contents = lines.map(line => `<p>${line}</p>`).join('');
                                $(this).summernote('code', contents);
                            }
                        },
                        onPaste: function(e) {
                            e.preventDefault();
                            // Dapatkan teks yang di-paste
                            var text = ((e.originalEvent || e).clipboardData || window.clipboardData).getData('Text');
                            // Ubah line breaks menjadi paragraf
                            var lines = text.split(/\n/);
                            var formattedText = lines.map(line => `<p>${line}</p>`).join('');
                            // Masukkan teks yang sudah diformat
                            document.execCommand('insertHTML', false, formattedText);
                        }
                    },
                    styleTags: ['p', 'pre', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6'],
                    lineHeight: 1.5,
                    stylePara: {
                        'margin': '0 0 10px'
                    }
                });
            });
        });
    </script>
</body>
</html> 