<?php
require_once '../config/config.php';
require_once '../config/database.php';

header('Content-Type: application/json');

if (!isset($_GET['id_pejabat'])) {
    echo json_encode(['error' => 'ID Pejabat tidak ditemukan']);
    exit;
}

$id_pejabat = $_GET['id_pejabat'];

try {
    $query = "SELECT nama, nip, jabatan, pangkat 
             FROM pejabat_daerah 
             WHERE id_pejabat = ?";
             
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id_pejabat);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if ($row = mysqli_fetch_assoc($result)) {
        echo json_encode($row);
    } else {
        echo json_encode(['error' => 'Data pejabat tidak ditemukan']);
    }
} catch (Exception $e) {
    echo json_encode(['error' => 'Terjadi kesalahan: ' . $e->getMessage()]);
}
?> 