<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

if (isset($_GET['id'])) {
    $id = $_GET['id'];
    
    try {
        // Cek apakah user memiliki akses untuk menghapus
        $query = "SELECT * FROM telaah_staf WHERE id = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $telaah = mysqli_fetch_assoc($result);
        
        if (!$telaah) {
            throw new Exception("Telaah staf tidak ditemukan");
        }
        
        // Cek hak akses
        $isAdminOrPimpinan = in_array($_SESSION['level'], ['admin', 'pimpinan']);
        $isOwner = $telaah['created_by'] == $_SESSION['user_id'];
        
        if (!$isAdminOrPimpinan && !$isOwner) {
            throw new Exception("Anda tidak memiliki akses untuk menghapus telaah staf ini");
        }
        
        // Hapus file yang diupload jika ada
        if (!empty($telaah['signed_file'])) {
            $file_path = "../uploads/signed_telaah/" . $telaah['signed_file'];
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }
        
        // Hapus data dari database
        $query = "DELETE FROM telaah_staf WHERE id = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $id);
        
        if (mysqli_stmt_execute($stmt)) {
            $_SESSION['success'] = "Telaah staf berhasil dihapus";
        } else {
            throw new Exception("Gagal menghapus telaah staf");
        }
        
    } catch (Exception $e) {
        $_SESSION['error'] = $e->getMessage();
    }
}

header("Location: index.php");
exit();
?> 