<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

try {
    // Cek koneksi sebelum query
    $conn = check_connection($conn);
    
    // Get user's bidang if admin_sppd or pimpinan
    $user_bidang = '';
    if ($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') {
        $user_id = $_SESSION['user_id'];
        $query_user = "SELECT bidang FROM users WHERE id = ?";
        $stmt = mysqli_prepare($conn, $query_user);
        mysqli_stmt_bind_param($stmt, "i", $user_id);
        mysqli_stmt_execute($stmt);
        $result_user = mysqli_stmt_get_result($stmt);
        if ($user_data = mysqli_fetch_assoc($result_user)) {
            $user_bidang = $user_data['bidang'];
        }
    }
    
    // Base query untuk telaah staf
    $query = "SELECT * FROM telaah_staf";
    
    // Add WHERE clause for admin_sppd and pimpinan
    if (($_SESSION['level'] === 'admin_sppd' || $_SESSION['level'] === 'pimpinan') && !empty($user_bidang)) {
        $query .= " WHERE created_by IN (SELECT id FROM users WHERE bidang = ?)";
        $query .= " ORDER BY tanggal_dibuat DESC, id DESC";
        
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "s", $user_bidang);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
    } else {
        $query .= " ORDER BY tanggal_dibuat DESC, id DESC";
        $result = mysqli_query($conn, $query);
    }
    
    if (!$result) {
        throw new Exception("Error executing query: " . mysqli_error($conn));
    }
} catch (Exception $e) {
    echo "<div class='alert alert-danger'>Terjadi kesalahan: " . $e->getMessage() . "</div>";
    error_log($e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Telaah Staf - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEgyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjhoMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 280px;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all 0.3s ease;
            padding: 2rem;
        }

        body.sidebar-collapsed .container-fluid {
            margin-left: 25px;
            width: calc(100% - 25px);
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
            position: relative;
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
        }

        .header-wrapper p {
            color: rgba(255, 255, 255, 0.8);
            margin-bottom: 1rem;
        }

        .header-wrapper .breadcrumb-item a {
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
        }

        .header-wrapper .breadcrumb-item.active {
            color: white;
        }

        .header-wrapper .breadcrumb-item + .breadcrumb-item::before {
            color: rgba(255, 255, 255, 0.5);
        }

        .btn-buat-telaah {
            position: absolute;
            right: 2rem;
            top: 50%;
            transform: translateY(-50%);
            background: white;
            color: #0ea5e9;
            padding: 0.5rem 1rem;
            border-radius: 8px;
            font-weight: 500;
            text-decoration: none;
            transition: all 0.2s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-buat-telaah:hover {
            background: rgba(255, 255, 255, 0.9);
            transform: translateY(-50%) translateX(-2px);
        }

        .card {
            background: white;
            backdrop-filter: blur(10px);
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            overflow: hidden;
            margin-bottom: 2rem;
        }

        .card-body {
            padding: 0;
        }

        .table {
            margin-bottom: 0;
            border-collapse: separate;
            border-spacing: 0;
            width: 100%;
            table-layout: fixed;
        }

        .table thead th {
            background: var(--primary-gradient) !important;
            color: white;
            font-weight: 600;
            padding: 1rem !important;
            border: none;
            text-transform: uppercase;
            font-size: 0.85rem;
            letter-spacing: 0.5px;
        }

        .table thead th:first-child {
            width: 60px;
            border-top-left-radius: 15px;
            text-align: center;
        }

        .table thead th:nth-child(2) {
            width: 150px;
        }

        .table thead th:nth-child(3) {
            width: auto;
        }

        .table thead th:nth-child(4) {
            width: 140px;
        }

        .table thead th:last-child {
            width: 140px;
            border-top-right-radius: 15px;
        }

        .table tbody td {
            padding: 1rem !important;
            vertical-align: middle;
            border: none;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-size: 0.9rem;
            color: #2c3e50;
        }

        /* Pembuat column specific styling */
        .table tbody td:nth-child(4) {
            font-size: 0.85rem;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 140px;
        }

        /* Action column specific styling */
        .table tbody td:last-child {
            padding: 0.5rem !important;
            min-width: 140px;
        }

        .table tbody tr:last-child td {
            border-bottom: none;
        }

        .table tbody tr:hover td {
            background-color: rgba(14, 165, 233, 0.04);
            transition: background-color 0.2s ease;
        }

        .btn-soft-info, 
        .btn-soft-warning,
        .btn-soft-danger {
            padding: 0.5rem;
            border-radius: 6px;
            font-size: 0.85rem;
            transition: all 0.3s ease;
        }

        .btn-soft-info {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
        }

        .btn-soft-warning {
            background: rgba(234, 179, 8, 0.1);
            color: #ea580c;
        }

        .btn-soft-danger {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }

        .btn-soft-info:hover,
        .btn-soft-warning:hover,
        .btn-soft-danger:hover {
            background: var(--primary-gradient);
            color: white;
            transform: translateY(-2px);
        }

        .text-wrap {
            white-space: normal;
            word-wrap: break-word;
            width: 100%;
            line-height: 1.5;
            padding-right: 10px;
        }

        .badge {
            padding: 0.5em 0.75em;
            border-radius: 6px;
            font-weight: 500;
            font-size: 0.75rem;
        }

        .badge.bg-secondary { background-color: #6c757d !important; }
        .badge.bg-primary { background-color: #0ea5e9 !important; }
        .badge.bg-success { background-color: #22c55e !important; }
        .badge.bg-danger { background-color: #ef4444 !important; }

        .empty-state {
            text-align: center;
            padding: 2rem;
            color: #6c757d;
        }

        .empty-state i {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        /* DataTables Customization */
        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            border: 1px solid rgba(0, 0, 0, 0.1);
            border-radius: 8px;
            padding: 0.5rem;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button.current {
            background: var(--primary-gradient) !important;
            border: none;
            color: white !important;
        }

        .btn-soft-primary {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
        }

        .btn-soft-primary:hover {
            background: var(--primary-gradient);
            color: white;
            transform: translateY(-2px);
        }

        .dropdown-menu {
            padding: 0.5rem;
            border: none;
            box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1);
            border-radius: 8px;
        }

        .dropdown-item {
            padding: 0.5rem 1rem;
            border-radius: 6px;
            font-size: 0.9rem;
            color: #2c3e50;
            transition: all 0.2s ease;
        }

        .dropdown-item:hover {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
        }

        .dropdown-item.text-danger:hover {
            background: rgba(239, 68, 68, 0.1);
            color: #ef4444;
        }

        .dropdown-divider {
            margin: 0.5rem 0;
            border-color: rgba(0, 0, 0, 0.05);
        }

        .btn-soft-primary.dropdown-toggle {
            background: rgba(14, 165, 233, 0.1);
            color: #0ea5e9;
            border: none;
            padding: 0.5rem 1rem;
        }

        .btn-soft-primary.dropdown-toggle:hover,
        .btn-soft-primary.dropdown-toggle:focus {
            background: var(--primary-gradient);
            color: white;
        }

        .dropdown-item i {
            font-size: 1rem;
        }

        /* Specific styling for HAL column cells */
        .table tbody td:nth-child(3) {
            max-width: none;
            width: auto;
            padding-right: 20px !important;
        }

        .table tbody td:nth-child(3) .text-wrap {
            display: block;
            width: 100%;
        }

        /* Action Buttons Styling */
        .action-buttons {
            display: grid;
            grid-template-rows: auto auto;
            gap: 0.75rem;
            justify-content: start;
            min-width: 120px;
            padding: 0.5rem;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .action-buttons:hover {
            background: rgba(255, 255, 255, 0.8);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }

        .action-group {
            display: flex;
            gap: 0.75rem;
            align-items: center;
            position: relative;
        }

        .action-group::after {
            content: '';
            position: absolute;
            bottom: -0.375rem;
            left: 0;
            right: 0;
            height: 1px;
            background: linear-gradient(to right, transparent, rgba(14, 165, 233, 0.2), transparent);
            opacity: 0;
            transition: opacity 0.3s ease;
        }

        .action-buttons:hover .action-group:first-child::after {
            opacity: 1;
        }

        .btn-action {
            width: 34px;
            height: 34px;
            padding: 0;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            border-radius: 8px;
            border: none;
            background: transparent;
            color: #64748b;
            transition: all 0.3s ease;
            cursor: pointer;
            position: relative;
            overflow: hidden;
        }

        .btn-action::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: currentColor;
            opacity: 0;
            transition: opacity 0.3s ease;
            z-index: 0;
        }

        .btn-action i {
            font-size: 1.1rem;
            position: relative;
            z-index: 1;
            transition: all 0.3s ease;
        }

        .btn-action:hover {
            color: #0ea5e9;
            transform: translateY(-2px);
            background: rgba(14, 165, 233, 0.1);
        }

        .btn-action:hover i {
            transform: scale(1.1);
        }

        .btn-action.text-danger:hover {
            color: #ef4444;
            background: rgba(239, 68, 68, 0.1);
        }

        /* Tooltip styling */
        .btn-action::after {
            content: attr(title);
            position: absolute;
            bottom: 100%;
            left: 50%;
            transform: translateX(-50%) translateY(8px);
            background: #1e293b;
            color: white;
            padding: 0.5rem 0.75rem;
            border-radius: 6px;
            font-size: 0.75rem;
            white-space: nowrap;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
            z-index: 10;
        }

        .btn-action:hover::after {
            opacity: 1;
            visibility: visible;
            transform: translateX(-50%) translateY(0);
        }

        /* Custom hover effects for specific actions */
        .btn-action[title="Detail"]:hover i { color: #0ea5e9; }
        .btn-action[title="Cetak"]:hover i { color: #0ea5e9; }
        .btn-action[title="Lihat PDF"]:hover i { color: #ef4444; }
        .btn-action[title="Upload File"]:hover i,
        .btn-action[title="Ganti File"]:hover i { color: #22c55e; }
        .btn-action[title="Edit"]:hover i { color: #f59e0b; }
        .btn-action[title="Hapus"]:hover i { color: #ef4444; }

        /* Responsive Fixes */
        @media screen and (max-width: 1366px) {
            .container-fluid {
                margin-left: 0;
                width: 100%;
                padding: 1rem;
            }

            .header-wrapper {
                padding: 1.5rem;
            }

            .btn-buat-telaah {
                position: relative;
                right: auto;
                top: auto;
                transform: none;
                margin-top: 1rem;
                display: inline-flex;
            }

            .table thead th {
                white-space: nowrap;
            }

            .table thead th:first-child {
                width: 50px;
            }

            .table thead th:nth-child(2) {
                width: 120px;
            }

            .table thead th:last-child {
                width: 120px;
            }

            .action-buttons {
                min-width: auto;
                grid-template-columns: repeat(2, 1fr);
                grid-template-rows: none;
                gap: 0.25rem;
            }

            .action-group {
                gap: 0.25rem;
            }

            .btn-action {
                width: 30px;
                height: 30px;
            }
        }

        @media screen and (max-width: 1024px) {
            .container-fluid {
                padding: 0.75rem;
            }

            .card {
                margin-bottom: 1rem;
            }

            .table-responsive {
                overflow-x: auto;
                -webkit-overflow-scrolling: touch;
            }

            .table {
                width: 100%;
                min-width: 800px;
            }

            .table td {
                white-space: normal;
            }

            .table td:nth-child(3) {
                min-width: 200px;
            }

            .action-buttons {
                display: flex;
                flex-wrap: wrap;
                gap: 0.25rem;
                justify-content: flex-start;
            }

            .action-group {
                display: flex;
                gap: 0.25rem;
            }

            .btn-action {
                padding: 0.25rem;
            }

            .header-wrapper {
                flex-direction: column;
                align-items: flex-start;
            }

            .breadcrumb {
                margin-bottom: 1rem;
            }
        }

        /* Additional fixes for smaller screens */
        @media screen and (max-width: 768px) {
            .container-fluid {
                padding: 1rem;
            }

            .header-wrapper {
                padding: 1rem;
                margin-bottom: 1rem;
            }

            .header-wrapper h1 {
                font-size: 1.25rem;
            }

            .table {
                min-width: 650px;
            }

            .action-buttons {
                padding: 0.25rem;
            }

            .btn-action {
                width: 28px;
                height: 28px;
            }

            .btn-action i {
                font-size: 0.9rem;
            }

            /* DataTables responsive fixes */
            .dataTables_wrapper .dataTables_length,
            .dataTables_wrapper .dataTables_filter {
                float: none;
                text-align: left;
                margin-bottom: 0.5rem;
            }

            .dataTables_wrapper .dataTables_paginate {
                float: none;
                text-align: center;
                margin-top: 0.5rem;
            }
        }

        /* Fix for DataTables controls */
        .dataTables_wrapper {
            padding: 1rem;
        }

        .dataTables_wrapper .dataTables_length select,
        .dataTables_wrapper .dataTables_filter input {
            margin: 0 0.5rem;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button {
            padding: 0.3rem 0.6rem;
            margin: 0 0.2rem;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="container-fluid">
        <div class="header-wrapper">
            <h1>Telaah Staf</h1>
            <p>Daftar telaah staf yang telah dibuat</p>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="../dashboard.php">Dashboard</a></li>
                    <li class="breadcrumb-item active">Telaah Staf</li>
                </ol>
            </nav>
            <a href="buat_telaah.php" class="btn-buat-telaah">
                <i class="bi bi-plus-lg"></i>
                Buat Telaah Baru
            </a>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table" id="telaahStafTable">
                        <thead>
                            <tr>
                                <th class="text-center">NO.</th>
                                <th>NOMOR TELAAH STAF</th>
                                <th>PERIHAL</th>
                                <th>PEMBUAT</th>
                                <th>AKSI</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                            $no = 1;
                            while ($row = mysqli_fetch_assoc($result)): 
                                // Get pembuat name
                                $query_pembuat = "SELECT nama_lengkap FROM users WHERE id = ?";
                                $stmt_pembuat = mysqli_prepare($conn, $query_pembuat);
                                mysqli_stmt_bind_param($stmt_pembuat, "i", $row['created_by']);
                                mysqli_stmt_execute($stmt_pembuat);
                                $result_pembuat = mysqli_stmt_get_result($stmt_pembuat);
                                $pembuat = mysqli_fetch_assoc($result_pembuat);
                            ?>
                            <tr>
                                <td class="text-center"><?= $no++ ?></td>
                                <td><?= htmlspecialchars($row['nomor']) ?></td>
                                <td>
                                    <div class="text-wrap">
                                        <?= nl2br(htmlspecialchars($row['perihal'])) ?>
                                    </div>
                                </td>
                                <td><?= htmlspecialchars($pembuat['nama_lengkap'] ?? 'Unknown') ?></td>
                                <td>
                                    <div class="action-buttons">
                                        <div class="action-group">
                                            <a href="detail.php?id=<?= $row['id'] ?>" 
                                               class="btn-action" 
                                               title="Detail">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            
                                            <a href="konfirmasi_cetak.php?id=<?= $row['id'] ?>" 
                                               class="btn-action" 
                                               title="Cetak">
                                                <i class="bi bi-printer"></i>
                                            </a>

                                            <?php if (!empty($row['signed_file'])): ?>
                                            <a href="../uploads/signed_telaah/<?= htmlspecialchars($row['signed_file']) ?>"
                                               class="btn-action"
                                               target="_blank"
                                               title="Lihat PDF">
                                                <i class="bi bi-file-pdf"></i>
                                            </a>
                                            <?php endif; ?>
                                        </div>

                                        <div class="action-group">
                                            <a href="#" 
                                               onclick="showUploadModal(<?= $row['id'] ?>, '<?= !empty($row['signed_file']) ? htmlspecialchars($row['signed_file']) : '' ?>'); return false;"
                                               class="btn-action"
                                               title="<?= !empty($row['signed_file']) ? 'Ganti File' : 'Upload File' ?>">
                                                <i class="bi bi-<?= !empty($row['signed_file']) ? 'arrow-repeat' : 'upload' ?>"></i>
                                            </a>

                                            <?php if ($_SESSION['level'] === 'admin' || $_SESSION['level'] === 'pimpinan' || 
                                                    ($_SESSION['level'] === 'admin_sppd' && $_SESSION['user_id'] === $row['created_by'])): ?>
                                            <a href="edit.php?id=<?= $row['id'] ?>"
                                               class="btn-action"
                                               title="Edit">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            
                                            <a href="#" 
                                               onclick="hapusTelaah(<?= $row['id'] ?>); return false;"
                                               class="btn-action text-danger"
                                               title="Hapus">
                                                <i class="bi bi-trash"></i>
                                            </a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                            <?php if (mysqli_num_rows($result) == 0): ?>
                            <tr>
                                <td colspan="5" class="empty-state">
                                    <i class="bi bi-inbox"></i>
                                    <p class="mb-0">Tidak ada data telaah staf tersedia</p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Upload Modal -->
    <div class="modal fade" id="uploadModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Upload File Tertandatangan</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <form action="upload_signed.php" method="POST" enctype="multipart/form-data">
                    <div class="modal-body">
                        <input type="hidden" name="telaah_id" id="uploadTelaahId">
                        
                        <!-- Current File Info -->
                        <div id="currentFileInfo" class="alert alert-info mb-3" style="display: none;">
                            <small><i class="bi bi-info-circle me-2"></i>File yang sudah diupload sebelumnya:</small>
                            <div id="currentFileName" class="mt-1 fw-bold"></div>
                            <small class="text-muted">File baru yang diupload akan menggantikan file lama.</small>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">File Telaah Staf (PDF)</label>
                            <input type="file" class="form-control" name="signed_file" accept=".pdf" required>
                            <div class="form-text">Upload file telaah staf yang sudah ditandatangani dalam format PDF</div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary" id="uploadButton">Upload</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
    $(document).ready(function() {
        $('#telaahStafTable').DataTable({
            "responsive": true,
            "lengthMenu": [[10, 25, 50, -1], [10, 25, 50, "Semua"]],
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Indonesian.json"
            }
        });
    });

    function hapusTelaah(id) {
        Swal.fire({
            title: 'Konfirmasi Hapus',
            text: "Apakah Anda yakin ingin menghapus telaah staf ini?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'Ya, Hapus!',
            cancelButtonText: 'Batal'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = `hapus.php?id=${id}`;
            }
        });
    }

    function showUploadModal(id, currentFile = '') {
        document.getElementById('uploadTelaahId').value = id;
        
        // Handle current file info display
        const currentFileInfo = document.getElementById('currentFileInfo');
        const currentFileName = document.getElementById('currentFileName');
        const uploadButton = document.getElementById('uploadButton');
        
        if (currentFile) {
            currentFileInfo.style.display = 'block';
            currentFileName.textContent = currentFile;
            uploadButton.textContent = 'Ganti File';
        } else {
            currentFileInfo.style.display = 'none';
            currentFileName.textContent = '';
            uploadButton.textContent = 'Upload';
        }
        
        new bootstrap.Modal(document.getElementById('uploadModal')).show();
    }

    <?php if (isset($_SESSION['success'])): ?>
    Swal.fire({
        icon: 'success',
        title: 'Berhasil!',
        text: <?= json_encode($_SESSION['success']) ?>,
    });
    <?php unset($_SESSION['success']); endif; ?>

    <?php if (isset($_SESSION['error'])): ?>
    Swal.fire({
        icon: 'error',
        title: 'Error!',
        text: <?= json_encode($_SESSION['error']) ?>,
    });
    <?php unset($_SESSION['error']); endif; ?>

    document.addEventListener('DOMContentLoaded', function() {
        const body = document.body;
        const sidebarToggle = document.querySelector('.sidebar-toggle');
        
        function updateSidebarState() {
            if (localStorage.getItem('sidebarCollapsed') === 'true') {
                body.classList.add('sidebar-collapsed');
            } else {
                body.classList.remove('sidebar-collapsed');
            }
        }
        
        // Initial state
        updateSidebarState();
        
        // Toggle event
        sidebarToggle?.addEventListener('click', function() {
            body.classList.toggle('sidebar-collapsed');
            localStorage.setItem('sidebarCollapsed', body.classList.contains('sidebar-collapsed'));
        });
    });
    </script>
</body>
</html> 