<?php
session_start();
require_once '../config/config.php';
require_once '../config/database.php';

// Cek apakah user sudah login
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

// Cek apakah ada ID yang dikirim
if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit();
}

$id = $_GET['id'];

// Ambil data telaah staf
try {
    $query = "SELECT * FROM telaah_staf WHERE id = ?";
    $stmt = mysqli_prepare($conn, $query);
    mysqli_stmt_bind_param($stmt, "i", $id);
    mysqli_stmt_execute($stmt);
    $result = mysqli_stmt_get_result($stmt);
    
    if (mysqli_num_rows($result) == 0) {
        header("Location: index.php");
        exit();
    }

    $data = mysqli_fetch_assoc($result);
    
} catch (Exception $e) {
    die("Error: " . $e->getMessage());
}

// Proses upload file
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    try {
        // Cek apakah ada file yang diupload
        if (!isset($_FILES['file_telaah']) || $_FILES['file_telaah']['error'] === UPLOAD_ERR_NO_FILE) {
            throw new Exception("Silakan pilih file untuk diunggah.");
        }

        $file = $_FILES['file_telaah'];
        $fileName = $file['name'];
        $fileType = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
        
        // Validasi tipe file
        if ($fileType !== 'pdf') {
            throw new Exception("Hanya file PDF yang diperbolehkan.");
        }

        // Validasi ukuran file (maksimal 5MB)
        if ($file['size'] > 5 * 1024 * 1024) {
            throw new Exception("Ukuran file tidak boleh lebih dari 5MB.");
        }

        // Buat direktori jika belum ada
        $uploadDir = "../uploads/telaah_staf/";
        if (!file_exists($uploadDir)) {
            mkdir($uploadDir, 0777, true);
        }

        // Generate nama file unik
        $newFileName = 'telaah_' . $id . '_' . date('YmdHis') . '.' . $fileType;
        $targetPath = $uploadDir . $newFileName;

        // Hapus file lama jika ada
        if (!empty($data['file_path'])) {
            $oldFile = $uploadDir . $data['file_path'];
            if (file_exists($oldFile)) {
                unlink($oldFile);
            }
        }

        // Upload file
        if (move_uploaded_file($file['tmp_name'], $targetPath)) {
            // Update database
            $query = "UPDATE telaah_staf SET file_path = ? WHERE id = ?";
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "si", $newFileName, $id);
            
            if (mysqli_stmt_execute($stmt)) {
                $_SESSION['success'] = "File berhasil diunggah.";
                header("Location: detail.php?id=" . $id);
                exit();
            } else {
                throw new Exception("Gagal menyimpan data file ke database.");
            }
        } else {
            throw new Exception("Gagal mengunggah file.");
        }
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload File Telaah Staf - SPPD System</title>
    <link rel="icon" type="image/svg+xml" href="data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNCAyNCI+PHBhdGggZmlsbD0iIzRlNzNkZiIgZD0iTTIwLDhINFY2aDIwdjJIMjB6IE0xNSwxMEg0djJoMTFWMTB6IE00LDE2aDd2Mkg0VjE2eiBNMjEuNywxMy4zTDIwLjMsMTJsMS40LTEuNEMyMi4xLDEwLjIsMjIuMSw5LjgsMjEuNyw5LjRsLTEuMS0xLjFDMjAuMiw3LjksMTkuOCw3LjksMTkuNCw4LjNMMTgsMTBsLTEuNC0xLjRjLTAuNC0wLjQtMS0wLjQtMS40LDBsLTcuNSw3LjVjLTAuMiwwLjItMC4zLDAuNC0wLjMsMC43djIuOWMwLDAuNSwwLjQsMC45LDAuOSwwLjloMi45YzAuMywwLDAuNS0wLjEsMC43LTAuM2w3LjUtNy41QzIyLjEsMTQuMywyMi4xLDEzLjcsMjEuNywxMy4zeiIvPjwvc3ZnPg==">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <style>
        :root {
            --primary-gradient: linear-gradient(135deg, #0ea5e9 0%, #2dd4bf 100%);
            --bg-gradient: linear-gradient(135deg, rgb(245, 255, 254) 0%, rgb(153, 224, 238) 100%);
            --sidebar-width: 200px;
        }

        body {
            background: var(--bg-gradient) !important;
            font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }

        .container-fluid {
            background: transparent !important;
            position: relative;
            margin-left: var(--sidebar-width);
            width: calc(100% - var(--sidebar-width));
            min-height: 100vh;
            transition: all 0.3s ease;
            padding: 2rem;
        }

        .header-wrapper {
            background: var(--primary-gradient);
            padding: 2rem;
            border-radius: 15px;
            margin-bottom: 2rem;
            box-shadow: 0 4px 15px rgba(78,115,223,0.1);
        }

        .header-wrapper h1 {
            color: white;
            font-size: 1.5rem;
            font-weight: 600;
            margin-bottom: 0.5rem;
            text-align: center;
            text-transform: uppercase;
        }

        .card {
            background: white;
            border: none;
            border-radius: 15px;
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            margin-bottom: 2rem;
        }

        .card-body {
            padding: 2rem;
        }

        .btn-back {
            background: #e2e8f0;
            border: none;
            color: #475569;
            padding: 0.75rem 1.5rem;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s ease;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }

        .btn-back:hover {
            background: #cbd5e1;
            color: #1e293b;
        }

        .upload-info {
            background: rgba(14, 165, 233, 0.1);
            border-radius: 8px;
            padding: 1rem;
            margin-bottom: 1rem;
        }

        .upload-info ul {
            margin-bottom: 0;
            padding-left: 1.2rem;
        }

        .upload-info li {
            color: #0369a1;
            font-size: 0.9rem;
            margin-bottom: 0.5rem;
        }

        .upload-info li:last-child {
            margin-bottom: 0;
        }
    </style>
</head>
<body>
    <?php include '../includes/sidebar.php'; ?>
    
    <div class="container-fluid">
        <div class="header-wrapper">
            <h1>Upload File Telaah Staf</h1>
        </div>

        <div class="card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <a href="detail.php?id=<?= $id ?>" class="btn-back">
                        <i class="bi bi-arrow-left"></i>
                        Kembali
                    </a>
                </div>

                <?php if (isset($error)): ?>
                    <div class="alert alert-danger" role="alert">
                        <?= $error ?>
                    </div>
                <?php endif; ?>

                <div class="upload-info">
                    <h5 class="mb-3">Informasi Upload:</h5>
                    <ul>
                        <li>File harus dalam format PDF</li>
                        <li>Ukuran file maksimal 5MB</li>
                        <li>File yang diunggah adalah telaah staf yang sudah ditandatangani</li>
                        <li>File lama akan otomatis terhapus jika Anda mengunggah file baru</li>
                    </ul>
                </div>

                <form method="POST" enctype="multipart/form-data">
                    <div class="mb-4">
                        <label for="file_telaah" class="form-label">File Telaah Staf</label>
                        <input type="file" class="form-control" id="file_telaah" name="file_telaah" accept=".pdf" required>
                    </div>

                    <div class="d-flex justify-content-end gap-2">
                        <a href="detail.php?id=<?= $id ?>" class="btn btn-secondary">Batal</a>
                        <button type="submit" class="btn btn-primary">Upload File</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html> 