<?php
session_start();
require_once '../config/database.php';
require_once '../config/config.php';

// Check if user is logged in
if (!isset($_SESSION['user_id'])) {
    header("Location: " . BASE_URL . "/login.php");
    exit();
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        $telaah_id = $_POST['telaah_id'];
        
        // Get telaah number from database
        $query = "SELECT nomor FROM telaah_staf WHERE id = ?";
        $stmt = mysqli_prepare($conn, $query);
        mysqli_stmt_bind_param($stmt, "i", $telaah_id);
        mysqli_stmt_execute($stmt);
        $result = mysqli_stmt_get_result($stmt);
        $telaah = mysqli_fetch_assoc($result);
        
        if (!$telaah) {
            throw new Exception("Telaah staf tidak ditemukan");
        }

        // Clean the nomor for filename
        $clean_nomor = preg_replace('/[^a-zA-Z0-9]/', '_', $telaah['nomor']);
        
        if (isset($_FILES['signed_file']) && $_FILES['signed_file']['error'] === UPLOAD_ERR_OK) {
            $file = $_FILES['signed_file'];
            $file_extension = pathinfo($file['name'], PATHINFO_EXTENSION);
            
            // Create filename using telaah number
            $filename = "telaah_" . $clean_nomor . "." . $file_extension;
            $upload_path = "../uploads/signed_telaah/";
            
            // Create directory if it doesn't exist
            if (!file_exists($upload_path)) {
                mkdir($upload_path, 0777, true);
            }
            
            // Remove old file if exists
            $query = "SELECT signed_file FROM telaah_staf WHERE id = ?";
            $stmt = mysqli_prepare($conn, $query);
            mysqli_stmt_bind_param($stmt, "i", $telaah_id);
            mysqli_stmt_execute($stmt);
            $result = mysqli_stmt_get_result($stmt);
            $old_file = mysqli_fetch_assoc($result);
            
            if ($old_file && !empty($old_file['signed_file'])) {
                $old_file_path = $upload_path . $old_file['signed_file'];
                if (file_exists($old_file_path)) {
                    unlink($old_file_path);
                }
            }
            
            // Upload new file
            if (move_uploaded_file($file['tmp_name'], $upload_path . $filename)) {
                // Update database
                $query = "UPDATE telaah_staf SET signed_file = ? WHERE id = ?";
                $stmt = mysqli_prepare($conn, $query);
                mysqli_stmt_bind_param($stmt, "si", $filename, $telaah_id);
                
                if (mysqli_stmt_execute($stmt)) {
                    $_SESSION['success'] = "File berhasil diupload dengan nama: " . $filename;
                    header("Location: index.php");
                    exit();
                } else {
                    throw new Exception("Gagal mengupdate database");
                }
            } else {
                throw new Exception("Gagal mengupload file");
            }
        } else {
            throw new Exception("File tidak valid atau tidak ada");
        }
    } catch (Exception $e) {
        $_SESSION['error'] = "Error: " . $e->getMessage();
        header("Location: index.php");
        exit();
    }
} else {
    header("Location: index.php");
    exit();
}
?> 