<?php
session_start();
require_once 'config/config.php';

header('Content-Type: application/json');

try {
    if (!isset($_POST['otp']) || empty($_POST['otp'])) {
        throw new Exception('Kode OTP harus diisi');
    }

    $otp = $_POST['otp'];

    // Cek OTP di database
    $stmt = $conn->prepare("SELECT id, username FROM users WHERE otp = ? AND status = 'pending'");
    $stmt->bind_param("s", $otp);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        throw new Exception('Kode OTP tidak valid atau akun sudah diaktifkan');
    }

    $user = $result->fetch_assoc();

    // Update status user menjadi active
    $stmt = $conn->prepare("UPDATE users SET status = 'active', otp = NULL WHERE id = ?");
    $stmt->bind_param("i", $user['id']);
    
    if ($stmt->execute()) {
        // Set session untuk user yang baru diaktifkan
        $_SESSION['activation_success'] = true;
        
        echo json_encode([
            'status' => 'success',
            'message' => 'Verifikasi berhasil! Akun Anda telah aktif.'
        ]);
    } else {
        throw new Exception('Gagal mengaktifkan akun');
    }

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'status' => 'error',
        'message' => $e->getMessage()
    ]);
} catch (Error $e) {
    error_log("OTP Verification Error: " . $e->getMessage());
    http_response_code(500);
    echo json_encode([
        'status' => 'error',
        'message' => 'Terjadi kesalahan pada server. Silakan coba lagi.'
    ]);
} finally {
    if (isset($stmt)) {
        $stmt->close();
    }
    if (isset($conn)) {
        $conn->close();
    }
} 